VERSION 2.00
Begin Form Form1 
   Caption         =   "Left-Aligned Caption"
   ClientHeight    =   3330
   ClientLeft      =   1080
   ClientTop       =   1515
   ClientWidth     =   6420
   Height          =   3735
   Left            =   1020
   LinkTopic       =   "Form1"
   ScaleHeight     =   3330
   ScaleWidth      =   6420
   Top             =   1170
   Width           =   6540
   Begin MsgHook MsgHook 
      Left            =   135
      Top             =   180
   End
   Begin Timer Timer1 
      Interval        =   1000
      Left            =   810
      Top             =   180
   End
End
Option Explicit

' Routine within MsgHook which calls default window procedure
Declare Function InvokeWindowProc Lib "MsgHook.vbx" (ByVal hWnd As Integer, ByVal Msg As Integer, ByVal wParam As Integer, ByVal lParam As Long) As Long

' We want to catch messages causing non-client repaints
Const WM_NCPAINT = &H85
Const WM_NCACTIVATE = &H86
Const WM_SIZE = &H5

' Store Caption as a string
Dim Kaption As String

Sub Form_Load ()
   '
   ' Set Caption to "", storing whatever was set at design
   '
   Kaption = Me.Caption
   Me.Caption = ""
   '
   ' Setup MsgHook control
   '
   MsgHook.HwndHook = Me.hWnd
   MsgHook.Message(WM_NCPAINT) = True
   MsgHook.Message(WM_NCACTIVATE) = True
   MsgHook.Message(WM_SIZE) = True
End Sub

Sub MsgHook_Message (Msg As Integer, wParam As Integer, lParam As Long, Result As Long)
   Static PrevState As Integer
   '
   ' Fire default window procedure before processing
   ' any of the messages we're interested in for this
   ' task.
   '
   Result = InvokeWindowProc(MsgHook.HwndHook, Msg, wParam, lParam)
   '
   ' Check which message arrived, and act accordingly.
   '
   Select Case Msg
      Case WM_NCPAINT
         '
         ' Check whether to paint as active or inactive
         '
         RefreshCaption Kaption, Me, (GetActiveWindow() = Me.hWnd)
      Case WM_NCACTIVATE
         '
         ' wParam indicates active or inactive
         '
         RefreshCaption Kaption, Me, wParam
      Case WM_SIZE
         '
         ' Supply Caption for minimized icon only
         '
         If wParam = SIZE_MINIMIZED Then 'Minimized
            Me.Caption = Kaption
         ElseIf PrevState = SIZE_MINIMIZED Then
            Kaption = Me.Caption
            Me.Caption = ""
            RefreshCaption Kaption, Me, True
         End If
         '
         ' Store "last" WindowState
         '
         PrevState = Me.WindowState
   End Select
End Sub

Sub Timer1_Timer ()
   Dim TmpCaption As String
   '
   ' Adorn visible caption with extra text
   '
   TmpCaption = Kaption & " -- " & Format$(Now, "h:mm:ssam/pm")
   RefreshCaption TmpCaption, Me, (GetActiveWindow() = Me.hWnd)
End Sub

Sub UpdateCaption (NewCaption$)
   '
   ' Provide an easy means to update the Caption at will.
   '
   Kaption = NewCaption
   If Me.WindowState = SIZE_MINIMIZED Then
      Me.Caption = NewCaption
   Else
      RefreshCaption Kaption, Me, (GetActiveWindow() = Me.hWnd)
   End If
End Sub

