/*
** SCSI Disk Formatter (Low Level)
**
** usage: sformat drive: [interleave]
**
** Revision History:
**
** Version 1.0  08/03/90 Initial Release
**
** Version 1.1  08/20/90 Add verification message.
**
** Version 1.2  09/18/90 Correct ioctl_data struct.
*/
#include <stdio.h>
#include <dos.h>

#define TRUE (1)
#define FALSE (0)
#define VERSION "sformat Version 1.2 BWA"

extern int _doserrno;

struct cmd {
	short command;		/* command type */
	short arg1;			/* command args */
	short arg2;			/* command args */
} ioctl_data;
union REGS inregs, outregs;
struct SREGS segregs;
unsigned short interleave = 0;
unsigned char drive;
char far *cp;

main(argc, argv)
int argc;
char *argv[];
{
	/*
	** say hello
	*/
	puts(VERSION);

	/*
	** figure out who to format
	*/
	switch (argc)
	{
		case 3:
		interleave = atoi(argv[2]);
		case 2:
		if (argv[1][1] != ':') usage();
		drive = argv[1][0];
		drive = toupper(drive);
		drive -= '@';
		break;

		default:
		usage();
		break;
	}

	/*
	** verify that this is what the user really wants to do
	*/
	printf("Do you really wish to format the SCSI\n");
	printf("device that contains drive %c: (y,n)? ", argv[1][0]);
	fflush(stdout);
	if ( getchar() != 'y' )
	{
		puts("Aborting low level format ....");
		exit(1);
	}

	/*
	** put together the command
	*/
	inregs.h.ah = 0x44;			/* ioctl */
	inregs.h.al = 0x05;			/* write */
	inregs.h.bl = drive;		/* unit */
	inregs.x.cx = sizeof(struct cmd);
	cp = (char *) &ioctl_data;
	inregs.x.dx = FP_OFF(cp);
	segregs.ds = FP_SEG(cp);
	ioctl_data.command = 'F';
	ioctl_data.arg1 = interleave;

	/*
	** start the format
	*/
	puts("Now formating ....");
	puts("Please wait ....");
	intdosx(&inregs, &outregs, &segregs);

	/*
	** see what happened
	*/
	if ( outregs.x.cflag )
		printf("DOS error %d occured during format.\n", _doserrno);
	else
		puts("Formating complete.");
	exit(0);
}

usage()
{
	puts("usage: sformat drive: [interleave]");
	exit(1);
}
