//
// regximp.h   : regular expression implementation class interface
// Author      : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
// Version 2.00     10/20/92
//
#ifndef _REGXIMP_H
#define _REGXIMP_H

#ifndef _STR_H
#include "str.h"
#endif


class regXimp{
   str compiledPattern;
   int caseSensitive;

   const char * doccl(const char * src);

   int omatch(const char ** strp, const unsigned char * pat, 
              const char * start);

   const char * patcmp(const char * str, const unsigned char * pat,
                       const char * start);

public:
   int error;
   const char * startMatch;
   const char * endMatch;

   int makepat(const char *exp);
   const char * matchs(const char * str, int p_caseSensitive);

   regXimp(void);
};

#endif
