//
// BCstr.cpp -- Borland object based str implementation
// Author  : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
// Version 1.00     10/20/92
//
#include "BCstr.h"
#include <stdlib.h>

BCstr::BCstr (void):str(){};
BCstr::BCstr (int p_bufsize, int p_incr):str(p_bufsize, p_incr){};
BCstr::BCstr (const char * s, int p_bufsize, int p_incr):
     str(s,p_bufsize, p_incr){};
BCstr::BCstr (const str& s, int p_bufsize, int p_incr):
          str(s,p_bufsize, p_incr){};
BCstr::BCstr (const BCstr& s, int p_bufsize, int p_incr):
          str(s, p_bufsize, p_incr){};

// Relational Operators
int BCstr::isLessThan(const Object& b) const{
  return compare(*this, (BCstr &) b)<0;
};

int BCstr::isEqual(const Object& b) const{
  return compare(*this, (BCstr &) b)==0;
};


hashValueType BCstr::hashValue() const  // use Borland's String hash function
{
    hashValueType   value = hashValueType(0);
    for( int i = 0; i < length(); i++ )
        {
        value ^= data->buf[i];
        value = _rotl( value, 1 );
        }
    return value;
}

void BCstr::printOn( ostream& outputStream ) const
{
    outputStream << (str&)*this;
}

