/***************************************************/
/* Installation Script for S-Tris                  */
/* (c) 1995 R. Straub                              */
/***************************************************/


CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'	/* Make REXX functions available */
CALL SysLoadFuncs

PARSE Arg InstallDir     									/* Command line parameter */
SIGNAL On Halt Name ErrorHandler							/* Error handler */

CALL SysCls

SAY
SAY
SAY " S-Tris Installation "
SAY " ------------------- "

IF InstallDir=" " THEN DO									/* If no path is given, get one from the user */
    SAY
    SAY " Please specify the name of the directory to"
    SAY " which you would like to install S-Tris, hit <Enter>"
    SAY " to use the current directory, or type 'Q'<Enter>"
    SAY " to quit."
    SAY
    SAY " For Example:  E:\GAMES\STRIS<Enter>"
    SAY
    SAY " Please specify:"									/* Prompt for input */

    PARSE Value SysCurPos() with Row Col
    Col = Col+17
    Row = Row-1

    CALL SysCurPos Row, Col
    PULL InstallDir
    IF (InstallDir="Q") | (InstallDir="q") THEN EXIT		/* Quit if they hit 'Q' */
END

SAY

CurrentDir = directory()									/* Find the current directory */
  
IF (InstallDir=" ") Then InstallDir=CurrentDir				/* Set to the current directory if none given */

  IF (CurrentDir\=directory(InstallDir)) THEN DO			/* If installing to different dir, do copying bit */

    Command = '@CD 'directory(CurrentDir)					/* Switch back to installation dir */
    Command

    CALL SysFileTree InstallDir, FileDirectory, 'D'			/* Search for new directory */

    IF FileDirectory.0='0' Then Do							/* If not found, create it */
      SAY " Now creating directory "InstallDir

      rc=SysMkDir(InstallDir)
      IF rc\=0 THEN DO
        SAY
        SAY " Error : The desired directory couldn't be created,"
        SAY " probably because you specified an invalid directory name"
        SAY " or the destination disk is write-protected."
        EXIT
      END

    END

  SAY " Now copying files to "InstallDir" ..."			/* Now copy files */
 
  CALL FileCopy 'STris.EXE' InstallDir
  CALL FileCopy 'Read.Me' InstallDir

END

SAY " Creating WPS program object ..."					/* Create WPS-Desktop object */

LastChar = substr(InstallDir,length(InstallDir),1)		/* See if directory terminates in a \ */

IF LastChar = "\" THEN SetupString="EXENAME="InstallDir"STris.exe;STARTUPDIR="InstallDir
ELSE                   SetupString="EXENAME="InstallDir"\STris.exe;STARTUPDIR="InstallDir

rc=SysCreateObject("WPProgram","S-Tris","<WP_DESKTOP>",SetupString,UPDATE)
IF rc=0 THEN DO
  SAY
  SAY " WARNING : Couldn't create program object on WPS."
  EXIT
END

SAY " Now you get to read the README.TXT file ..."

Command='@E READ.ME'										/* Look at the README.TXT */
Command

SAY
SAY " S-Tris has been successfully installed. Have fun ..."

EXIT


/***************************************************/
/* File Copy                                       */
/***************************************************/

FileCopy: Arg FileName, Destination
    
  Command='@Copy 'FileName' 'Destination' >NUL'
  Command

  IF rc\=0 THEN DO										/* Error copying file */
    SAY " ERROR : Failed to copy file "FileName". Installation aborted ..."
    EXIT
  END

RETURN


/***************************************************/
/* Error handler                                   */
/***************************************************/


ErrorHandler:

  CALL SysCls
  SAY " Error while installing S-Tris ! Installation aborted ..."

EXIT


