/*
This file contains an example of a dialog procedure that supports control 
colors and fonts in a dialog box. 

Warning1: the dialog is assumed to be modal, therefore ctlprops, frmprops and
hbrLast can be static. Every form should have its own dialog procedure with 
static data. This code is simplistic; in real life you would store
CTLINIT information in dialog window data area or associated C++ class 
instance.

Warning2: this code does not support VBX controls. It ssumes you have 
selected 'NO VBX' in Storc conversion options. 
The box will not appear AT ALL if you have even a SINGLE VBX control 
(unregstered class "VBControl") on the script!!! 
If you are using Microsoft C++, you have to use MFC to be able to use VBX 
contols. If you use Borland C 4, you could easily add VBX support to this code;
however this is Borland-specific, and therefore non-portable).

The code is reusing hbrLast in an attempt to save GDI resources. Only one
brush is used at a time.

In order to be colored properly, comboboxes should be subclassed. This is 
achieved by code in combobox.c (combosub.h)
*/

#include <windows.h>
#include <string.h>
#include "ctlinit.h"  //provided with Storc
#include "combosub.h" //-"-

BOOL CALLBACK _export /*>formname*/DialogProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam){
 
 static CTLINIT ctlprops[]={ //holds fonts/colors for all controls
  //[...] paste from Storc output
  //e.g.: {0,"MS Sans Serif",8.25,0,TRUE,FALSE,FALSE,FALSE,RGB(0,0,0),RGB(0,0,0)},
 };
 static CTLINIT frmprops={ //holds font and background brush color for the dialog itself
  //[...] paste from Storc output
  //e.g.: 0,"MS Sans Serif",8.25,0,TRUE,FALSE,FALSE,FALSE,RGB(0,0,0),RGB(0,0,0)
 };  //hFont is unused
 static HBRUSH hbrLast=0;//the only brush handle used
 
 switch(msg){
  case WM_COMMAND:
	 if (wParam==IDCANCEL){ 
	  EndDialog(hwndDlg, FALSE);
	 }
	 break; 
  case WM_INITDIALOG:
  { //create fonts for all controls (no duplication, reuse handles)
	 int i;
	 for (i=0;i<sizeof(ctlprops)/sizeof(*ctlprops);i++){ //for all controls 
	  //find out if font handle already created for this font
	  int iprev;
	  for (iprev=0;iprev<i;iprev++){
		if (strcmp(ctlprops[i].fontface, ctlprops[iprev].fontface)==0 &&
			 ctlprops[i].fontsize == ctlprops[iprev].fontsize &&
			 ctlprops[i].IsBold          == ctlprops[iprev].IsBold          &&
			 ctlprops[i].IsItalic        == ctlprops[iprev].IsItalic        &&
			 ctlprops[i].IsUnderlined    == ctlprops[iprev].IsUnderlined    &&
			 ctlprops[i].IsStrikethrough == ctlprops[iprev].IsStrikethrough
		){
		 ctlprops[i].hFont = ctlprops[i].hFont;
		 break;
		}
	  }
	  if (!ctlprops[i].hFont && *(ctlprops[i].fontface)) { //not found, have to create a new font
		int sz;
		static int sy=0; //filled once only
		if (!sy) {
		  HDC wdc=GetDC(hwndDlg);
		  sy = GetDeviceCaps(wdc, LOGPIXELSY);
		  ReleaseDC(hwndDlg, wdc);
		}
		sz = -(float)ctlprops[i].fontsize*sy/72.0;
		ctlprops[i].hFont =  CreateFont( sz, 
			0, 0, 0, 
			(ctlprops[i].IsBold?FW_BOLD:FW_NORMAL), 
			ctlprops[i].IsItalic, 
			ctlprops[i].IsUnderlined, 
			ctlprops[i].IsStrikethrough, 
			0, 0, 0, 0, 0, ctlprops[i].fontface);   
	  }
	  SendMessage(  GetDlgItem(hwndDlg,ctlprops[i].id), 
			WM_SETFONT, 
			(WPARAM)ctlprops[i].hFont,0L); //hFont is 0 for default font
	  //if this is a combobox, subclass it
	  { HWND hwndControl=GetDlgItem(hwndDlg,ctlprops[i].id);
		char buf[50]=""; //will hold windows classname of the control
		GetClassName(hwndControl,buf,sizeof(buf));
		if (stricmp(buf,"combobox")==0)
		  SubclassCombobox(hwndControl);
	  }
	 } //for all controls
  }//WM_INITDIALOG
	break;
  case WM_CTLCOLOR:
  {
    int i;
    HDC  dc = (HDC) wParam;
    HWND hwndChild = (HWND) LOWORD(lParam);
    //find the control data
    CTLINIT init = frmprops; //if control data not found, form data will be used
    for (i=0;i<sizeof(ctlprops)/sizeof(*ctlprops);i++) {
      if (hwndChild == GetDlgItem(hwndDlg,ctlprops[i].id)){
       init = ctlprops[i];
       break;
      }
    }
    //set text foreground and background to dc
    SetBkColor  ( dc, init.backgroundbr);
    SetTextColor( dc, init.foreground);
       
    if (hbrLast) DeleteObject(hbrLast);

    hbrLast = CreateSolidBrush(init.backgroundbr);
    return hbrLast;

  } //WM_CTLCOLOR
  
  case WM_DESTROY:
  {
    int i,inext;
    for (i=0;i<sizeof(ctlprops)/sizeof(*ctlprops);i++) {
      //destroy fonts
      HFONT hFont = ctlprops[i].hFont;
      //make sure the control uses default font
      SendMessage(GetDlgItem(hwndDlg, ctlprops[i].id), WM_SETFONT, 0, 0L);
      DeleteObject(hFont);
      //find and set to 0 all further occurences of same font handle
      for (inext=i+1;inext<sizeof(ctlprops)/sizeof(*ctlprops);inext++){
	if ( hFont == ctlprops[inext].hFont )
	 ctlprops[inext].hFont=0;
      }
      ctlprops[i].hFont=0;
    }
    DeleteObject(frmprops.hFont);
    DeleteObject(hbrLast);
  }
 }
 return FALSE;
}
