/*
calccrc.c
Stealth Bomber Version 2.2

Kevin Dean
Fairview Mall P.O. Box 55074
1800 Sheppard Avenue East
Willowdale, Ontario
CANADA    M2J 5B9
CompuServe ID: 76336,3114

February 10, 1992

	This module calculates the CRC of a file.

	This code is public domain.
*/


#include <stdio.h>

#include "vircheck.h"


/* Macros to extract low and high bytes of a word. */
#define lowb(x)  (*(unsigned char *)&(x))
#define hib(x)   (*((unsigned char *)&(x) + 1))

/* Macros to extract low and high words of a dword. */
#define loww(x)  (*(unsigned short *)&(x))
#define hiw(x)   (*((unsigned short *)&(x) + 1))


/***/
/* Calculate the CRC of a file. The file is assumed to be open and the buffer is assumed to be valid. */
crc32_t calccrc(FILE *f, byte *buffer, size_t bufsize, crc32_t polynomial)
{
crc32_t table[256];		/* CRC table. */
register size_t i;		/* Byte counter. */
register crc32_t *halfi;	/* Pointer to CRC of i / 2. */
crc32_t crc;			/* Current CRC. */
byte *bufptr;			/* Pointer to walk through buffer. */

/* Generate a CRC lookup table for faster calculation. */
for (i = 0, halfi = table, table[0] = 0; i < 256; i += 2, halfi++)
  if (hib(hiw(*halfi)) & 0x80)
    table[i] = (table[i + 1] = *halfi << 1) ^ polynomial;
  else
    table[i + 1] = (table[i] = *halfi << 1) ^ polynomial;

/* Calculate CRC. */
crc = 0;
while ((i = fread(buffer, 1, bufsize, f)) != 0)
  for (bufptr = buffer; i--; bufptr++)
    crc = (crc << 8) ^ table[hib(hiw(crc)) ^ *bufptr];

return (crc);
}
