/************************************************
 **************    StickIt.c   ******************
 ************************************************/

#define INTUI_V36_NAMES_ONLY

#include <exec/types.h>
#include <intuition/intuition.h>
#include <intuition/classes.h>
#include <intuition/classusr.h>
#include <intuition/imageclass.h>
#include <intuition/gadgetclass.h>
#include <libraries/gadtools.h>
#include <graphics/displayinfo.h>
#include <graphics/gfxbase.h>
#include <workbench/startup.h>
#include <workbench/workbench.h>
#include <dos/dos.h>

#include <clib/alib_protos.h>
#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/graphics_protos.h>
#include <clib/diskfont_protos.h>
#include <clib/utility_protos.h>
#include <clib/icon_protos.h>
#include <clib/dos_protos.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "stickit.h"

#include "consts.h"
#include "structs.h"
#include "prototype.h"

struct IntuitionBase  *IntuitionBase = NULL;
struct Library *GfxBase = NULL;
struct Library *GadToolsBase = NULL;
struct Library *UtilityBase = NULL;
struct Library *DiskfontBase = NULL;
struct Library *IconBase = NULL;

extern struct Gadget *editGadgets[];

extern struct WBStartup *WBenchMsg;

prjptr prj = NULL;

/***   Version string   ***/

char *version = "$VER: StickIt V1.03 15th November '93 1993 Andy Dean";

int main(int argc, char **argv)
   {
   /***   Open Libraries   ***/

   if (!(IntuitionBase = (struct IntuitionBase *)OpenLibrary
                  ("intuition.library",OS_VER)))
      cleanup();

   if (!(GfxBase = OpenLibrary("graphics.library",OS_VER)))
      cleanup();

   if (!(GadToolsBase = OpenLibrary("gadtools.library",OS_VER)))
      cleanup();

   if (!(UtilityBase = OpenLibrary("utility.library",OS_VER)))
      cleanup();

   if (!(DiskfontBase = OpenLibrary("diskfont.library",36)))
      cleanup();

   if (!(IconBase = OpenLibrary("icon.library",OS_VER)))
      cleanup();

   /***   Main program    ***********************************************/

   init(argc);

   /***   Get lock on screen   ***/

   if (SetupScreen())
      cleanup();

   /***   How do we look when we open up ?   ***/

   while (!prj->quit)
      {
      if ((prj->editnotes) || (prj->startedit) || (prj->no_notes == 0))
         {
         prj->startedit = FALSE;
         openedit();
         }
      else
         shownotes();
      }

   /*********************************************************************/

   cleanup();
   }

void init(int argc)
   {
   prj = (prjptr)malloc(sizeof(struct project));

   if (!prj)
      error("Could not allocate prj",ERR_MALLOC);
      
   prj->no_notes = 0;
   prj->no_notes_visable = 0;

   prj->notes_start = prj->notes_end = NULL;

   prj->editnotes = FALSE;
   prj->showedit = TRUE;
   prj->startedit = FALSE;
   prj->abouttoclose = FALSE;
   prj->quit = FALSE;

   prj->filechanged = prj->titlechanged = prj->notechanged = FALSE;

   prj->delay = 0;

   strncpy(prj->notefile,"StickIt.notes",STRLEN_FNAME);
   prj->backcolour = 0;
   prj->textcolour = 1;

   prj->notefont.ta_Name = prj->fontname;
   strncpy(prj->fontname,"Helvetica.font",STRLEN_FONTNAME);

   prj->notefont.ta_YSize = 12;
   prj->notefont.ta_Style = NULL;
   prj->notefont.ta_Flags = NULL;

   prj->msgport = NULL;
   prj->notefontptr = NULL;

   prj->currnode = NULL;
   prj->copybuffernode = NULL;

   prj->noteheight = 70;
   prj->notewidth = 150;

   prj->nextx = 40;
   prj->nexty = 20;

   if (!argc)
      readtooltypes();

   /***   Startup delay to stop disk thrashing   ***/

   Delay(prj->delay * 50);

   initlists();
   readnotefile();

   /***   If no notes, don't show edit window if user doesn't want it   ***/

   if ((prj->no_notes == 0) && (!prj->startedit))
      cleanup();

   /***   Open font   ***/

   prj->notefontptr = OpenDiskFont(&prj->notefont);

   if (!prj->notefontptr)
      prj->notefontptr = ((struct GfxBase *)GfxBase)->DefaultFont;
              
   }

void cleanup()
   {
   /***   Remove any notes that may be on the screen   ***/

   if (prj)
      removenotes();

   /***   Call GadToolsBox routines to shut everything down   ***/

   CloseaboutWindow();
   CloseeditWindow();
   CloseDownScreen();

   if (prj) {
      /***   Close font   ***/

     if ((prj->notefontptr) && 
               (prj->notefontptr != ((struct GfxBase *)GfxBase)->DefaultFont))
         CloseFont(prj->notefontptr);

      prj->notefontptr = NULL;

      /***   Remove linked list   ***/

      if (prj->notes_start)
         llfree(prj->notes_start);

      /**   Remove copy buffer   ***/

      if (prj->copybuffernode)
         {
         if (prj->copybuffernode->data)
            free((void *)prj->copybuffernode->data);

         free((void *)prj->copybuffernode);
        }

      /***   Remove message port   ***/

      if (prj->msgport)
         DeleteMsgPort(prj->msgport);

      /***   Finally, remove prj   ***/

      if(prj)
         free((void *)prj);
   }

   /***   Close libraries   ***/

   if (IconBase)
      CloseLibrary(IconBase);

   if (DiskfontBase)
      CloseLibrary(DiskfontBase);

   if (UtilityBase)
      CloseLibrary(UtilityBase);

   if (GadToolsBase)
      CloseLibrary(GadToolsBase);

   if (GfxBase)
      CloseLibrary(GfxBase);

   if (IntuitionBase)
      CloseLibrary((struct Library *)IntuitionBase);

   exit(20);
   }

void readtooltypes()
   {
   struct DiskObject *diskobj;

   char *toolstring;

   LONG value;

   if (WBenchMsg)
      {
      diskobj = GetDiskObject(WBenchMsg->sm_ArgList[0].wa_Name);

      if (diskobj)
         {
         /***   Our notefile   ***/

         toolstring = FindToolType(diskobj->do_ToolTypes,"NOTEFILE");

         if (toolstring)
            strncpy(prj->notefile,toolstring,STRLEN_FNAME);

         /***   Font   ***/

         toolstring = FindToolType(diskobj->do_ToolTypes,"FONTNAME");

         if (toolstring)
            strncpy(prj->fontname,toolstring,STRLEN_FONTNAME);

         toolstring = FindToolType(diskobj->do_ToolTypes,"FONTSIZE");

         if (toolstring)
            {
            StrToLong(toolstring,&value);
            prj->notefont.ta_YSize = (UWORD)value;
            }

         /***   Start with edit window if no notes in file ?   ***/

         toolstring = FindToolType(diskobj->do_ToolTypes,"STARTEDIT");

         if (toolstring)
            prj->startedit = (Stricmp(toolstring,"YES")?FALSE:TRUE);

         /***   Colours   ***/

         toolstring = FindToolType(diskobj->do_ToolTypes,"BACKCOLOUR");

         if (toolstring)
            {
            StrToLong(toolstring,&value);
            prj->backcolour = (int)value;
            }

         toolstring = FindToolType(diskobj->do_ToolTypes,"TEXTCOLOUR");

         if (toolstring)
            {
            StrToLong(toolstring,&value);
            prj->textcolour = (int)value;
            }

         /***   Opening delay to stop disk thrashing   ***/

         toolstring = FindToolType(diskobj->do_ToolTypes,"DELAY");

         if (toolstring)
            {
            StrToLong(toolstring,&value);
            prj->delay = (ULONG)value;
            }

         /***   Note sizes   ***/

         toolstring = FindToolType(diskobj->do_ToolTypes,"NOTEHEIGHT");

         if (toolstring)
            {
            StrToLong(toolstring,&value);
            prj->noteheight = (UWORD)value;
            }

         toolstring = FindToolType(diskobj->do_ToolTypes,"NOTEWIDTH");

         if (toolstring)
            {
            StrToLong(toolstring,&value);
            prj->notewidth = (UWORD)value;
            }


         FreeDiskObject(diskobj);
         }
      }
   }
