/*****************************************
 *************   general.c   *************
 *****************************************/

#include <dos/dos.h>
#include <exec/types.h>
#include <intuition/intuition.h>
#include <intuition/classes.h>
#include <intuition/classusr.h>
#include <intuition/imageclass.h>
#include <intuition/gadgetclass.h>
#include <libraries/gadtools.h>
#include <graphics/displayinfo.h>
#include <graphics/gfxbase.h>
#include <graphics/text.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/graphics_protos.h>
#include <clib/utility_protos.h>
#include <clib/diskfont_protos.h>
#include <clib/dos_protos.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "stickit.h"

#include "consts.h"
#include "structs.h"
#include "prototype.h"

extern struct IntuitionBase *IntuitionBase;

extern struct Screen *Scr;

extern prjptr prj;

extern struct Gadget *editGadgets[];

struct EasyStruct reqwarn =
   {
   sizeof (struct EasyStruct),
   0,
   "StickIt...",
   "Warning, %s",
   "Continue",
   };
            
struct EasyStruct reqfatal =
   {
   sizeof (struct EasyStruct),
   0,
   "StickIt...",
   "Fatal error, %s",
   "Quit",
   };

UWORD __chip waitPointer[] =
   {
   0x0000, 0x0000,     /* reserved, must be NULL */
               
   0x0400, 0x07C0,
   0x0000, 0x07C0,
   0x0100, 0x0380,
   0x0000, 0x07E0,
   0x07C0, 0x1FF8,
   0x1FF0, 0x3FEC,
   0x3FF8, 0x7FDE,
   0x3FF8, 0x7FBE,
   0x7FFC, 0xFF7F,
   0x7EFC, 0xFFFF,
   0x7FFC, 0xFFFF,
   0x3FF8, 0x7FFE,
   0x3FF8, 0x7FFE,
   0x1FF0, 0x3FFC,
   0x07C0, 0x1FF8,
   0x0000, 0x07E0,
              
   0x0000, 0x0000,     /* reserved, must be NULL */
   };
         
void error(char *msg,int number)
   {
   LONG reply;

   if ((IntuitionBase) && (number < ERR_FATAL))
      reply = EasyRequest(NULL,&reqwarn,NULL,(APTR)msg);
   else if ((IntuitionBase) && (number >= ERR_FATAL))
      reply = EasyRequest(NULL,&reqfatal,NULL,(APTR)msg);

   if (number >= ERR_FATAL)
      cleanup();
   }

void printfnotes()
   {
   struct ndnode *ndptr;
   nteptr currnote;
   int noteno = 0;

   ndptr = prj->notes_start->next;

   printf("Printing notes (%d in total)...\n",prj->no_notes);

   while (ndptr->next)
      {
      currnote = ndptr->data;

      printf("\t... Note number %d\n",++noteno);
      printf("\t... (xpos,ypos) : (%d,%d)\n",currnote->xpos,
         currnote->ypos);
      printf("\t... (title) : (%s)\n",currnote->title);
      printf("\t... (note) : (%s)\n\n",currnote->note);

      ndptr = ndptr->next;
      }
   }

void andysoffgadget(struct Gadget *gad, struct Window *win)
   {
   if (!(gad->Flags & GFLG_DISABLED))
      GT_SetGadgetAttrs(gad,win,NULL,GA_Disabled,TRUE,TAG_END);
   }

void andysongadget(struct Gadget *gad, struct Window *win)
   {
   if (gad->Flags & GFLG_DISABLED)
      GT_SetGadgetAttrs(gad,win,NULL,GA_Disabled,FALSE,TAG_END);
   }

void andysselectgadget(struct Gadget *gad, struct Window *win)
   {
   if (!(gad->Flags & GFLG_SELECTED))
      GT_SetGadgetAttrs(gad,win,NULL,GTCB_Checked,TRUE,TAG_END);
   }

void andysunselectgadget(struct Gadget *gad, struct Window *win)
   {
   if (gad->Flags & GFLG_SELECTED)
      GT_SetGadgetAttrs(gad,win,NULL,GTCB_Checked,FALSE,TAG_END);
   }

void storenote()
   {
   nteptr currnote;

   if (prj->currnode)
      {
      currnote = prj->currnode->data;

      /***   The 2 tests below are done like this for speed   ***/

      if (prj->titlechanged)
         {
         strncpy(currnote->title,GetString(editGadgets[GDX_title]),STRLEN_TITLE);
         prj->filechanged = TRUE;
         }
      else if (strncmp(currnote->title,GetString(editGadgets[GDX_title]),STRLEN_TITLE))
         {
         strncpy(currnote->title,GetString(editGadgets[GDX_title]),STRLEN_TITLE);
         prj->filechanged = TRUE;
         }

      if (prj->notechanged)
         {
         strncpy(currnote->note,GetString(editGadgets[GDX_note]),STRLEN_NOTE);
         prj->filechanged = TRUE;
         }
      else if (strncmp(currnote->note,GetString(editGadgets[GDX_note]),STRLEN_NOTE))
         {
         strncpy(currnote->note,GetString(editGadgets[GDX_note]),STRLEN_NOTE);
         prj->filechanged = TRUE;
         }

      currnote->show = editGadgets[GDX_show]->Flags & GFLG_SELECTED;
      }
   else
      {
      if ((strlen(GetString(editGadgets[GDX_title])) != 0) ||
            (strlen(GetString(editGadgets[GDX_note])) != 0))
         prj->filechanged = TRUE;
      }

   prj->titlechanged = prj->notechanged = FALSE;
   }

void createcopybuffernode()
   {
   prj->copybuffernode = llealloc();
   prj->copybuffernode->data = notealloc();

   if (!prj->copybuffernode->data)
      error("createcopybuffernode; Can't allocate note",ERR_MALLOC);
   }

nteptr notealloc()
   {
   nteptr newnote;

   newnote = (nteptr)malloc(sizeof(struct note));

   if (!newnote)
      error("notealloc; Can't allocate newnote",ERR_MALLOC);

   newnote->win = NULL;

   return (newnote);
   }

void andyssleeppointer(struct Window *win)
   {
   SetPointer(win, waitPointer, 16, 16, -6, 0);
   }

void andysstripintuimessages(struct MsgPort *msgport, struct Window *win)
   {
   Forbid();

   StripIntuiMessages(msgport,win);

   Permit();
   }
