/*********************************************/
/**************   commodore.c   **************/
/*********************************************/

#include <stdio.h>

#ifdef AMIGA
#include <clib/intuition_protos.h>
#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include <clib/graphics_protos.h>
#include <clib/layers_protos.h>

#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/ports.h>

#include <intuition/intuition.h>
#include <intuition/intuitionbase.h>
#include <graphics/displayinfo.h>
#include <graphics/gfxbase.h>

#endif

#include "consts.h"
#include "structs.h"
#include "prototype.h"

void CloseWindowSafely(struct Window *win)
   {
   Forbid();

   StripIntuiMessages(win->UserPort,win);

   win->UserPort = NULL;

   ModifyIDCMP(win,0L);

   Permit();

   CloseWindow(win);
   }

void StripIntuiMessages(struct MsgPort *mp, struct Window *win)
   {
   struct IntuiMessage *msg;
   struct Node *succ;

   msg = (struct IntuiMessage *)mp->mp_MsgList.lh_Head;

   while (succ = msg->ExecMessage.mn_Node.ln_Succ)
      {
      if (msg->IDCMPWindow == win)
         {
         Remove((struct Node *)msg);
         ReplyMsg((struct Message *)msg);
         }
      msg = (struct IntuiMessage *)succ;
      }
   }

