/****************************************
 *************   about.c   **************
 ****************************************/

#include <dos/dos.h>
#include <exec/types.h>
#include <intuition/intuition.h>
#include <intuition/classes.h>
#include <intuition/classusr.h>
#include <intuition/imageclass.h>
#include <intuition/gadgetclass.h>
#include <libraries/gadtools.h>
#include <graphics/displayinfo.h>
#include <graphics/gfxbase.h>
#include <graphics/text.h>
#include <workbench/workbench.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>
#include <clib/graphics_protos.h>
#include <clib/utility_protos.h>
#include <clib/diskfont_protos.h>
#include <clib/dos_protos.h>
#include <clib/wb_protos.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "stickit.h"

#include "consts.h"
#include "structs.h"
#include "prototype.h"

/***   Image   ****************************************************************/

USHORT chip ImageDataAbout[] =
{
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x01E5,0x0422,
	0x0000,0x0000,0x0000,0x0000,0x0408,0x0844,0x0000,0x0000,
	0x0000,0x0000,0x039E,0x6A4E,0x0000,0x0000,0x0000,0x0000,
	0x0095,0x1888,0x0000,0x0000,0x0000,0x0000,0x0895,0x1488,
	0x0000,0x0000,0x0000,0x0000,0x0E29,0xA510,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4040,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x4C40,0x8000,0x0008,
	0x0000,0x0000,0x0000,0x4C80,0x1040,0x0008,0x0000,0x0000,
	0x0000,0x4C96,0x9C71,0xAB0B,0xA100,0x0000,0x0000,0x2A98,
	0x9041,0x2D0C,0x9200,0x0000,0x0000,0x3290,0x9043,0x0908,
	0x9200,0x0000,0x0000,0x3310,0x9042,0x0909,0x8A00,0x0000,
	0x0000,0x3310,0x924A,0x290B,0x0C00,0x0000,0x0000,0x2110,
	0x9C72,0x490E,0x0400,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0800,0x0000,0x0000,0x0000,0x0000,0x0000,0x2800,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0001,0xD000,
	0x0000,0x0000,0x0000,0x0C00,0x1001,0x0800,0x0000,0x0000,
	0x0000,0x0C08,0x1001,0x0400,0x0000,0x0000,0x0000,0x1254,
	0x1421,0x04A3,0xAA00,0x0000,0x0000,0x1E64,0xD241,0x0534,
	0x7200,0x0000,0x0000,0x2245,0x1241,0x0F80,0x6200,0x0000,
	0x0000,0x2145,0x1141,0x1E03,0xE200,0x0000,0x0000,0x2146,
	0x3181,0x3214,0x6200,0x0000,0x0000,0x40C6,0x5081,0xC129,
	0xE200,0x0000,0x0000,0x0000,0x0100,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0500,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0003,0xFFE0,
	0x0000,0x0000,0x0000,0x0000,0x00FC,0x0070,0x00E3,0x0C67,
	0x0198,0x300C,0x3040,0x0000,0x0222,0x2521,0x0110,0x2024,
	0x9020,0x0000,0x05D2,0x2526,0x00A0,0x2024,0x1030,0x0050,
	0x0A24,0x39C2,0x0140,0x4048,0xC010,0x0000,0x0BA4,0x0842,
	0x0080,0x4048,0x2010,0x0550,0x089C,0xE738,0x8101,0xC462,
	0x4010,0x0000,0x0700,0x0000,0x8000,0x0001,0x8010,0x5540,
	0x0000,0x0002,0x0000,0x0000,0x0010,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x001D,0x5400,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
	0xFFFF,0xFFF0,0xFE1A,0xFBDD,0xFFFF,0xFFFF,0xFFFF,0xFFF0,
	0xFBF7,0xF7BB,0xFFFF,0xFFFF,0xFFFF,0xFFF0,0xFC61,0x95B1,
	0xFFFF,0xFFFF,0xFFFF,0xFFF0,0xFF6A,0xE777,0xFFFF,0xFFFF,
	0xFFFF,0xFFF0,0xF76A,0xEB77,0xFFFF,0xFFFF,0xFFFF,0xFFF0,
	0xF1D6,0x5AEF,0xFFFF,0xFFFF,0xFFFF,0xFFF0,0x00E3,0x8138,
	0x5C8B,0x9C2B,0x8DC0,0x3F40,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
	0xFFFF,0xFFF0,0xFFFF,0xBFBF,0xFFFF,0xFFFF,0xFFFF,0xFFF0,
	0xFFFF,0xB3BF,0x7FFF,0xFFF7,0xFFFF,0xFFF0,0xFFFF,0xB37F,
	0xEFBF,0xFFF7,0xFFFF,0xFFF0,0xFFFF,0xB369,0x638E,0x54F4,
	0x5EFF,0xFFF0,0xFFFF,0xD567,0x6FBE,0xD2F3,0x6DFF,0xFFF0,
	0xFFFF,0xCD6F,0x6FBC,0xF6F7,0x6DFF,0xFFF0,0xFFFF,0xCCEF,
	0x6FBD,0xF6F6,0x75FF,0xFFF0,0xFFFF,0xCCEF,0x6DB5,0xD6F4,
	0xF3FF,0xFFF0,0xFFFF,0xDEEF,0x638D,0xB6F1,0xFBFF,0xFFF0,
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xF7FF,0xFFF0,0xFFFF,0xFFFF,
	0xFFFF,0xFFFF,0xD7FF,0xFFF0,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
	0xFFFF,0xFFF0,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFF0,
	0xFFFF,0xFFFF,0xFFFE,0x2FFF,0xFFFF,0xFFF0,0xFFFF,0xF3FF,
	0xEFFE,0xF7FF,0xFFFF,0xFFF0,0xFFFF,0xF3F7,0xEFFE,0xFBFF,
	0xFFFF,0xFFF0,0xFFFF,0xEDAB,0xEBDE,0xFB5C,0x55FF,0xFFF0,
	0xFFFF,0xE19B,0x2DBE,0xFACB,0x8DFF,0xFFF0,0xFFFF,0xDDBA,
	0xEDBE,0xF07F,0x9DFF,0xFFF0,0xFFFF,0xDEBA,0xEEBE,0xE1FC,
	0x1DFF,0xFFF0,0xFFFF,0xDEB9,0xCE7E,0xCDEB,0x9DFF,0xFFF0,
	0xFFFF,0xBF39,0xAF7E,0x3ED6,0x1DFF,0xFFF0,0xFFFF,0xFFFF,
	0xFEFF,0xFFFF,0xFFFF,0xFFF0,0xFFFF,0xFFFF,0xFAFF,0xFFFF,
	0xFFFF,0xFFF0,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFF0,
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFF0,0xFFFF,0xFFFF,
	0xFFFF,0xFFFF,0xFFFC,0x0010,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
	0xFF03,0xFF80,0xFF1C,0xF398,0xFE67,0xCFF3,0xCFBF,0xFFF0,
	0xFDDD,0xDADE,0xFEEF,0xDFDB,0x6FDF,0xFFC0,0xFA2D,0xDAD9,
	0xFF5F,0xDFDB,0xEFCF,0xFF00,0xF5DB,0xC63D,0xFEBF,0xBFB7,
	0x3FEF,0xFC00,0xF45B,0xF7BD,0xFF7F,0xBFB7,0xDFEF,0xF000,
	0xF763,0x18C7,0x7EFE,0x3B9D,0xBFEF,0xC000,0xF8FF,0xFFFF,
	0x7FFF,0xFFFE,0x7FEF,0x0000,0xFFFF,0xFFFD,0xFFFF,0xFFFF,
	0xFFEC,0x0000,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFE0,0x0000
};

struct Image ImageAbout =
{
	0,	/* X Offset from LeftEdge */
	0,	/* Y Offset from TopEdge */
	92,	/* Image Width */
	46,	/* Image Height */
	2,	/* Image Depth */
	ImageDataAbout,	/* pointer to Image BitPlanes */
	0x03,	/* PlanePick */
	0x00,	/* PlaneOnOff */
	NULL	/* next Image structure */
};

/******************************************************************************/

USHORT chip ImageDataIcon[] =
{
	0x0000,0x0000,0x0000,0x1000,0x0000,0x0000,0x0000,0x1000,
	0x0000,0x0000,0x0000,0x1000,0x0000,0x0000,0x0000,0x1000,
	0x0000,0x0000,0x0000,0x1000,0x0007,0x2202,0x1C80,0x1000,
	0x0010,0x4004,0x1100,0x1000,0x0010,0xEC74,0x9380,0x1000,
	0x0018,0x890A,0x2200,0x1000,0x0004,0x890C,0x2200,0x1000,
	0x0009,0x1214,0x4400,0x1000,0x0070,0xB9D2,0xE200,0x1000,
	0x0000,0x0000,0x0000,0x1000,0x0000,0x0000,0x0000,0x1000,
	0x0000,0x0000,0x0000,0x1000,0x0000,0x0000,0x0020,0x1000,
	0x0000,0x0000,0x00A0,0x1000,0x0000,0x0000,0x02A0,0x1000,
	0x0000,0x0000,0x0AA0,0x1000,0x0000,0x0000,0x0000,0x1000,
	0x0000,0x0000,0x0000,0x1000,0x7FFF,0xFFFF,0xFFFF,0xF000,
	0xFFFF,0xFFFF,0xFFFF,0xE000,0x9249,0x2492,0x4924,0x8000,
	0xA5FF,0xFFFF,0xFFF9,0x2000,0xC9FF,0xFFFF,0xFFF2,0x4000,
	0x93FF,0xFFFF,0xFFF4,0x8000,0xA5F8,0xDDFD,0xE379,0x2000,
	0xC9EF,0xBFFB,0xEEF2,0x4000,0x93EF,0x138B,0x6C74,0x8000,
	0xA5E7,0x76F5,0xDDF9,0x2000,0xC9FB,0x76F3,0xDDF2,0x4000,
	0x93F6,0xEDEB,0xBBF4,0x8000,0xA58F,0x462D,0x1DF9,0x2000,
	0xC9FF,0xFFFF,0xFFF2,0x4000,0x93FF,0xFFFF,0x8004,0x8000,
	0xA5FF,0xFFFF,0xBF99,0x2000,0xC9FF,0xFFFF,0xBE52,0x4000,
	0x93FF,0xFFFF,0xB954,0x8000,0xA5FF,0xFFFF,0xB159,0x2000,
	0xC9FF,0xFFFF,0xA552,0x4000,0x9249,0x2492,0x4924,0x8000,
	0xA492,0x4924,0x9249,0x2000,0x8000,0x0000,0x0000,0x0000
};

struct Image ImageIcon =
{
	0,	/* X Offset from LeftEdge */
	0,	/* Y Offset from TopEdge */
	52,	/* Image Width */
	22,	/* Image Height */
	2,	/* Image Depth */
	ImageDataIcon,	/* pointer to Image BitPlanes */
	0x03,	/* PlanePick */
	0x00,	/* PlaneOnOff */
	NULL	/* next Image structure */
};


struct DiskObject appicon =
	{
	WB_DISKMAGIC,
	WB_DISKVERSION,
		{
		NULL,
		87,30,
		52,22,			/* Width, height */
		GADGHCOMP,
		RELVERIFY,
		BOOLGADGET,
		(APTR)&ImageIcon,	/* Image 1 */
		NULL,			/* Image 2 */
		NULL,
		NULL,
		NULL,
		NULL,
		NULL
		},
	WBAPPICON,
	NULL,
	NULL,
	NO_ICON_POSITION,
	NO_ICON_POSITION,
	NULL,
	NULL,
	NULL
	};

extern prjptr prj;
extern struct Window *aboutWnd;

void openabout()
   {
   if (!aboutWnd)
      if (OpenaboutWindow())     /* If can't open it, don't bother */
         {
         CloseaboutWindow();
         return;
         }

   /***   Draw nice logo...   ***/

   DrawImage(aboutWnd->RPort,&ImageAbout,aboutWnd->BorderLeft,
                                                      aboutWnd->BorderTop);
   }

