/* EDITOR.C */
/* Copyright (c) S. Morphet, 1993,1994 */
/* Editor functions for attachment to a Steph window. */

/*
	This example program is designed to show how a simple text
	editor can be written to use the Steph system.

	The code can be found in the files EDITFN.C and EDITFN.H.

	Note: This editor is demonstration code only.  It lacks many
	features that might be expected of a text editor.

	Please feel free to use this code as the basis for your own
	editors for Steph.

	To compile: Your project should include EDITOR.C EDITFN.C and
	a Steph library such as STEPH_L.LIB

	The file DEMO.C includes examples of dialogue boxes etc.
*/

#include <steph.h>
#include <editfn.h>

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>

#define _ED_VER_ "v1.51"
#define _ED_DATE_ "December 1994"


void about( void );
void fnexit( void );

void mysysfilter( void );
void mysysaction( void );
void myinit( void );

void main( void )
{

	if( !_steph_initialise( M_TEXT ) )
	{
		printf( "Not enough video oomph!" );
		exit(0);
	}

	/* set up menus and functions */
	_menu_build( 0, "&File",
			"&About",
			"=",
			"E&xit.",
			NULL );

	_menu_functions( 0,
			about,
			NOFN,
			fnexit );

	_menu_helptext( 0, "Default menu.",
			"Information about editor.",
			NOTEXT,
			"Exit the program" );

	/* Set up pointer to application initialisation function */
	_steph_initialfunction( myinit );

	/* Set up the screen windows */

	/* Build the first editor window */

	_window_build( 0, WP_MAIN, 10, "Editor Window", editor_filter,
			editor_action, NOFN );

	/* Attach mouse functions to the editor window */

	_window_mouse_functions( 0, NOFN,
			editor_mouse_maximise,
			editor_mouse_minimise,
			editor_mouse_resize,
			ems_up, ems_down, ems_vdrag, ems_pup, ems_pdown,
			ems_left, ems_right, ems_hdrag, ems_pleft, ems_pright,
			editor_mouse_unselect, editor_mouse_select,
			editor_mouse_activate );

	_window_set_draw( 0, WD_COLOUR, NOFN );

	/* Another editor window can be created very easily. */

	_window_build( 1, WP_BOT, 2, "Editor 2", editor_filter,
			editor_action, NOFN );

	_window_set_draw( 1, WD_COLOUR, NOFN );

	/* Attach mouse functions to the editor window. */

	_window_mouse_functions( 1, NOFN,
			editor_mouse_maximise,
			editor_mouse_minimise,
			editor_mouse_resize,
         ems_up, ems_down, ems_vdrag, ems_pup, ems_pdown,
			ems_left, ems_right, ems_hdrag, ems_pleft, ems_pright,
			editor_mouse_unselect, editor_mouse_select,
			editor_mouse_activate );


	/* Set up a dialogue box for 'Help' information */

	_dbox_build( 0, DB_CENSCR, 48, 8, 3, "About EDITOR.", NOTEXT );
	_dbox_c_label( 0, 0, 2, 2, "EDITOR " _ED_VER_ ". Steph Demonstration Program." );
	_dbox_c_label( 0, 1, 2, 4, "Stephen Morphet.  " _ED_DATE_ "." );
	_dbox_c_button( 0, 2, 2, 6, 6, "&OK", EXIT, NOFN );

	/* Put text on the speed bar */

	_speed_setbar( _s_strdup("EDITOR " _ED_VER_ ". Press ALT for menu.") );

	/* Set up a system level key trap for F1. */

	_window_setsyskey( mysysfilter, mysysaction );

	/* Set up the editor, then start Steph. */

	editor_initialise();

	_steph_go();

}


/* An exit function, called when user chooses File-Exit. */

void fnexit( void )
{
	_steph_closedown();
	exit(0);
}


/* The initialise function opens the second window. */

void myinit( void )
{
	/* window 0 (main) is already open */

	/* make editor window active, and open the other one */
	_window_make_active( 0 );
	_window_open( 1, OPEN );

	/* refresh windows */
	_window_draw();
	_window_refresh_all();

	/* turn on the cursor in the editor window */
	ed_put_cursor( 0 );

}


/* The system key filter spots the F1 key */

void mysysfilter( void )
{
	if( _window_spec.key1 == 0 )
		if( _window_spec.key2 == 59 )
			_window_spec.syskeyflag = TRUE;
}

/* The action function uses dialogue box 0 to give info. */

void mysysaction( void )
{
	/* fill in the gaps to attach code to other keystrokes */
	switch( _window_spec.key1 )
	{
		/* nonzero value means it was an ascii key */
		case 0:
		{
			switch( _window_spec.key2 )
			{
				/* list of non ascii keys... */
				case 59:
				{
					_dbox_go(0);
					break;
				}

				default:
				{}
			}

         break;
      }

      default:
      {}
   }
}


void about( void )
{
	_dbox_go(0);
}
