Program TStatBox;

{==============================================================}
{Demos the usage of the Unit STATBOX.TPU, a dynamically sized, }
{status dialog.  See the notes within this code for usage of   }
{the 2 methods in the Unit.                                    }
{Special thanks again to Steve Schafer for the initial code    }
{and idea.                                                     }
{The following files were all originally distributed together: }
{STATBOX.PAS (*Unit Code*)                                     }
{STATBOX.TPU (*Compiled Unit, TP6.0*)                          }
{TSTATBOX.PAS (*This Demo Code*)                               }
{TSTATBOX.EXE (*Compiled Demo Code, TP6.0*)                    }
{                                                              }
{If you have any suggestions or improvements, please let me    }
{know, my Compuserve ID is 72400,2215.                         }
{This code has been very useful to me, and any improvements    }
{would only make my job easier!                                }
{==============================================================}

Uses
    Objects,Views,Crt,App,Drivers,Menus,Gadgets,STATBOX;

Type
    TStatTest = object(TApplication)
          Heap : PHeapView;
          Constructor Init;
          Procedure InitMenuBar; virtual;
          Procedure InitStatusLine; virtual;
          Procedure Idle; virtual;
          Procedure HandleEvent(var Event:TEvent); virtual;
          Procedure ShowDialog1;
          Procedure ShowDialog2;
          Procedure ShowDialog3;
    End;  {Object Declaration}


Const
     cmDialog1 = 100;
     cmDialog2 = 101;
     cmDialog3 = 102;

{*************************************************************************}

Constructor TStatTest.Init;
Var
   R : TRect;
Begin
     TApplication.Init;

     {Put heap memory report in our status line}
     {To verify disposal of all heap allocation}
     {upon closure of the TStatusDialog.       }
     {A nice on-the-fly debugging tool!        }
     GetExtent(R);
     R.A.X := R.B.X - 9;
     R.A.Y := R.B.Y - 1;
     Heap  := New(PHeapView, Init(R));
     Insert(Heap);
End;

{*************************************************************************}

Procedure TStatTest.InitMenuBar;
Var
   R : TRect;
Begin
     GetExtent(R);
     R.B.Y := R.A.Y +1;
     MenuBar:= New(PMenuBar, Init(R, NewMenu(
               NewSubMenu('~R~un Demos',hcNoContext, NewMenu(
               NewItem('Run Demo1', 'F1', kbF1, cmDialog1, hcNoContext,
               NewItem('Run Demo2', 'F2', kbF2, cmDialog2, hcNoContext,
               NewItem('Run Demo3', 'F3', kbF3, cmDialog3, hcNocontext,
               NIL)))),
               NIL))));
End;

{*************************************************************************}

Procedure TStatTest.InitStatusLine;
Var
   R : TRect;
Begin
     GetExtent(R);
     R.A.Y := R.B.Y-1;
     StatusLine := New(PStatusLine, Init(R,
                   NewStatusDef(0, $FFFF,
                   NewStatusKey('~F10~ Menu', kbF10, cmMenu,
                   NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
                   NIL)),
                   NIL)));
End;

{*************************************************************************}

Procedure TStatTest.Idle;
Begin
     TApplication.Idle;
     Heap^.Update;
End;

{*************************************************************************}

Procedure TStatTest.HandleEvent(var Event: TEvent);
Begin {HandleEvent}
      TApplication.HandleEvent(Event);

      Case Event.What of
           evCommand : Begin
                            Case Event.Command of
                                 cmDialog1 : ShowDialog1;
                                 cmDialog2 : ShowDialog2;
                                 cmDialog3 : ShowDialog3;
                            Else
                                Exit;
                            End;  {Case Event.Command of}
                            ClearEvent(Event);
                       End; {evCommand}
      End;
End; {HandleEvent}

{*************************************************************************}

Procedure TStatTest.ShowDialog1;

{Demonstrates one of the simplest types of TStatusDialog}
{Does not allow you to break into the processing,       }
{therefore, we don't need a Cancel Message. Note that   }
{the length of the Proc1 Message and the Done1 Message  }
{should be roughly the same, this assures them both     }
{being centered in the display when they are called     }
{upon.  If you don't do this, they they will end        }
{up being left justified within their bounds, not bad,  }
{but not the professional look we want in our app's.    }

Var
   D : PStatusDialog;
   C : Integer;
   E : TEvent;
Begin
     D := New(PStatusDialog, Init('[ STATUS BOX DEMO 1 ]',
                                  'Processing Record',
                                  'Cycle In Process...',
                                  '  Cycle Finished!  ',
                                  '',
                                  'Hit Any Key To Continue!'));
     DeskTop^.Insert(D);


     {Your Processing code would go here, in the For-Do loop or }
     {something similar.  For a repetitious task that you want  }
     {to be sure the user knows something is going on, do a     }
     {little, or one step, then report on the status.  A good   }
     {example is reading or writing records.  Keep the dialog   }
     {open until a key is pressed, or could be a mouse click,   }
     {so the user can get the Help message you wished to give   }
     {them upon the completion of the "processing"              }

     For C := 1 to 200 Do
     Begin
          D^.Update(cmValid, C);
          Delay(50);
          GetEvent(E);     {eat any misc key hits during processing}
     End;
     D^.Update(cmOk, C);
     Repeat
     Until KeyPressed;
     DeskTop^.Delete(D);
     Dispose(D, Done);
End;

{*************************************************************************}

Procedure TStatTest.ShowDialog2;

{Demonstrates a TStatusDialog which includes a cancel message}
{Note that you have to include code to cancel out, it won't  }
{just happen automatically!  Also note the GetEvent(E) lines,}
{this is to trap random key hits, which will trigger the     }
{close of the dialog if they aren't intercepted.             }
{Note if you have a Cancel message, it needs to be the same  }
{length as the Main1 and Proc1 messages to be properly       }
{centered in the dialog.                                     }

Var
   D : PStatusDialog;
   C : Integer;
   E : TEvent;
Begin
     D := New(PStatusDialog, Init('[ STATUS BOX DEMO 2 ]',
          {Main1 Message==>}     'Processing Record',
          {Proc1 Message==>}     'Hit CTRL-BREAK to Interrupt Processing',
          {Done1 Message==>}     '   You Didn''t Interrupt Processing   ',
          {Cancel Message==>}    '     You Interrupted Processing...    ',
          {Help  Message==>}     'Hit Any Key To Continue'));

     DeskTop^.Insert(D);
     For C := 1 to 200 Do
     Begin
          D^.Update(cmValid, C);
          If CtrlBreakHit Then
          Begin
               CtrlBreakHit := FALSE;
               GetEvent(E);             {eat the CTRL-BREAK}
               D^.Update(cmCancel, C);
               C := 200;
               Repeat
               Until KeyPressed;
               DeskTop^.Delete(D);
               Dispose(D, Done);
               Exit; {Leave this procedure}
          End;
          Delay(50);
          GetEvent(E);     {eat any misc. key hits during processing}
     End;
     D^.Update(cmOk, C);
     Repeat
     Until KeyPressed;
     DeskTop^.Delete(D);
     Dispose(D, Done);
End;

{*************************************************************************}

Procedure TStatTest.ShowDialog3;

{Demonstrates the dynamic sizing of the TStatusDialog, it is }
{sized to the length needed to accomodate our long Help      }
{message.                                                    }

Var
   D : PStatusDialog;
   C : Integer;
   E : TEvent;
Begin
     D := New(PStatusDialog, Init('[ STATUS BOX DEMO 3 ]',
                                 'Processing Record',
                                 'Hit CTRL-BREAK to Interrupt Processing',
                                 '   You Didn''t Interrupt Processing   ',
                                 '     You Interrupted Processing...    ',
     'Hit Any Key To Continue, Then You May Exit Or Run Demo Again!'));

     DeskTop^.Insert(D);
     For C := 1 to 200 Do
     Begin
          D^.Update(cmValid, C);
          If CtrlBreakHit Then
          Begin
               CtrlBreakHit := FALSE;
               GetEvent(E);             {eat the CTRL-BREAK}
               D^.Update(cmCancel, C);
               C := 200;
               Repeat
               Until KeyPressed;
               DeskTop^.Delete(D);
               Dispose(D, Done);
               Exit; {Leave this procedure}
          End;
          Delay(50);
          GetEvent(E);     {eat any misc. key hits during processing}
     End;
     D^.Update(cmOk, C);
     Repeat
     Until KeyPressed;
     DeskTop^.Delete(D);
     Dispose(D, Done);
End;

{*************************************************************************}

Var
   Test : TStatTest;

BEGIN {main app}
     Test.Init;
     Test.Run;
     Test.Done;
END.  {main app}
