Unit StatBox;

{=========================================================================}
{ This Unit was written by Patrick Mitchel, March 1993 and donated to the }
{ public domain.                                                          }
{ It provides the user with an updating dialog box which can be used      }
{ to give the user feedback on the progress of some procedure.  I use it  }
{ for reporting the record number being processed in a database           }
{ application I wrote for my work.  The users like the visual feedback it }
{ gives instead of the static "PROCESSING" message that I used to display.}
{                                                                         }
{ Many thanks to Steve Schafer for the initial code and idea for this     }
{ unit. I was looking for something exactly like this Steve!!  I just     }
{ took the code and put it into a Unit for reuse at any time.             }
{ Steve's original code can be found on compuserve as STATUS.PAS.         }
{                                                                         }
{ The TStatusDialog box is dynamically sized in the X direction based     }
{ upon the length of the largest message you wish to display.  It is      }
{ also automatically centered in the parent view, and has a built in      }
{ value of R.B.Y - R.A.Y of 6.  This can be changed in this Unit, but     }
{ check out the demo first, I think you will find it satisfactory.        }
{                                                                         }
{ If you find any bugs, or make some improvements, please let me know!    }
{ My Compuserve ID is 72400,2215.  This code has been very useful to me   }
{ and any improvements would only make my job easier!  Thanks!            }
{*************************************************************************}
{Using The Methods:                                                       }
{                                                                         }
{     Constructor Init (MyTitle : String;                                 }
{                       Main1,Proc1,Done1,Cancel,Help : String);          }
{     (********************************************************)          }
{     (*Initializes the TStatusDialog box with the strings to *)          }
{     (*display.  See the demo code to understand more fully  *)          }
{     (*where/when each string is displayed, but below is a   *)          }
{     (*brief explanation of where/when the strings are       *)          }
{     (*displayed.                                            *)          }
{     (*MyTitle : The title you wish displayed in the dialog  *)          }
{     (*Main1   : The text related to the actual processing   *)          }
{     (*          This text is always displayed during use    *)          }
{     (*Proc1   : The text displayed beneath Main1 during     *)          }
{     (*          processing                                  *)          }
{     (*Done1   : The text displayed when processing is done  *)          }
{     (*          Overwrites Proc1                            *)          }
{     (*Cancel  : The test displayed when you cancel out of   *)          }
{     (*          the process in the middle, like with ^C     *)          }
{     (*          You will need to program in the ability to  *)          }
{     (*          break into the process.  See the demo       *)          }
{     (*Help    : The text displayed at the very bottom of the*)          }
{     (*          dialog when processing is finished, can     *)          }
{     (*          be used to give the user a hint on what to  *)          }
{     (*          do next.                                    *)          }
{     (********************************************************)          }
{                                                                         }
{     Procedure Update(Status : Word; AValue : Word); virtual;            }
{     (********************************************************)          }
{     (*Pass it the status, either cmValid, cmOk or cmCancel  *)          }
{     (*depending on the status of your dialog box, along with*)          }
{     (*AValue: the value to update the dialog box with.      *)          }
{     (*Check out the sample program to really see how this   *)          }
{     (*method is utilized.                                   *)          }
{     (********************************************************)          }
{                                                                         }
{=========================================================================}

{$F+}          {Force Far Calls}
{$O+}          {Enable Overlay Code Generation}
{$S-}          {Disable Stack Overflow Checking Code}
{$D-}          {Disable Debug Information}

Interface

Uses
     Objects, Views, Dialogs;


Type
    {Updating Status Box Dialog}
    PStatusDialog = ^TStatusDialog;
    TStatusDialog = object(TDialog)
                  MainMessage : string;         {displayed all the time}
                  ProcMessage : string;         {in process message}
                  DoneMessage : string;         {done message}
                  CancelMessage : string;       {cancel message}
                  HelpMessage   : string;       {help message}
                  Message1    : PStaticText;    {holder for displaying msgs}
                  Message2    : PStaticText;    {holder for displaying msgs}
                  Message3    : PStaticText;    {holder for displaying msgs}
                  Value       : PStaticText;    {value we are updating}
                  Constructor Init(MyTitle : String;
                                   Main1,Proc1,Done1,Cancel,Help : String);
                  Procedure Update(Status : Word; AValue : Word); virtual;
    End; {Status Dialog Object}

{=========================================================================}
{=========================================================================}

Implementation


Constructor TStatusDialog.Init(MyTitle : String;
                               Main1,Proc1,Done1,Cancel,Help : String);
Var
   R      : TRect;   {bounds for string displays}
   MaxLen : Integer; {holds max length of string}
   Bounds : TRect;   {bounds for main dialog window}
Begin
     {calculate size of dialog based on largest message length}
     {set initial X size of dialog, based on the dialogs title}
     MaxLen := Length(MyTitle) + 6;
     If (Length(Main1) + 5) > MaxLen Then
        MaxLen := Length(Main1) + 5;    {to allow for 4 place value}
     If Length(Proc1) > MaxLen Then
        MaxLen := Length(Proc1);        {length of processing message}
     If Length(Done1) > MaxLen Then
        MaxLen := Length(Done1);        {length of finished message}
     If Length(Cancel) > MaxLen Then
        MaxLen := Length(Cancel);       {length of cancel message}
     If Length(Help) > MaxLen Then
        MaxLen := Length(Help);         {length of help message}
     Bounds.Assign(0,0,MaxLen + 4,7);

     {call ancestor .Init method}
     TDialog.Init(Bounds, MyTitle);
     MainMessage := Main1;         {assign messages to variables}
     ProcMessage := Proc1;
     DoneMessage := Done1;
     CancelMessage := Cancel;
     HelpMessage   := Help;
     Flags := Flags and not wfClose;   {no close icon on window}
     Options := Options or ofCentered; {center the dialog}

     {center main text}
     R := Bounds;               {assign extent of dialog to variable R}
     R.A.X := (R.B.X - Length(MainMessage) - 5) div 2;
     Dec(R.B.X);
     Inc(R.A.Y,2);              {set to second line in dialog}
     R.B.Y := R.A.Y + 1;        {set to one line below R.A.Y}
     Message1 := New(PStaticText, Init(R, MainMessage));
     Insert(Message1);

     {insert base value}
     R.A.X := R.A.X + Length(MainMessage) + 1;     {position for values}
     Value := New(PStaticText, Init(R, '   0'));   {start at record 0}
     Insert(Value);

     {center processing text and done text}
     R := Bounds;
     R.A.X := (R.B.X - Length(ProcMessage)) div 2;
     Dec(R.B.X);
     Dec(R.B.Y, 3);
     R.A.Y := R.B.Y - 1;
     Message2 := New(PStaticText, Init(R, ProcMessage));
     Insert(Message2);
     {message 2 starts out being the 'processing' message, but }
     {can be used for anything you wish.  Study the .Update    }
     {method to see where to put the DoneMessage, or of course }
     {how to modify this Unit to better serve your application }

     {center help text}
     R := Bounds;
     R.A.X := (R.B.X - Length(HelpMessage)) div 2;
     Dec(R.B.X);
     Dec(R.B.Y);
     R.A.Y := R.B.Y - 1;
     Message3 := New(PStaticText, Init(R, HelpMessage));
     {message 3 is a help message, you determine when to insert}
     {it based on when help is needed.  I use it for giving a  }
     {hint of what to do when processing is over, ie...        }
     {"Hit Any Key To Continue" type message.  you will display}
     {this message attached to the cmOK command which signifies}
     {whatever you wish, but most likely it represents the end }
     {of the 'processing' cycle.                               }
End;

{*************************************************************************}

Procedure TStatusDialog.Update(Status : Word; AValue : Word);
Var
   ValStr : String[4];
Begin
     Case Status of
          cmCancel : Begin
                          DisposeStr(Message2^.Text);
                          Message2^.Text := NewStr(CancelMessage);
                          Message2^.DrawView;
                          Insert(Message3);
                     End;
                     {cmCancel is designed to be used for a status box}
                     {which allows you to interrupt the 'processing'  }
                     {for some reason.  You will then issue some type }
                     {of message like "YOU CANCELLED PROCESSING" to   }
                     {the user so they can acknowledge what they did. }
                     {Could also be used to cancel processing based on}
                     {some other event in your program, and report a  }
                     {message to the user about why processing has    }
                     {halted.  See the demo for an example...         }
          cmOk : Begin
                      DisposeStr(Message2^.Text);
                      Message2^.Text := NewStr(DoneMessage);
                      Message2^.DrawView;
                      Insert(Message3);
                      {cmOk is designed to be used to display the     }
                      {message which denotes that the 'processing'    }
                      {that the box is reporting on has completed as  }
                      {planned.                                       }
                 End;
     End; {Case}

     {Updates the value displayed in the TStatusDialog}
     Str(AValue:4, ValStr);
     DisposeStr(Value^.Text);
     Value^.Text := NewStr(ValStr);
     Value^.DrawView;
End;

{*************************************************************************}

End.    