//--------------------------------------------------------------------------
// SR_FILE.H
//
// Contains function prototypes to be used with FILEIO.C.
// Brad Rembielak 11/93
// Carlton Guc 12/93

#ifndef FILEIO_H
#define FILEIO_H

#include <windows.h>
#include <commdlg.h>
#include <stdlib.h>

#define UNTITLED "(untitled)"

#define SHOW_PLAY   2000
#define SHOW_HELP   2001

int WINAPI _loadds StageAskAboutSave (HWND hwnd, LPSTR lpFilename);
void WINAPI _loadds StageFileInitialize (HWND hwnd, LPSTR lpFilename, LPSTR lpFilter, LPSTR lpDefault);
BOOL WINAPI _loadds StageFileOpenDlg (HWND hwnd, LPSTR lpstrFileName);
BOOL WINAPI _loadds StageFileSaveDlg (HWND hwnd, LPSTR lpstrFileName);
long WINAPI _loadds StageFileLength (int hFile);
BOOL WINAPI _loadds StageFileReadEdit (HWND hwndEdit, HWND hDisplay, LPSTR lpstrFileName);
BOOL WINAPI _loadds StageFileWriteEdit (HWND hwndEdit, LPSTR lpstrFileName);
BOOL WINAPI _loadds StageFileSetAlteredState (HWND hWnd);
BOOL WINAPI _loadds StageFileCommandLine(LPSTR, LPSTR);
BOOL WINAPI _loadds StageFileWriteRecord (int hFile, WORD wRecord, WORD wSize, LPSTR lpStore);
BOOL WINAPI _loadds StageFileReadRecord (int hFile, WORD wRecord, WORD wSize, LPSTR lpStore);
void WINAPI _loadds StageFileClose (int hFile);
int WINAPI _loadds StageFileOpenWrite (LPSTR lpFilename);
int WINAPI _loadds StageFileOpenRead (LPSTR lpFilename);
BOOL WINAPI _loadds StageMakeTitleAltered (HWND hWnd);
BOOL WINAPI _loadds StageMakeTitleNotAltered (HWND hWnd);
BOOL WINAPI _loadds StageFileSetDateTime (LPSTR lpFilename, LPSTR lpDate, LPSTR lpTime);
BOOL WINAPI _loadds StageFileGetDateTime (LPSTR lpFilename, LPSTR lpDate, LPSTR lpTime);
BOOL WINAPI _loadds StageSetDiskLabel (LPSTR lpDrive, LPSTR lpLabel);
BOOL WINAPI _loadds StageGetDiskLabel (LPSTR lpDrive, LPSTR lpStorage);
BOOL WINAPI _loadds StageCopyFile (LPSTR lpFrom, LPSTR lpTo);
DWORD WINAPI _loadds StageCalculateDirectorySize (LPSTR lpszDirectory);
HANDLE WINAPI _loadds StageStartFileOpen (HWND hwnd, LPSTR lpFilename, LPSTR lpFilter, LPSTR lpDefault);
BOOL WINAPI _loadds StageEndFileOpen (HANDLE hOpenFileName);
BOOL WINAPI _loadds StageGetOpenFileName (HANDLE hOpenFileName, HWND hWnd, LPSTR lpstrFileName, WORD wType);
BOOL WINAPI _loadds StageGetSaveFileName (HANDLE hOpenFileName, HWND hWnd, LPSTR lpstrFileName);
BOOL WINAPI _loadds WavTestProc (HWND hDlg, UINT message, UINT wParam, LONG lParam);
#endif
