/*   */
testurl:


parse arg ddir0,tempfile,sel,list,verb,uri,user,basedir,workdir,privset,enmadd,transaction,verbose ,servername,host_nickname,homedir

list=translate(list, ' ', '+'||'090a0d'x)  /* Whitespace, etc. */


   call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
        call lineout tempfile, "<html><head><title>SRE-Filter: Test a URL </title>"
        call lineout tempfile, "</head><body>"

aclient=user
auser=' '
do until list=""
  parse var list food '&' list
  say " food " food
  if abbrev(upper(food),'TESTURL=')=1 then do
     parse  var food foo '=' aurl
     aurl=packur(aurl)
     parse var aurl  aurl2 '?' alist
     aurl2=strip(upper(aurl2),'l','/')
     aurl=strip(aurl2,'l','\')
  end
  if abbrev(upper(food),"TESTCLIENT=")=1 then do
        parse var food '=' aclient
  end
  if abbrev(upper(food),"USERNAME=")=1 then do
        parse var food '=' auser
  end
end

if aclient=' ' then aclient=user

ahost=reqfield('HOST:')
call lineout tempfile,' <h1> Resolving a Request: Displaying the steps in the process </h1>'
call lineout tempfile,' <em> under construction .... </em> <p>'
call lineout tempfile,' <p> <h3> Basic request data </h3> <ul> <li> The <strong>Host name</strong> specified by your browser is: 'ahost
aservername=servername() ; aserveraddr=extract('serveraddr') ;
aport=extract('serverport')
call lineout tempfile,' <li> The server port is: <b> ' aport '</b> '
call lineout tempfile,'<li> The servername/address assumed by GoServe<b>: ' aservername ',' aserveraddr '</b> '
call lineout tempfile,'<li> The servername nickname assumed by SRE-Filter<b>: ' servername  '</b> '
call lineout tempfile,'<br> ... with a Host_nickname<b>: '  host_nickname '</b> '
call lineout tempfile,'<li> The client IP address assumed by GoServe <b>: ' user '</b> '


t1=value(enmadd||'PRE_FILTER',,'os2environment')
t2=value(enmadd||'PREFILTER_NAME',,'os2environment')
if t1='YES'  then                
 call lineout tempfile,'<li><strong> Note:</strong> The <code>' t2 ' </code> pre-filter would have been called '

call lineout tempfile,'</ul>'

aserver=aservername
aurl=aurl2

if pos('HTTP://',aurl)>0  then do
   parse var aurl  'HTTP://' aserver '/' aurl
end
call lineout tempfile,' <H3>The URL to be Tested </h3>'
call lineout tempfile,' <ul> <li> The Servername for this test<b>: ' aserver '</b> '  
call lineout tempfile,' <li> The client IP address for this test<b>: ' aclient '</b> '  
call lineout tempfile,'<li> The URL for this test<b>: ' aurl '</b> '  
call lineout tempfile,' <li> The username: <b> ' auser '</b>'
call lineout tempfile,'<li> The argument list<b>: ' alist '</b> '
call lineout tempfile,' </ul> '

call lineout tempfile,' The host:  <ul> <li>'
foo=get_Host(aserver)
parse var foo ddir host_nickname
home_dir=get_value('HOME_DIR',host_nickname)      
call lineout tempfile,' </ul>  '

call lineout tempfile,' <h3> Client access-rights info </h3> <ul>'
owners=get_value('Owners',host_nickname)
if wordpos(aclient,owners)>0 then
   call lineout tempfile, '<li> Client is an OWNER '
else 
   call lineout tempfile, '<li> Client is NOT an owner '
mdo=sref_badips(aclient,enmadd,host_nickname)
if mdo=1 then
    call lineout tempfile,' <li> Client has an UNALLOWED IP '
else
    call lineout tempfile,' <li> Client does NOT have  an UNALLOWED IP '

a1=goodips(aclient)
if a1=0 then
  call lineout tempfile,' <li> Client does not have an inhouse IP '
else 
  call lineout tempfile,' <li> Client has an INHOUSE IP: <b> ' a1 '</b>'
call lineout tempfile,'</ul>'


call lineout tempfile,' <hr> <H3> Resolving the URL </H3> '
call lineout tempfile,' <ol> '



call lineout tempfile,' <li> The PUBLIC Urls: <menu> <li>'
foo=get_puburl(aurl,host_nickname,ddir)
if foo>0 then signal all_done
call lineout tempfile,'</menu> '

all_done:
call lineout tempfile,'</ol>'
call lineout tempfile,' </body> </html> '
call lineout tempfile
'file erase type text/html name ' tempfile


return 'done'
exit

/***************************/
get_host:procedure expose enmadd  tempfile ddir0
parse arg myaddr,

servername=' '
ddir=ddir0
nhosts=value(enmadd||'HOSTS.0',,'os2environment')
host_nickname=' '
/* check on multiple hosts */                                                
if nhosts>0 then do                                                          
   stuff=sref_host_info(myaddr,nhosts,enmadd)                                
   if stuff<>0 then do                                                       
      parse var stuff  servername ',' host_nickname  ',' ddir                
      host_nickname=strip(host_nickname); ddir=strip(ddir)                   
      default=strip(default) ; servername=strip(servername)                  
   end                                                                       
end                                                                          
if servername=0 then do  /* nhosts=0, or no match in get_host_info */        
    ddir=datadir()                                                           
    servername=servername()                                                  
    host_nickname=' '                                                        
end                                                                          

call lineout tempfile,' The Host Nickname used for this request: <b> ' host_nickname '</b> '
call lineout tempfile,' <br> ... with data directory <b> : ' ddir '</b> '
call lineout tempfile,' <br> ... and servername <b>: ' servername '</b> '

return ddir ' 'host_nickname


/**************************/
get_puburl:procedure expose tempfile  os2e enmadd
parse arg sel,host_Nickname,ddir

  tsel=translate(sel)
  gotit=0 ; doexact=0 
  call get_public_urls(host_nickname)
  do m=1 to public_urls.0
    if public_urls.m=' ' then iterate  
    parse var public_urls.m  purl  isliteral  aname0
    purl=strip(purl) ;
    ares=sref_wildcard(tsel,purl,doexact)
    parse var ares astat "," aurl ;  astat=strip(astat)
    if astat=0 then iterate   /* no match */
    usesel=sel ;
    useliteral=strip(upper(isliteral)) ;  exact_name=strip(aname0)
    gotit=m
    if ares=1 then
       leave           /*first exact match rules */
     else
      doexact=1
  end

  if gotit>0 then do        /* if gotit, then reset the sel */

    call lineout tempfile,' Matching public_URL is <b> ' public_urls.gotit '</b>'

/* if it's a literal public file, minimal processing is required */
     if abbrev(useliteral,"LITERAL")=1 then do
       if exact_name<>"" then do
           call lineout tempfile,' <br> -- With exactname of: <b> ' exact_name '</b>'
           return 2
       end
       else do
           parse var usesel asel '?' .
say " ddir " ddir
           afile=translate(ddir||asel,'\','/')
           if pos('~',afile)>0 then do
              afile=sref_replacestrg(afile,'~',home_dir) ;
           end
           call lineout tempfile,' <br> With literal file name of: <b> ' afile '</b>'
           return 1
       end
     end  /* listeral */ 
     return 0
  end           /* gotit */
  else do
        call lineout tempfile,' No matching public_URLs. '
        return 0
  end


/* ------------ */
/*  get public urls for this host */
/*----------------*/
get_public_urls:procedure expose public_urls. enmadd os2e 
parse arg hname
os2e='os2environment'


nin=0 ;n2=0
if hname<>"" then do 
    aa='public_urls.'||hname
    n2=10000
end
do mm=1 to n2
      moe=enmadd||aa||'.'||mm

      tt=strip(value(moe,,os2e))
      if tt="" | tt=0 then      leave
      nin=nin+1 ; public_urls.nin=tt
end

aa='public_urls'
do mm=1 to 10000
      moe=enmadd||aa||'.'||mm
      tt=strip(value(moe,,os2e))
      if tt="" | tt=0 then leave
      nin=nin+1 ; public_urls.nin=tt
end

public_urls.0=nin
return nin

/* ----------- */                                                        
/* get environment value, possibly host specific */                      
/* ------------ */                                                       
get_value: procedure expose enmadd host_nickname                          
parse arg vname,hname0
if hname0=0 then 
        hname=' '
else                                                    
    hname=strip(host_nickname)                          

vname=strip(vname) ;
if hname<>' ' then do
   booger=strip(enmadd||vname||'.'||hname)
   aval=value(booger,,'os2environment')
   if aval<>' ' Then                                                     
        return aval                                                      
end                                                                      
aval=value(enmadd||vname,,'os2environment')                              
return aval                                                              


/* -----------------------------------------------------------------------*/
/* see if ip address matches one of a set of good ips (1 if yes)*/
/* -----------------------------------------------------------------------*/
goodips: procedure expose  enmadd  host_nickname

parse arg anips

os2e='os2environment'

anips=strip(anips) ;hostn=strip(host_nickname)
parse var anips ip.1 '.' ip.2 '.' ip.3 '.' ip.4
mm=0 ; ndo=0

goodips2:               /* jump here to check default ones */
/* first, get "Host specific" inhouseips */
 aa='inhouseips.' 
 if hostN<>"" then aa='inhouseips.'||hostn||'.'
 nin=0
 do mm=1 to 10000
      useme=enmadd||aa||mm
      tt=strip(value(useme,,os2e))
      if tt="" | tt=0 then leave
      nin=nin+1 ; inhouseips.nin=tt
 end
 inhouseips.0=nin

mdo=inhouseips.0
do mm=1 to mdo
  if inhouseips.mm=' '  then iterate
  if inhouseips.mm=anips then do        /*it's an exact match -- extract privset */
      parse var inhouseips.mm uip.1 '.' uip.2 '.' uip.3 '.' uip.4 privset1
      return inhouseips.mm 
  end
end

/* if here, try wild card matches */
do m2=1 to mdo           /* wild card matches */

     if inhouseips.m2=' ' then iterate
     match=1
     parse var inhouseips.m2 uip.1 '.' uip.2 '.' uip.3 '.' uip.4 privset1
     do mm2 =1 to 4
       if uip.mm2="*" then iterate
       if uip.mm2=ip.mm2 then iterate
       match=0       /*if here, not a match */
       leave
     end
     if match=1 then return inhouseips.m2
end

if hostn<>"" then do
   hostn=" "
  signal goodips2
end
return 0                /* no match */



