typedef int sig_atomic_t;

int pause (void);
void (*signal (int sig, void (*handler)()))(int sig);
int raise (int sig);
int kill (int pid, int sig);

typedef unsigned long size_t;

struct _FILE
{
  char * ptr;
  char * buffer;
  int    rcount;
  int    wcount;
  int    handle;
  int    flags;
  int    buf_size;
  int    tmpidx;
  int    pid;
  char   char_buf;
  char   reserved1[3];
  int    (*flush)(struct _FILE *f, int c);
  unsigned long sem;
};

typedef struct _FILE FILE;

extern FILE _streamv[];

typedef long fpos_t;

typedef char *va_list;

void clearerr (FILE *stream);
char *cuserid (char *buffer);
int fclose (FILE *stream);
int fcloseall (void);
FILE *fdopen (int handle, __const__ char *mode);
int fflush (FILE *stream);
int fgetc (FILE *stream);
int fgetchar (void);
int fgetpos (FILE *stream, fpos_t *pos);
char *fgets (char *buffer, int n, FILE *stream);
int flushall (void);
FILE *fopen (__const__ char *fname, __const__ char *mode);
int fprintf (FILE *stream, __const__ char *format, ...);
int fputc (int c, FILE *stream);
int fputchar (int c);
int fputs (__const__ char *string, FILE *stream);
size_t fread (void *buffer, size_t size, size_t count, FILE *stream);
FILE *freopen (__const__ char *fname, __const__ char *mode, FILE *stream);
int fscanf (FILE *stream, __const__ char *format, ...);
int fseek (FILE *stream, long offset, int origin);
int fsetpos (FILE *stream, __const__ fpos_t *pos);
long ftell (FILE *stream);
size_t fwrite (__const__ void *buffer, size_t size, size_t count,
    FILE *stream);
char *gets (char *buffer);
int getw (FILE *stream);
int pclose (FILE *stream);
void perror (__const__ char *string);
FILE *popen (__const__ char *command, __const__ char *mode);
int printf (__const__ char *format, ...);
int puts (__const__ char *string);
int putw (int x, FILE *stream);
int remove (__const__ char *name);
int rename (__const__ char *old_name, __const__ char *new_name);
void rewind (FILE *stream);
int _rmtmp (void);
int scanf (__const__ char *format, ...);
int setbuf (FILE *stream, char *buffer);
int setbuffer (FILE *stream, char *buffer, size_t size);
int setvbuf (FILE *stream, char *buffer, int mode, size_t size);
int sprintf (char *buffer, __const__ char *format, ...);
int sscanf (__const__ char *buffer, __const__ char *format, ...);
char *tempnam (__const__ char *dir, __const__ char *prefix);
FILE *tmpfile (void);
char *tmpnam (char *string);
int ungetc (int c, FILE *stream);
int unlink (__const__ char *name);
int vfprintf (FILE *stream, __const__ char *format, va_list arg_ptr);
int vfscanf (FILE *stream, __const__ char *format, va_list arg_ptr);
int vprintf (__const__ char *format, va_list arg_ptr);
int vscanf (__const__ char *format, va_list arg_ptr);
int vsprintf (char *buffer, __const__ char *format, va_list arg_ptr);
int vsscanf (__const__ char *buffer, __const__ char *format, va_list arg_ptr);

char *_mfclose (FILE *stream);
FILE *_mfopen (char *buf, __const__ char *mode, size_t size, int inc);
int _fseek_hdr (FILE *stream);
FILE *_fsopen (__const__ char *fname, __const__ char *mode, int shflag);

int _fill (FILE *stream);
int _flush (int c, FILE *stream);

static __inline__ int fileno (FILE *s) { return (s->handle); }
static __inline__ int feof (FILE *s) { return (s->flags &  0x08  ? 1 : 0); }
static __inline__ int ferror (FILE *s) { return (s->flags &  0x10  ? 1 : 0); }

static __inline__ int getc (FILE *s)
{
  return (--s->rcount >= 0
          ? (unsigned char)*s->ptr++
          : _fill (s));
}

static __inline__ int putc (int c, FILE *s)
{
  return (--s->wcount >= 0 && (c != '\n' || !(s->flags &  0x20 ))
          ? (unsigned char)(*s->ptr++ = (char)c)
          : _flush (c, s));
}

static __inline__ int getchar (void) { return (getc ( (&_streamv[0]) )); }
static __inline__ int putchar (int c) { return (putc (c, (&_streamv[1]) )); }

typedef struct _div_t
{
  int quot;
  int rem;
} div_t;
typedef struct _ldiv_t
{
  long quot;
  long rem;
} ldiv_t;
typedef struct
{
  unsigned long quot;
  unsigned long rem;
} _uldiv_t;
typedef struct
{
  long long quot;
  long long rem;
} _lldiv_t;
typedef struct
{
  unsigned long long quot;
  unsigned long long rem;
} _ulldiv_t;

extern int errno;

extern char **environ;

extern __const__ char * __const__ sys_errlist[];
extern __const__ int sys_nerr;

extern __const__ unsigned int _emx_vcmp;
extern __const__ unsigned int _emx_env;
extern __const__ unsigned int _emx_rev;
extern __const__ unsigned char _osminor;
extern __const__ unsigned char _osmajor;
extern __const__ unsigned char _osmode;
extern __const__ char _emx_vprt[5];

void abort (void) __attribute__ ((noreturn));
unsigned alarm (unsigned sec);
int atexit (void (*func)(void));
int atoi (__const__ char *string);
long atol (__const__ char *string);
long long _atoll (__const__ char *string);
double atof (__const__ char *string);
long double _atofl (__const__ char *string);
void *brk (void *addr);
void *bsearch (__const__ void *key, __const__ void *base,
    size_t num, size_t width,
    int (*compare)(__const__ void *key, __const__ void *element));
int chdir (__const__ char *name);
div_t div (int num, int den);
void exit (int ret) __attribute__ ((noreturn));
char *gcvt (double value, int digits, char *buffer);
char *getcwd (char *buffer, size_t size);
char *getenv (__const__ char *name);
int getpagesize (void);
char *getwd (char *buffer);
char *initstate (unsigned seed, char *state, int n);     
char *_itoa (int value, char *string, int radix);
ldiv_t ldiv (long num, long den);
char *_ltoa (long value, char *string, int radix);
int mkdir (__const__ char *name, long mode);
void perror (__const__ char *string);
int putenv (__const__ char *string);
void qsort (void *base, size_t num, size_t width,
    int (*compare)(__const__ void *x1, __const__ void *x2));
int rand (void);
long random (void);                                      
int rmdir (__const__ char *name);
void *sbrk (int incr);
char *setstate (char *state);                            
unsigned sleep (unsigned sec);
void srand (unsigned int seed);
void srandom (unsigned seed);                            
long strtol (__const__ char *string, char **end_ptr, int radix);
unsigned long strtoul (__const__ char *string, char **end_ptr, int radix);
double strtod (__const__ char *string, char **end_ptr);
long double _strtold (__const__ char *string, char **end_ptr);
void swab (__const__ void *src, void *dst, size_t n);
int system (__const__ char *command);
long ulimit (int cmd, long newlimit);
char *_ultoa (unsigned long value, char *string, int radix);

int _abspath (char *dst, __const__ char *src, int size);
int _chdir2 (__const__ char *name);
int _chdrive (char drive);
int _core (int handle);
void _defext (char *dst, __const__ char *ext);
void _envargs (int *argcp, char ***argvp, const char *name);
int _execname (char *buf, size_t bufsize);
void _exit (int ret) __attribute__ ((noreturn));
int _filesys (__const__ char *drive, char *name, size_t size);
int _fncmp (__const__ unsigned char *string1,
    __const__ unsigned char *string2);
char **_fnexplode (__const__ char *mask);
void _fnexplodefree (char **list);
char _fngetdrive (__const__ char *src);
int _fnisabs (__const__ char *name);
int _fnisrel (__const__ char *name);
void _fnlwr (char *name);
void _fnlwr2 (char *name, const char *base);
int _fullpath (char *dst, __const__ char *src, int size);
int _getcwd1 (char *buffer, char drive);
char *_getcwd2 (char *buffer, int size);
char _getdrive (void);
char *_getext (__const__ char *path);
char *_getext2 (__const__ char *path);
char *_getname (__const__ char *path);
_lldiv_t _lldiv (long long num, long long den);
char *_lltoa (long long value, char *string, int radix);
void _makepath (char *dst, __const__ char *drive, __const__ char *dir,
    __const__ char *fname, __const__ char *ext);
int _path (char *dst, __const__ char *name);
int _read_kbd (int echo, int wait, int sig);
void _remext (char *path);
void _rfnlwr (void);
void _response (int *argcp, char ***argvp);
void _scrsize (int *dst);
void _searchenv (__const__ char *file, __const__ char *var, char *path);
void _sfnlwr (__const__ char *name);
unsigned _sleep2 (unsigned millisec);
char ** _splitargs (char *string, int *count);
void _splitpath (__const__ char *src, char *drive, char *dir, char *fname,
    char *ext);
char _swchar (void);
int _syserrno (void);
_uldiv_t _uldiv (unsigned long num, unsigned long den);
_ulldiv_t _ulldiv (unsigned long long num, unsigned long long den);
char *_ulltoa (unsigned long long value, char *string, int radix);
void _wildcard (int *argcp, char ***argvp);

extern int abs (int n);
extern long labs (long n);

void *calloc (size_t elements, size_t size);
void free (void *mem);
void *malloc (size_t size);
void *realloc (void *mem, size_t size);

void *_tcalloc (size_t elements, size_t size);
void _tfree (void *mem);
void *_tmalloc (size_t size);
void *_trealloc (void *mem, size_t size);

void *_expand (void *mem, size_t new_size);
int _heapchk (void);
int _heapset (unsigned fill);
size_t _msize (__const__ void *mem);

void *memccpy (void *s1, __const__ void *s2, int c, size_t n);
void *memchr (__const__ void *s, int c, size_t n);
int memcmp (__const__ void *s1, __const__ void *s2, size_t n);
void *memcpy (void *s1, __const__ void *s2, size_t n);
int memicmp (__const__ void *s1, __const__ void *s2, size_t n);
void *memmove (void *s1, __const__ void *s2, size_t n);
void *memset (void *s, int c, size_t n);

char *strcat (char *string1, __const__ char *string2);
char *strchr (__const__ char *string, int c);
int strcmp (__const__ char *string1, __const__ char *string2);
char *strcpy (char *string1, __const__ char *string2);
size_t strcspn (__const__ char *string1, __const__ char *string2);
char *strdup (__const__ char *string);
char *strerror (int errnum);
int stricmp (__const__ char *string1, __const__ char *string2);
size_t strlen (__const__ char *string);
char *strlwr (char *string);
char *strncat (char *string1, __const__ char *string2, size_t count);
int strncmp (__const__ char *string1, __const__ char *string2, size_t count);
char *strncpy (char *string1, __const__ char *string2, size_t count);
int strnicmp (__const__ char *string1, __const__ char *string2, size_t count);
char *strnset (char *string, int c, size_t count);
char *strpbrk (__const__ char *string1, __const__ char *string2);
char *strrchr (__const__ char *string, int c);
char *strrev (char *string);
char *strset (char *string, int c);
size_t strspn (__const__ char *string1, __const__ char *string2);
char *strstr (__const__ char *string1, __const__ char *string2);
char *strtok (char *string1, __const__ char *string2);
char *strupr (char *string);

size_t _memcount (__const__ void *mem, int c, size_t n);
size_t _memdif (__const__ void *mem1, __const__ void *m2m, size_t n);
void _memswap (void *s1, void *s2, size_t n);
char *_strncpy (char *string1, __const__ char *string2, size_t size);

#pragma pack(1)

  typedef unsigned      bit;

  typedef unsigned char byte;
  typedef signed char   sbyte;

  typedef unsigned int   word;
  typedef signed int    sword;

  typedef unsigned long dword;
  typedef signed long   sdword;

  typedef unsigned short ushort;
  typedef   signed short sshort;

  typedef unsigned long  ulong;
  typedef   signed long  slong;

struct _stamp    
{
  struct { word da : 5; word mo : 4; word yr : 7; } date;
  struct { word ss : 5; word mm : 6; word hh : 5; } time;
};

struct _dos_st
{
  word date;
  word time;
};

union stamp_combo
{
  dword ldate;
  struct _stamp msg_st;
  struct _dos_st dos_st;
};

typedef union stamp_combo SCOMBO;

int   lock(int fh, long offset, long len);
int   unlock(int fh, long offset, long len);

struct _msgapi;
struct _msgh;
struct _netaddr;
struct _xmsg;

typedef struct _msgapi MSG;
typedef struct _msgh MSGH;

typedef struct _msgapi *HAREA;
typedef struct _msgh *HMSG;

typedef struct _xmsg XMSG;
typedef struct _xmsg *PXMSG;

typedef struct _netaddr NETADDR;
typedef NETADDR *PNETADDR;

typedef dword UMSGID;

#pragma pack(1)
 
  struct _minf {
     
    word req_version;
    word def_zone;
    word haveshare;

    void * (*palloc)(size_t size);
    void   (*pfree)(void *ptr);
    void * (*repalloc)(void *ptr, size_t size);

    void * (*farpalloc)(size_t size);
    void   (*farpfree)(void *ptr);
    void * (*farrepalloc)(void *ptr, size_t size);
  };
 
struct _netaddr
{
  word zone;
  word net;
  word node;
  word point;
};

struct _xmsg
{
  dword attr;

  byte from[ 36 ];
  byte to[   36 ];
  byte subj[ 72 ];

  NETADDR orig;         
  NETADDR dest;

  struct _stamp date_written;    
  struct _stamp date_arrived;    
  sword utc_ofs;                 


  UMSGID replyto;                
  UMSGID replies[9 ];     
  dword umsgid;                  
  byte __ftsc_date[20]; 
};

struct _msgapi
{
  dword id;                        

  word len;                        
  word type;                       

  dword num_msg;                   
  dword cur_msg;                   
  dword high_msg;                  
  dword high_water;                

  word sz_xmsg;                    

  byte locked;                     
  byte isecho;                     
   
  struct _apifuncs {
    sword  (*CloseArea)(HAREA mh);
    HMSG   (*OpenMsg)  (HAREA mh,word mode,dword n);
    sword  (*CloseMsg) (HMSG msgh);
    dword  (*ReadMsg)  (HMSG msgh, PXMSG msg, dword ofs,
                                 dword bytes, byte *text, dword cbyt,
                                 byte *ctxt);
    sword  (*WriteMsg) (HMSG msgh, word append, PXMSG msg,
                                 byte *text, dword textlen,
                                 dword totlen, dword clen, byte *ctxt);
    sword  (*KillMsg)  (HAREA mh, dword msgnum);
    sword  (*Lock)     (HAREA mh);
    sword  (*Unlock)   (HAREA mh);
    sword  (*SetCurPos)(HMSG msgh, dword pos);
    dword  (*GetCurPos)(HMSG msgh);
    UMSGID (*MsgnToUid)(HAREA mh, dword msgnum);
    dword  (*UidToMsgn)(HAREA mh, UMSGID umsgid, word type);
    dword  (*GetHighWater)(HAREA mh);
    sword  (*SetHighWater)(HAREA mh, dword hwm);
    dword  (*GetTextLen)(HMSG msgh);
    dword  (*GetCtrlLen)(HMSG msgh);
    UMSGID (*GetNextUid)(HAREA harea);
  } *api;

  void *apidata;
};

struct _msgh
{
  HAREA ha;
  dword id;

  dword bytes_written;
  dword cur_pos;
};

typedef char BROWSE;

extern word msgapierr;

extern struct _minf mi;
 
  sword  MsgOpenApi(struct _minf *minf);
  sword  MsgCloseApi(void);

  HAREA  MsgOpenArea(byte *name, word mode, word type);
  sword  MsgValidate(word type, byte *name);
  sword  MsgBrowseArea(BROWSE *b);


  void  MsgFreeCtrlBuf(char *cbuf);
  void  MsgFreeCtrlToken(char *cbuf);

  byte *StripNasties(byte *str);
  byte *CopyToControlBuf(byte *txt, byte * *newtext, unsigned *length);
  byte *GetCtrlToken(byte *where, byte *what);
  void  ConvertControlInfo(byte *ctrl, PNETADDR orig, PNETADDR dest);
  byte *CvtCtrlToKludge(byte *ctrl);
  void  RemoveFromCtrl(byte *ctrl,byte *what);
  word  NumKludges(char *txt);
  int   WriteZPInfo(PXMSG msg, void (*wfunc)(byte *str), byte *kludges);

  void  SquishSetMaxMsg(HAREA sq, dword max_msgs, dword skip_msgs, dword age);
  dword SquishHash(byte *f);

  HAREA   SdmOpenArea(byte *name, word mode, word type);
  sword   SdmValidate(byte *name);

  HAREA   SquishOpenArea(byte *name, word mode, word type);
  sword   SquishValidate(byte *name);

  sword InvalidMsgh(HMSG msgh);
  sword InvalidMh(HAREA mh);

  void ParseNNN(char *netnode, NETADDR *pn, word all);

  int farread(int handle, byte *buf, unsigned len);
  int farwrite(int handle, byte *buf, unsigned len);

  byte *Address(NETADDR *a);
  
    extern void * (*palloc)(size_t size);
    extern void (*pfree)(void *ptr);
    extern void * (*repalloc)(void *ptr, size_t size);

    extern void * (*farpalloc)(size_t size);
    extern void (*farpfree)(void *ptr);
    extern void * (*farrepalloc)(void *ptr, size_t size);
  
void segviol() {
  abort();
}

int dosftime(char *buf, int size, char *format, struct _stamp time) {
return sprintf(buf,"%02d.%02d.%02d %02d:%02d:%02d",
	       time.date.da,time.date.mo,time.date.yr+80,
	       time.time.hh,time.time.mm,time.time.ss);
}

char *fido(NETADDR *n) {
static char buf[25];

  sprintf(buf,"%d:%d/%d.%d",n->zone,n->net,n->node,n->point);
return buf;
}

int main(int argc,char *argv[]) {
XMSG msg;
HAREA in_area;
HMSG in_msg;
 
struct _minf mi;
char *ctrl,*buffer,*name,*p;
dword offset, msgn;
long got;
int ctrllen,type;

  if (argc<2) {
    fprintf((&_streamv[2]) ,"Areaname expected\n");
    exit(1);
  }

  type=(*( argv[1] )=='$' ?  0x02  :     0x01 ) ;

  name=strdup((*( argv[1] )=='$' ? ( argv[1] )+1 : ( argv[1] )) );

  printf("Reading %s Area %s\n",
	 type== 0x02  ? "Squish" : "*.Msg",name);

  signal( 11 ,segviol);

  memset(&mi, '\0', sizeof mi);
  mi.req_version=1;
  mi.def_zone=2;

  mi.palloc   = mi.farpalloc   = malloc;
  mi.repalloc = mi.farrepalloc = realloc;
  mi.pfree    = mi.farpfree    = free;

  printf("sizeof mi=%ld\n",sizeof mi);
  MsgOpenApi(&mi);

  if (mi.def_zone!=2) {
    fprintf((&_streamv[2]) ,"alignment error in struct _minf\n");
    exit(1);
  }

  if ((in_area=MsgOpenArea(name,  0x00 , type))==((void *)0) )
  {
    printf("Error opening area `%s' (type %s) for read!\n",
	   name,type== 0x02  ? "Squish" : "*.Msg");
    exit(1);
  }

  if ((buffer=malloc(8192 ))==((void *)0) )
  {
    printf("Error!  Ran out of memory...\n");
    exit(1);
  }

  for (msgn=1L; msgn <=        (( in_area )->high_msg) ; msgn++)
  {
    if ((in_msg= (*( in_area )->api->OpenMsg)          ( in_area ,      1  , msgn ) )==((void *)0) )
      continue;

    ctrllen=(int)      (*(((HMSG) in_msg )->ha->api->GetCtrlLen))( in_msg ) ;

    if ((ctrl=malloc(ctrllen))==((void *)0) )
      ctrllen=0;

    (*(((HMSG) in_msg )->ha->api->ReadMsg))( in_msg ,  &msg ,  0L ,  0L ,  ((void *)0)  ,  ctrllen ,  ctrl ) ;
    ConvertControlInfo(ctrl,&msg.orig,&msg.dest);

    dosftime(buffer,20,"%d %m %y %H:%M:%S",msg.date_written);
    printf("From: %s, %s (%s)\n",msg.from,fido(&msg.orig),buffer);
    dosftime(buffer,20,"%d %m %y %H:%M:%S",msg.date_arrived);
    printf("To:   %s, %s (%s)\n",msg.to,fido(&msg.dest),buffer);
    printf("Subj: %s\n",msg.subj);

    if (((p=ctrl)!=((void *)0) ) && *ctrl) {
      while (*p) {
	switch (*p) {
	  case '\001':
	    putchar('@');
 	    break;
	  default:
	    putchar(*p);
 	    break;
	}
	++p;
	if ((*p && (*p=='\001')) ||
	    (*p=='\0'))
	  putchar('\n');
      }
    }

    for (offset=0L; offset <       (*(((HMSG) in_msg )->ha->api->GetTextLen))( in_msg ) ;)
    {
      got=(*(((HMSG) in_msg )->ha->api->ReadMsg))( in_msg ,  ((void *)0)  ,  offset ,  8192  ,  buffer ,  0L ,  ((void *)0)  ) ;

      if (got <= 0)
        break;

      p=buffer;
      while (*p) {
        putchar(*p);
	if (*p=='\r') putchar('\n');
	++p;
      }
      offset += got;
    }

    if (ctrl)
      free(ctrl);

         ((*(((HMSG) in_msg )->ha->api->CloseMsg))( in_msg )) ;
  }

  free(buffer);
        (*( in_area )->api->CloseArea) ( in_area ) ;
 
  MsgCloseApi();

  printf("\nDone!\n");
  free(name);
  return 0;
}
