/*******************************************************************
* Join 2 pieces of a file together
*
* Syntax: join AppendedFile FileToAppend
*
*******************************************************************/
#define INCL_DOS
#include <os2.h>

#include <stdio.h>            // printf & sprintf

#define BUFFER_SIZE 8192      // Size of read buffer

int main (int argc, char **argv)
{
APIRET      rc;                 // Return code
HFILE       hAppendedFile;      // File handle for merged file
HFILE       hFileToAppend;      // File handle for file to append
char        *AppendedFile;      // Point to Appended File string
char        *FileToAppend;      // Point to File To Append string
FILESTATUS3 FileStatus;         // File information for FileToAppend
ULONG       ulFileSize;         // File size for FileToAppend
ULONG       action;             // Action taken for a DosOpen call
ULONG       ulNewPointer;       // New pointer location for DosSetFilePtr
ULONG       ulPosition;         // Location in FileToAppend
ULONG       ulBytesRead;        // How many bytes were read on DosRead
ULONG       ulBytesWritten;     // How many bytes were written on DosWrite
BYTE        buffer[BUFFER_SIZE];// Read/Write buffer

   /**********************************************************************
   * Check the number of command line arguments. We are supposed to have
   * 2 arguements: The file to append to and the file we are appending
   **********************************************************************/
   rc=0;
   if (argc==3)
      {
      ulPosition=0;
      AppendedFile=argv[1];
      FileToAppend=argv[2];
      rc=DosOpen(AppendedFile, &hAppendedFile, &action, 0L, 0L,
              OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW,
              OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_WRITEONLY,
              0L);
      if (rc==0)
         {
         rc=DosSetFilePtr(hAppendedFile, 0, FILE_END, &ulNewPointer);
         } /* end IF */
      if (rc==0)
         {
         rc=DosOpen(FileToAppend, &hFileToAppend, &action, ulBytesRead, 0L,
                 OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_FAIL_IF_NEW,
                 OPEN_SHARE_DENYNONE | OPEN_ACCESS_READONLY,
                 0L);
         } /* end IF */
      if (rc==0)
         {
         rc=DosQueryFileInfo(hFileToAppend, 1, &FileStatus, sizeof(FileStatus));
         ulFileSize=FileStatus.cbFile;
         } /* end IF */
      if (rc==0)
         {
         printf("Appending %s to the end of %s\n",FileToAppend, AppendedFile);
         while (ulPosition<ulFileSize && rc==0)
            {
            rc=DosRead(hFileToAppend, buffer, BUFFER_SIZE, &ulBytesRead);
            if (rc==0)
               {
               ulPosition+=ulBytesRead;
               rc=DosWrite(hAppendedFile, buffer, ulBytesRead, &ulBytesWritten);
               } /* end IF */
            } /* end while */
         } /* end IF */
      DosClose(hFileToAppend);
      DosClose(hAppendedFile);
      } /* end if */
   else /* */
      {
      printf("  Syntax is: join AppendedFile FileToAppend\n\n");
      printf("  For example: 'join oem.wav oem.1' results in\n");
      printf("    oem.1 being appended to the end of oem.wav.\n");
      } /* end ELSE */
   /*****************************************************
   * If we had an error condition, print out a message
   *****************************************************/
   if (rc)
      printf("We encountered an error code on a Dos call: %d\n", rc);
   return(rc);
}
