#if !defined(SPELL_H)
#define SPELL_H

#if !defined(__SPOBJS_H)
#include "spobjs.h"
#endif

#define ItemsInPage 2048

class BaseDic {
public:
unsigned IndexCacheSize;
unsigned DictCacheSize;
tagHeader header;
int curLetter;
long curWord; //
int error;
static const char*sfx[NSFX]; 

};


class MainDictionary :virtual public BaseDic{

public:

        MainDictionary(char *name ,unsigned Dcachesize =16384,
				unsigned IcacheSize =16384);

        virtual int lookup(char *word) ;
        virtual void reset() =0;      //

	protected:
	char *word;
       virtual int load_mdict(char*name) =0;

       virtual int load_index(char* name) =0;

       virtual long search(char *,long) =0;

		void * index ;     // index array
		void * dict ;     //

		long *pages;
		long cpages;


		long  from ,to;
                long blkcnt; //
                unsigned int offset; //
		//static const char *sfx[31];  ////// new !!
                //static const char *hiValue;

};

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

#if !defined (__386__) && !defined ( DOS386 ) && !defined (__DPMI16__)

class XMSDictionary :public MainDictionary {
public:

        XMSDictionary(char *name ,unsigned Dcachesize =16384,
				unsigned IcacheSize =16384);
        ~XMSDictionary();

        virtual char *nextWord() ;
        virtual void reset();      //

	protected:

	virtual long search(char* ,long);
        virtual int load_mdict(char*name) ;

       virtual int load_index(char* name) ;
       int cmpread(FILE *);
                void reset_fifo();
		void reset_block();

};

inline void XMSDictionary::reset()
{
blkcnt=0;
curWord=0;
char *tmp=(char *)((xms*)dict)->at(0);
curLetter=0;
offset=0;

}

inline void XMSDictionary::reset_block()
{
((xms*)dict)->curblock=-1;
((xms*)index)->curblock=-1;

}

inline void XMSDictionary::reset_fifo()
{
((xms*)dict)->fifo_reset();
((xms*)index)->fifo_reset();
}

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////


#if defined (__BORLANDC__)
class EMSDictionary :public MainDictionary {
public:

        EMSDictionary(char *name ,unsigned Dcachesize =16384,
				unsigned IcacheSize =16384);
        ~EMSDictionary();

        virtual char *nextWord() ;
        virtual void reset();      //

	protected:

	virtual long search(char* ,long);
        virtual int load_mdict(char*name) ;

       virtual int load_index(char* name) ;
       int cmpread(FILE *);
                void reset_fifo(){;}
		void reset_block();

};

inline void EMSDictionary::reset()
{
blkcnt=0;
curWord=0;
char *tmp=(char *)((ems*)dict)->at(0);
curLetter=0;
offset=0;

}

inline void EMSDictionary::reset_block()
{
((ems*)dict)->curblock=-1;
((ems*)index)->curblock=-1;

}
#endif

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////


class CXMSDictionary :public MainDictionary {
public:

        CXMSDictionary(char *name ,unsigned Dcachesize =16384,
				unsigned IcacheSize =16384);
        ~CXMSDictionary(); // !!!!!!!!!!!!

        virtual char *nextWord() {return nextword();}
        virtual void reset();      //
	virtual int lookup(char *);
	protected:

        virtual long search(char* ,long){return 1;}
	virtual int load_mdict(char*name) ;

       virtual int load_index(char* name) {return 1;}

                //void reset_fifo(){;}
		char *nextword();

                tagCheader cheader;
                tagAddHeader add_header;
		int pblock[27]; //ptr to block
		int offs[27];
		IndexNode *idx;
		char *prevword;
		char *tmp;
                void reset_block();
                void reset_fifo();



};

inline void CXMSDictionary::reset()
{
blkcnt=0;
curWord=0;
prevword="";
curLetter=0;
offset=0;
reset_block();
reset_fifo();
}

inline void CXMSDictionary::reset_block()
{
  ((xms*)dict)->curblock=-1;
   tmp=(char*)((xms*)dict)->ats(cheader.firstLetter[curLetter]);

}

inline void CXMSDictionary::reset_fifo()
{
((xms*)dict)->fifo_reset();
}


#endif

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

class DBDictionary :public MainDictionary {
public:

        DBDictionary(char *name ,unsigned Dcachesize =16384,
				unsigned IcacheSize =16384);
        ~DBDictionary();

        virtual char *nextWord() {return nextword();}
        virtual void reset();      //
	virtual int lookup(char *);
	protected:

        virtual long search(char* ,long){return 1;}
	virtual int load_mdict(char*name) ;

       virtual int load_index(char* name) {return 1;}

		void reset_fifo(){;}
		void reset_block(){
		  fseek((FILE *)dict,cheader.firstLetter[curLetter],SEEK_SET);}
		void CreateIndex();
		char *nextword();
                tagCheader cheader;
                tagAddHeader add_header;

		int pblock[27]; //ptr to block
		int offs[27];
		IndexNode *idx;
		char *prevword;



};

inline void DBDictionary::reset()
{
blkcnt=0;
curWord=0;
//char *tmp="";
prevword="";
curLetter=0;
offset=0;
reset_block();

}


////////////////////////////////////////////////////////////////////
//                                                                //
//                                                                //
//                                                                //
//                                                                //
////////////////////////////////////////////////////////////////////


class spell:virtual public BaseDic{
public:

        static spell *Spell;   //<---- static member points to this
        MatchTable *suggestion;
        FastDictionary *userDic;
        FastDictionary *tempDic;
        FastDictionary *ignoreDic;
//	Table * fastDic;


        spell(char *main_dic="main.dic",char *user_dic="user.dic",
      char *temp_dic="temp.dic") ;
        ~spell(void);
//
//   Main public interface
//
        int check(char *);
        int suggest(const char *);
	int suggest2(const char *);
        char *ignore(char *word){return ignoreDic->insert(word);}
        int add(char *word ,FastDictionary *dic);
//
	int rcheck(char *);
	int addToUserDic(char *word) {return add(word,userDic);}
        int addToTempDic(char *word) {return add(word,tempDic);}
	void saveUserDic(){ userDic->save(userDicName);}
	void saveTempDic(){ tempDic->save(tempDicName);}
        int merge(FastDictionary *dic,char *name="main.dic");
        //int reload(MainDictionary *,char *name="main.dic");
        int reload(FastDictionary *,char *name="user.dic");
        void SetLevel(int Level) { level |= Level;}
        int getLastError(){return error;}
        void clearError(){ error = 0;}
        int  writeWord(char *s,FILE *,FILE *);
        virtual int Lookup(char *word)=0;
        virtual char *NextWord()=0;
        int isModified();
protected:
	virtual void reset_block()=0;
	virtual void reset_fifo()=0;
        int MaxMatches ;
        int like;
        int level; // level for suggesstion of misspelled words
        int found;
        int minwordlen;
        int maxwordlen;

        int error;
        char *tempword;
        char *mainDicName;
        char *userDicName;
        char *tempDicName;
        //////////////////
	long offset;
        int curoffs;
        int UpperFlag;
        int cLetter;
	long lineCount;
        tagHeader newheader;
        tagAddHeader newaheader;
        tagCheader newcheader;
        IndexNode *newIndex;
        char *prevw;
        char *tempw;
	char *wrd;
        long *new_pages;
        long new_cpage;
        long npages;
        long page_pos;
        long index_pos;

};

inline spell::isModified()
{
  int val=0;
 if(userDic->modified)
        val |=USER_DIC;
 if(tempDic->modified)
        val |=TEMP_DIC;
 return val;
}
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

#if !defined (__386__) && !defined ( DOS386 ) && !defined (__DPMI16__)

class XmsSpell : public spell,public  XMSDictionary{
public:
        XmsSpell(char *main_dic="main.dic",char *user_dic="user.dic",
      char *temp_dic="temp.dic",unsigned int Dcache=16384,
      unsigned int Icache=16384)
        : spell(main_dic,user_dic,temp_dic) ,
        XMSDictionary(main_dic ,Dcache,Icache){
            maxwordlen = max(header.maxSize,userDic->maxWordLen);
              error=XMSDictionary::error;}

        int reload(XMSDictionary *dic,char *name="main.dic")
                {
                unsigned ICache=dic->IndexCacheSize;
                unsigned DCache=dic->DictCacheSize;

                delete  dic;
                clearError();
                dic = new XMSDictionary(name, DCache, ICache);
                if(dic ->error)
                {
                        error++;
                        return 0;
                        }
                return 1;
                };

        inline virtual int Lookup(char *word){
                        return XMSDictionary::lookup(word);}
        inline virtual char *NextWord() {
                        return XMSDictionary::nextWord();}
	protected:
	inline void reset_block(){XMSDictionary::reset_block();}
	inline void reset_fifo(){ XMSDictionary::reset_fifo();}

};

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

class CXmsSpell : public spell,public  CXMSDictionary{
public:
        CXmsSpell(char *main_dic="main.dic",char *user_dic="user.dic",
      char *temp_dic="temp.dic",unsigned int Dcache=16384,
      unsigned int Icache=16384)
        : spell(main_dic,user_dic,temp_dic) ,
        CXMSDictionary(main_dic ,Dcache,Icache){
            maxwordlen = max(header.maxSize,userDic->maxWordLen);
              error=CXMSDictionary::error;}

        int reload(CXMSDictionary *dic,char *name="main.dic")
                {
                unsigned ICache=dic->IndexCacheSize;
                unsigned DCache=dic->DictCacheSize;

                delete dic;
                clearError();
                dic = new CXMSDictionary(name, DCache, ICache);
                if(dic ->error)
                        {
                        error++;
                        return 0;
                }
                return 1;
                }

        inline virtual int Lookup(char *word){
                        return lookup(word);}
        inline virtual char *NextWord() {
                        return nextWord();}
	protected:
        inline void reset_block(){CXMSDictionary::reset_block();}
        inline void reset_fifo(){ CXMSDictionary::reset_fifo();}

};

////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

#if defined (__BORLANDC__)
class EmsSpell : public spell,public  EMSDictionary{
public:
        EmsSpell(char *main_dic="main.dic",char *user_dic="user.dic",
      char *temp_dic="temp.dic",unsigned int Dcache=16384,
      unsigned int Icache=16384)
        : spell(main_dic,user_dic,temp_dic) ,
        EMSDictionary(main_dic ,Dcache,Icache){
            maxwordlen = max(header.maxSize,userDic->maxWordLen);
              error=EMSDictionary::error;}

        int reload(EMSDictionary *dic,char *name="main.dic")
                {
                unsigned ICache=dic->IndexCacheSize;
                unsigned DCache=dic->DictCacheSize;

                delete dic;
                clearError();
                dic = new EMSDictionary(name, DCache, ICache);
                if(dic ->error)
                        {
                        error++;
                        return 0;
                }
                return 1;
                }

        inline virtual int Lookup(char *word){
                        return EMSDictionary::lookup(word);}
        inline virtual char *NextWord() {
                        return EMSDictionary::nextWord();}
	protected:
        inline void reset_block(){EMSDictionary::reset_block();}
        inline void reset_fifo(){ EMSDictionary::reset_fifo();}

};

#endif

#endif // !protmode
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////

class DiskSpell : public spell,public  DBDictionary{
public:
	DiskSpell(char *main_dic="main.dic",char *user_dic="user.dic",
      char *temp_dic="temp.dic",unsigned int Dcache=16384,
      unsigned int Icache=16384)
	: spell(main_dic,user_dic,temp_dic) ,
        DBDictionary(main_dic ,Dcache,Icache){
            maxwordlen = max(header.maxSize,userDic->maxWordLen);
              error=DBDictionary::error;}

        int reload(DBDictionary *dic,char *name="main.dic")
                {
                unsigned ICache=dic->IndexCacheSize;
                unsigned DCache=dic->DictCacheSize;

                delete dic;
                clearError();
                dic = new DBDictionary(name, DCache, ICache);
                if(dic ->error)
                        {
                        error++;
                        return 0;
                }
                return 1;
                }

        inline virtual int Lookup(char *word){
                        return DBDictionary::lookup(word);}
        inline virtual char *NextWord() {
                        return DBDictionary::nextWord();}
	protected:
	inline void reset_block(){DBDictionary::reset_block();}
	inline void reset_fifo(){ DBDictionary::reset_fifo();}

};
#endif // SPELL_H

