unit rctypes;

{**************************************************************************
 *                   Sourcefile fr Speed-386                             *
 *           Created using (c) Borland International 1993                 *
 *        (C) 1993,94 R.Nrnberger Franz-Mehring-Str.2 09112 Chemnitz     *
 *                                                                        *
 * Beschreibung: Typen und Konstanten fr den Resourcencompiler RCOMP     *
 *                                                                        *
 **************************************************************************
 }

interface

uses dos,crt;

VAR QuellDat,ZielDat:String;
    Quellf:Text;
    Zielf:File;
    d:dirstr;
    n:namestr;
    e:extstr;
    zeile:string;
    command:string;
    CommandItem:WORD;
    params:string;
    MenuOffset:LONGINT;
    DialogOffset:LONGINT;
    IconOffset:LONGINT;
    BitmapOffset:LONGINT;
    AccelOffset:LONGINT;
    HelpTableOffset:LONGINT;
    HelpSubTableOffset:LONGINT;

CONST
    lineback:boolean=false;

TYPE
    TStyle=RECORD
                 Name:STRING[40];
                 Style:LONGINT;
           END;

    PDialog=^_TDialog;
    _TDialog=RECORD
                 Title:STRING;
                 ident:WORD;
                 InteriorCount:WORD;
                 Art:Word;
                 x,y,x1,y1:WORD;
                 Style:LONGINT;
                 Flags:LONGINT;
                 Interior:PDialog;
                 SubSize:LONGINT;
                 DataCount:BYTE;
                 Data:ARRAY[0..20] OF WORD;
                 PresParamBytes:WORD;
                 PresParams:ARRAY[0..255] OF BYTE;
                 Next:PDialog;
            END;

    PMenu=^TMenu;
    TMenu=record
               MenuName:string[40];
               Ident:Word;
               SubSize:LONGINT;
               SubCount:Byte;
               SubMenus:PMenu;
               Style:WORD;
               Attrib:WORD;
               Next:PMenu;
    END;

    PIcon=^TIcon;
    TIcon=record
               IconName:string[40];
               Ident:Word;
               SubSize:LONGINT;
               Next:PIcon;
    END;

    PAccel=^TAccel;
    TAccel=RECORD
                 ident:WORD;
                 name:WORD;
                 Flag:WORD;
                 SubCount:WORD;
                 SubSize:WORD;
                 Entries:PAccel;
                 Next:PAccel;
           END;

    PHelptableEntry=^THelpTableEntry;
    THelpTableEntry=RECORD
                            i1,i2,i3:WORD;
                            Next:PHelpTableEntry;
                      END;

    PHelpTable=^THelpTable;
    THelptable=RECORD
                     Ident:WORD;
                     SubSize:WORD;
                     Entries:PHelpTableEntry;
                     Next:PHelpTable;
               END;

    TCommand=record
                  command:string[40];
                  item:Longint;
             end;

CONST
    __ICON            =1;
    __MENU            =2;
    __BEGIN           =3;
    __END             =4;
    __MENUITEM        =5;
    __SUBMENU         =6;
    __BITMAP          =7;
    __POINTER         =8;
    __CONST           =9;
    __DLGTEMPLATE     =10;
    __DIALOG          =11;
    __STYLE           =12;
    __FLAGS           =13;
    __LTEXT           =14;
    __RTEXT           =15;
    __PUSHBUTTON      =16;
    __GROUPBOX        =17;
    __AUTORADIOBUTTON =18;
    __AUTOCHECKBOX    =19;
    __RADIOBUTTON     =20;
    __CHECKBOX        =21;
    __DEFPUSHBUTTON   =22;
    __CTEXT           =23;
    __COMBOBOX        =24;
    __ENTRYFIELD      =25;
    __CONTROL         =26;
    __TYPE            =27;
    __CTLDATA         =28;
    __PRESPARAMS      =29;
    __MLE             =30;
    __ACCELTABLE      =31;
    __LISTBOX         =32;
    __HELPTABLE       =33;
    __HELPITEM        =34;
    __HELPSUBTABLE    =35;
    __HELPSUBITEM     =36;
    __SCROLLBAR       =37;
    __SLIDER          =38;
    __VALUESET        =39;
    __CONTAINER       =40;
    __SPINBUTTON      =41;
    __FRAME           =42;

    maxcommands   =42;
    COMMANDS:Array[1..maxcommands] OF TCommand=(
     (command:'ICON';item:__ICON),
     (command:'MENU';item:__MENU),
     (command:'BEGIN';Item:__BEGIN),
     (command:'END';item:__END),
     (command:'MENUITEM';item:__MENUITEM),
     (command:'SUBMENU';item:__SUBMENU),
     (command:'BITMAP';item:__BITMAP),
     (command:'POINTER';item:__POINTER),
     (command:'CONST';item:__CONST),
     (command:'DLGTEMPLATE';item:__DLGTEMPLATE),
     (command:'DIALOG';item:__DIALOG),
     (command:'STYLE';item:__STYLE),
     (command:'FLAGS';item:__FLAGS),
     (command:'LTEXT';item:__LTEXT),
     (command:'RTEXT';item:__RTEXT),
     (command:'PUSHBUTTON';item:__PUSHBUTTON),
     (command:'GROUPBOX';item:__GROUPBOX),
     (command:'AUTORADIOBUTTON';item:__AUTORADIOBUTTON),
     (command:'AUTOCHECKBOX';item:__AUTOCHECKBOX),
     (command:'RADIOBUTTON';item:__RADIOBUTTON),
     (command:'CHECKBOX';item:__CHECKBOX),
     (command:'DEFPUSHBUTTON';item:__DEFPUSHBUTTON),
     (command:'CTEXT';item:__CTEXT),
     (command:'COMBOBOX';item:__COMBOBOX),
     (command:'ENTRYFIELD';item:__ENTRYFIELD),
     (command:'CONTROL';item:__CONTROL),
     (command:'TYPE';item:__TYPE),
     (command:'CTLDATA';item:__CTLDATA),
     (command:'PRESPARAMS';item:__PRESPARAMS),
     (command:'MLE';item:__MLE),
     (command:'ACCELTABLE';item:__ACCELTABLE),
     (command:'LISTBOX';item:__LISTBOX),
     (command:'HELPTABLE';item:__HELPTABLE),
     (command:'HELPITEM';item:__HELPITEM),
     (command:'HELPSUBTABLE';item:__HELPSUBTABLE),
     (command:'HELPSUBITEM';item:__HELPSUBITEM),
     (command:'SCROLLBAR';item:__SCROLLBAR),
     (command:'SLIDER';item:__SLIDER),
     (command:'VALUESET';item:__VALUESET),
     (command:'CONTAINER';item:__CONTAINER),
     (command:'SPINBUTTON';item:__SPINBUTTON),
     (command:'FRAME';item:__FRAME)
     );

TYPE
   TStyles=record
                  Style:string[40];
                  itemlo,itemhi:Word;
             end;

    PConstant=^TConstant;
    TConstant=RECORD
                    Name:STRING;
                    item:LONGINT;
                    Next:PConstant;
              END;

CONST
    PresParamtypes:Array[1..14] OF STRING[40]=(
    'PP_FOREGROUNDCOLOR','PP_FOREGROUNDCOLORINDEX',
    'PP_BACKGROUNDCOLOR','PP_BACKGROUNDCOLORINDEX',
    'PP_HILITEFOREGROUNDCOLOR','PP_HILITEFOREGROUNDCOLORINDEX',
    'PP_HILITEBACKGROUNDCOLOR','PP_HILITEBACKGROUNDCOLORINDEX',
    'PP_FOREGROUNDCOLOR','PP_FOREGROUNDCOLORINDEX', {dummys}
    'PP_FOREGROUNDCOLOR','PP_FOREGROUNDCOLORINDEX', {dummys}
    'PP_BORDERCOLOR','PP_BORDERCOLORINDEX');

   Colors:Array[1..22] OF TStyle=(
    (Name:'CLR_FALSE';Style:-5),
    (Name:'CLR_TRUE';Style:-4),
    (Name:'CLR_ERROR';Style:-255),
    (Name:'CLR_DEFAULT';Style:-3),
    (Name:'CLR_WHITE';Style:-2),
    (Name:'CLR_BLACK';Style:-1),
    (Name:'CLR_BACKGROUND';Style:0),
    (Name:'CLR_BLUE';Style:1),
    (Name:'CLR_RED';Style:2),
    (Name:'CLR_PINK';Style:3),
    (Name:'CLR_GREEN';Style:4),
    (Name:'CLR_CYAN';Style:5),
    (Name:'CLR_YELLOW';Style:6),
    (Name:'CLR_NEUTRAL';Style:7),
    (Name:'CLR_DARKGRAY';Style:8),
    (Name:'CLR_DARKBLUE';Style:9),
    (Name:'CLR_DARKRED';Style:10),
    (Name:'CLR_DARKPINK';Style:11),
    (Name:'CLR_DARKGREEN';Style:12),
    (Name:'CLR_DARKCYAN';Style:13),
    (Name:'CLR_BROWN';Style:14),
    (Name:'CLR_PALEGRAY';Style:15)
    );

CONST
     WM_SETLINK =$1005;
     WM_USER_DRAW_M  = $1001;
     WM_USER_DRAW_A  = $1002;
     WM_USER_DRAW_L  = $1003;
     WM_DISMISS      = $1004;

CONST
   Quelline:word=0;
   Dialogs:PDialog=NIL;
   Menus:PMenu=NIL;
   Icons:PIcon=NIL;
   Bitmaps:PIcon=NIL;
   Constants:PConstant=NIL;
   Accelerators:PAccel=NIL;
   HelpTables:PHelptable=NIL;
   HelpSubTables:PHelpTable=NIL;

VAR
   err:STRING;
   ErrorDetected:BOOLEAN;
   ResDlg:LONGWORD;

PROCEDURE Read_line;
PROCEDURE SplitLine(var s,s1:string;trenn:Char);
PROCEDURE error(msg:string);
PROCEDURE WriteByte(value:Byte);
PROCEDURE WriteWord(value:word);
Procedure Writestr(s:string);
FUNCTION SearchConstant(VAR s:string;VAR value:LONGINT):BOOLEAN;
PROCEDURE ParseConst;
PROCEDURE GetPresParams(d:PDialog);

implementation

IMPORTS
       FUNCTION WinPostMsg(mp2,mp1:POINTER;
                           msg:LONGWORD;
                           _hwnd:HWND):LONGWORD:        PMWIN index 919;
END;

PROCEDURE error(msg:string);
VAR p:POINTER;
LABEL l;
BEGIN
     err:=msg;
     ErrorDetected:=TRUE;
     Close(Quellf);
     Close(Zielf);
     IF quelline<>1 THEN dec(quelline);
     ASM
        MOVD $p,1   ;Error occured
     END;
     WinPostMsg(NIL,p,WM_DISMISS,ResDlg); {Delete dialog window}
l:
     goto l;
END;


FUNCTION SearchConstant(VAR s:string;VAR value:LONGINT):BOOLEAN;
VAR dummy:PConstant;
    t:BYTE;
BEGIN
     FOR t:=1 TO length(s) Do s[t]:=upcase(s[t]);
     dummy:=Constants;
     WHILE dummy<>NIL DO
     BEGIN
          IF dummy^.name=s THEN
          BEGIN
               value:=dummy^.item;
               SearchConstant:=TRUE;
               exit;
          END;
          dummy:=dummy^.next;
     END;
     SearchConstant:=FALSE;
END;


PROCEDURE NewConstant(VAR s:String;item:LONGINT);
VAR dummy:PConstant;
    t:BYTE;
BEGIN
     FOR t:=1 TO length(s) Do s[t]:=upcase(s[t]);
     IF Constants=NIL THEN
     BEGIN
          New(Constants);
          dummy:=Constants;
     END
     ELSE
     BEGIN
          dummy:=Constants;
          WHILE dummy^.next<>NIL DO dummy:=dummy^.next;
          New(Dummy^.next);
          dummy:=dummy^.next;
     END;
     dummy^.name:=s;
     dummy^.item:=item;
     dummy^.next:=NIL;
END;

PROCEDURE ParseConst;
VAR s:String;
    i:longint;
    code:Integer;
label l;
BEGIN
l:
     Read_line;
     IF commanditem=__END THEN exit;
     IF Params<>'' THEN Error('Syntax error');
     Splitline(command,s,'=');
     val(command,i,code);
     IF code<>0 THEN Error('Illegal numeric format');
     IF pos(' ',s)<>0 THEN Error('Illegal constant:'+s);
     NewConstant(s,i);
     Params:='';
     goto l;
END;

PROCEDURE WriteByte(value:Byte);
BEGIN
     Blockwrite(Zielf,value,1);
     if ioresult<>0 then error('File write error');
END;

PROCEDURE WriteWord(value:word);
BEGIN
     Blockwrite(Zielf,value,2);
     if ioresult<>0 then error('File write error');
END;

Procedure Writestr(s:string);
BEGIN
     s:=s+#0;
     Blockwrite(Zielf,s[1],length(s));
     if ioresult<>0 then error('File write error');
END;

PROCEDURE Read_line;
VAR spos,spos1:byte;
label l,l1;
BEGIN
     if lineback then
     begin
          lineback:=false;
          exit;
     end;
l:
     if eof(quellf) then
     begin
          zeile:='';
          command:='';
          params:='';
          commanditem:=__END;
          exit;
     end;
     inc(quelline);
     readln(quellf,zeile);
     if ioresult<>0 then error('Error reading from sourcefile');

l1:
     spos:=pos('/*',zeile);
     IF spos<>0 THEN {entferne Kommentare}
     BEGIN
          spos1:=pos('*/',zeile);
          IF spos1=0 THEN Error('Unexpected end of comment');
          Delete(zeile,spos,(spos1-spos)+2);
          goto l1;
     END;

     while zeile[length(zeile)]=#32 do dec(zeile[0]);
     while ((zeile[1]=#32)and(length(zeile)>0)) do zeile:=copy(zeile,2,length(zeile)-1);
     WHILE ((length(zeile)>0)and(zeile[length(zeile)]=#0)) DO dec(zeile[0]);

     WHILE ((length(Zeile)>0)AND(Zeile[1]<=#32)) DO dec(zeile[0]);
     if zeile='' then goto l;
     spos:=pos(#32,zeile);
     if spos=0 then
     begin
          command:=zeile;
          params:='';
     end
     else
     begin
          command:=copy(zeile,1,spos-1);
          params:=zeile;
          delete(params,1,spos);
     end;
     commanditem:=0;

     for spos:=1 to length(command) do command[spos]:=upcase(command[spos]);
     for spos:=1 to maxcommands do
      if commands[spos].command=command then
      begin
           commanditem:=spos;
           spos:=maxcommands;
      end;
END;

PROCEDURE SplitLine(var s,s1:string;trenn:Char);
var b,t:byte;
    instring:BOOLEAN;
Label l;
BEGIN
     b:=0;
     InString:=FALSE;
     FOR t:=1 to length(s) DO
     BEGIN
          IF s[t]='"' THEN instring:=not instring;
          IF s[t]=trenn THEN IF not instring THEN
          BEGIN
               b:=t;
               goto l;
          END;
     END;
l:
     if b=0 then
     begin
          s1:=s;
          s:='';
     end
     else
     begin
         s1:=copy(s,1,b-1);
         delete(s,1,b);
     end;
     while s1[length(s1)]=#32 do dec(s1[0]);
     while ((s1[1]=#32)and(length(s1)>0)) do delete(s1,1,1);
     while s[length(s)]=#32 do dec(s[0]);
     while ((s[1]=#32)and(length(s)>0)) do delete(s,1,1);
END;

PROCEDURE GetPresParams(d:PDialog);
VAR s:string;
    l:longint;
    w,t:word;
    FirstPres:BOOLEAN;
    PresOfs:WORD;
Label ll,l1,l2;
BEGIN
     FirstPres:=TRUE;
     FOR t:=0 TO 11 DO d^.PresParams[t]:=0;
     d^.PresParams[0]:=0;  {initial size}
     PresOfs:=4;
ll:
     SplitLine(Params,s,',');
     IF s='PP_FONTNAMESIZE' THEN
     BEGIN
          IF Params[1]<>'"' THEN Error('String expected');
          IF Params[length(Params)]<>'"' THEN Error('String expected');
          delete(params,1,1);
          dec(Params[0]);
          Params:=Params+#0;

          d^.PresParams[PresOfs]:=15; {id_ppFontnamesize}
          d^.PresParams[PresOfs+1]:=0;
          d^.PresParams[PresOfs+2]:=0;
          d^.PresParams[PresOfs+3]:=0;
          inc(d^.PresParams[0],4);
          {inc(d^.PresParams[8],4);}
          inc(PresOfs,4);
          {???}
          d^.PresParams[PresOfs]:=length(Params);
          d^.PresParams[PresOfs+1]:=0;
          d^.PresParams[PresOfs+2]:=0;
          d^.PresParams[PresOfs+3]:=0;
          inc(d^.PresParams[0],4);
          {inc(d^.PresParams[8],4);}
          inc(PresOfs,4);
          {???}

          FOR t:=Presofs TO PresOfs+length(Params) DO d^.PresParams[t]:=ord(Params[(t-PresOfs)+1]);
          inc(d^.PresParams[0],length(params));
          {inc(d^.PresParams[8],length(params));}
          inc(PresOfs,length(Params));
     END
     ELSE
     BEGIN
          FOR t:=1 TO 14 DO IF s=PresParamtypes[t] THEN goto l1;
          Error('Illegal PresParam type');
l1:
          FOR w:=1 TO 22 DO IF Params=Colors[w].name THEN goto l2;
          Error('Illegal Color index');
l2:
          d^.PresParams[PresOfs]:=t; {id_pp...Color...}
          d^.PresParams[PresOfs+1]:=0;
          d^.PresParams[PresOfs+2]:=0;
          d^.PresParams[PresOfs+3]:=0;
          inc(d^.PresParams[0],4);
          {inc(d^.PresParams[8],4);}
          inc(PresOfs,4);
          {???}
          d^.PresParams[PresOfs]:=4; {id_pp...Color...}
          d^.PresParams[PresOfs+1]:=0;
          d^.PresParams[PresOfs+2]:=0;
          d^.PresParams[PresOfs+3]:=0;
          inc(d^.PresParams[0],4);
          {inc(d^.PresParams[8],4);}
          inc(PresOfs,4);
          {???}

          l:=Colors[w].Style;
          w:=l AND 65535;
          t:=l SHR 16;
          d^.PresParams[PresOfs]:=w AND 255;
          d^.PresParams[PresOfs+1]:=w SHR 8;
          d^.PresParams[PresOfs+2]:=t AND 255;
          d^.PresParams[PresOfs+3]:=t SHR 8;
          inc(d^.PresParams[0],4);
          {inc(d^.PresParams[8],4);}
          inc(PresOfs,4);
     END;
     IF PresOfs>255 THEN Error('Too many PRESPARAMS');
     Read_Line;
     IF commanditem=__PRESPARAMS THEN goto ll;
     d^.PresParamBytes:=PresOfs;
END;


begin
end.