    IFND      DEVICES_PARNET_I
DEVICES_PARNET_I SET 1

**
**	$Filename: devices/parnet.i $
**	$Revision: 2.0 $
**	$Date: 93/08/15 $
**
**	external declarations for the parnet device
**

     IFND     PARNET_SRC
     UNIT   EQU APTR
     DEVICE EQU APTR
     ELSE
     UNIT   EQU Unit
     DEVICE EQU Device
     ENDC

 STRUCTURE IOParReq,0
	STRUCT	IO_MESSAGE,MN_SIZE
	APTR	IO_DEVICE		* device node pointer	
	APTR	IO_UNIT			* unit (protocol private)

	UWORD	IO_COMMAND		* device command
	UBYTE	IO_FLAGS		* IOF_QUICK
	BYTE	IO_ERROR		* error or warning num
	ULONG	IO_ACTUAL		* actual number of bytes transferred 
	ULONG	IO_LENGTH		* requested number bytes transferred 
	APTR	IO_DATA			* points to data area		  
	ULONG	IO_OFFSET		* offset for block structured devices
	UWORD	IO_PORT			
	UWORD	IO_ADDR			
	APTR	IO_DATA2	 	* more data
	ULONG	IO_LENGTH2		* must be 0 if you do not use these fields
        LABEL   IOParReq_Sizeof

         ENDM

 *
 *  OpenDevice(), protocols.
 *
 *  DEFAULT

PRO_MASK	EQU $001F
PRO_CONTROL	EQU $0000
PRO_DGRAM	EQU $0001
PRO_STREAM	EQU $0002

PRO_LAST	EQU PRO_STREAM

 *
 *  Extended Command Set
 *


PPD_SETADDR	EQU (CMD_NONSTD+0)      *  set my network address 
PPD_SETTO	EQU (CMD_NONSTD+1)      *  set network timeout
PPD_SHUTDOWN	EQU (CMD_NONSTD+2)      *  shutdown a stream conn.
PPD_CONNECT	EQU (CMD_NONSTD+3)      *  connect to a port
PPD_LISTEN	EQU (CMD_NONSTD+5)      *  listen for a connection

 *
 *  Extended Error codes    (placed in io_Actual for OpenDevice() call)
 *

PPERR_NOPORTRES     EQU -32 	*  can't get MR_PARALLELPORT misc res. 
PPERR_NOBITSRES     EQU -33 	*  can't get MR_PARALLELBITS misc res. 
PPERR_NOTASK	    EQU -34 	*  can't create sub task               
PPERR_NOINT	    EQU -35 	*  can't allocate CIAA-FLAG interrupt  
PPERR_BADPROTOCOL   EQU -36 	*  illegal protocol requested		
PPERR_BADFLAGS	    EQU -37 	*  illegal flags for protocol		
PPERR_ILLPORT	    EQU -38 	*  illegal port for protocol		
PPERR_ILLPORTLSN    EQU -39 	*  somebody already listening on that port!
PPERR_NOTIMPL	    EQU -40 	*  not implemented yet.		

PPERR_WARN_OVFLOW   EQU -41 	*  dgram, data overflow		
PPERR_PORT_IN_USE   EQU -42 	*  port is in use by another protocol	
PPERR_NO_PORTS	    EQU -43 	*  no more ports available !!		
PPERR_HOSTDOWN1     EQU -44 	*  remote machine does not respond	
PPERR_HOSTDOWN2     EQU -45 	*  remote machine does not respond	

       ENDC DEVICES_PARNET_I
