/*
** $Source: dh1:network/parnet/Sana2/Sources/device_protos.h,v $
** $State: Exp $
** $Revision: 37.2 $
** $Date: 93/12/17 22:09:05 $
** $Author: S.A.Pechler $
**
** Amiga SANA-II Example PARnet device driver.
**
** Based on the SANA-II Example SLIP device driver.
**
** Portions (C) Copyright 1992 Commodore-Amiga, Inc.
**
*/

/* The time.h header file in the AmiTCP distibution makes a nasty patch
 * in the timeval structure. It must be included before other structures
 * make use of timeval (Sana2DeviceStats does).
 */
#ifdef AmiTCP
# include <sys/time.h>
#endif

#include "spar_device.h"

#include <dos/dostags.h>
#include <dos/rdargs.h>
#include <intuition/intuition.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include <clib/utility_protos.h>
#include <clib/timer_protos.h>
#include <clib/alib_stdio_protos.h>
#include <clib/intuition_protos.h>

#include <pragmas/exec_pragmas.h>
#include <pragmas/dos_pragmas.h>
#include <pragmas/utility_pragmas.h>
#include <pragmas/timer_pragmas.h>
#include <pragmas/intuition_pragmas.h>

#include <string.h>


/* Correct prototype for the CheckIO.
 * (The one in clib/exec_protos.h has wrong return value type: BOOL (16 bits) 
 * instead of a pointer (32 bits)!)
 */
struct IORequest *CheckIO(struct IORequest *req);


/* Prototypes for functions defined in device_funcs.c
 */
LONG __asm DevOpen( register __a1 struct IOSana2Req * ios2,
                    register __a6 struct SPARDevice *SPARDevice,
                    register __d0 ULONG s2unit,
                    register __d1 ULONG s2flags);
BPTR __asm DevClose(register __a1 struct IOSana2Req * ios2,
                    register __a6 struct SPARDevice *SPARDevice);
BPTR __asm DevExpunge(register __a6 struct SPARDevice *SPARDevice);
struct SPARDevUnit *InitSPARUnit(ULONG s2unit);
VOID ExpungeUnit(struct SPARDevUnit *sdu);
BOOL ReadConfig(struct SPARDevUnit *sdu);
VOID __asm DevBeginIO(register __a1 struct IOSana2Req * ios2,
                      register __a6 struct SPARDevice *SPARDevice);
VOID PerformIO(struct IOSana2Req *ios2);
VOID GetSpecialStats(struct SPARDevUnit *sdu,
                     struct IOSana2Req *ios2);
VOID GetGlobalStats(struct SPARDevUnit *sdu,
                    struct IOSana2Req *ios2);
VOID GetTypeStats(struct SPARDevUnit *sdu,
                  struct IOSana2Req *ios2);
VOID TrackType(struct SPARDevUnit *sdu,
               struct IOSana2Req *ios2);
VOID UnTrackType(struct SPARDevUnit *sdu,
                 struct IOSana2Req *ios2);
VOID PacketReceived(struct SPARDevUnit *sdu,
                    ULONG length);
VOID PacketSent(struct SPARDevUnit *sdu,
                ULONG length);
VOID PacketOverrun(struct SPARDevUnit *sdu);
VOID ReceivedGarbage(struct SPARDevUnit *sdu);
VOID PacketDropped(struct SPARDevUnit *sdu);
VOID TermIO(struct IOSana2Req *ios2);
LONG __asm DevAbortIO(register __a1 struct IOSana2Req * ios2,
                      register __a6 struct SPARDevice *SPARDevice);
LONG AbortReq(struct MinList *minlist,
               struct IOSana2Req *ios2);
VOID ConfigInterface(struct SPARDevUnit *sdu,
                     struct IOSana2Req *ios2);
VOID GetStationAddress(struct SPARDevUnit *sdu,
                       struct IOSana2Req *ios2);
VOID BroadcastPacket(struct SPARDevUnit *sdu,
                     struct IOSana2Req *ios2);
VOID DeviceQuery(struct SPARDevUnit *sdu,
                 struct IOSana2Req *ios2);
VOID WritePacket(struct SPARDevUnit *sdu,
                 struct IOSana2Req *ios2);
VOID SendPacket(struct SPARDevUnit *sdu,
                struct IOSana2Req *ios2);
VOID ReadPacket(struct SPARDevUnit *sdu,
                struct IOSana2Req *ios2);
VOID ReadOrphan(struct SPARDevUnit *sdu,
                struct IOSana2Req *ios2);
VOID ReceivedOrphan(struct SPARDevUnit *sdu);
BOOL InitPARnet(struct SPARDevUnit *sdu);
VOID DeinitPARnet(struct SPARDevUnit *sdu);
VOID OnEvent(struct SPARDevUnit *sdu,
             struct IOSana2Req *ios2);
BOOL OpenPARnet(struct SPARDevUnit *sdu);
VOID MarkTimeOnline(struct SPARDevUnit *sdu);
VOID ClosePARnet(struct SPARDevUnit *sdu);
VOID Online(struct SPARDevUnit *sdu,
            struct IOSana2Req *ios2);
VOID Offline(struct SPARDevUnit *sdu,
             struct IOSana2Req *ios2);
VOID DoEvent(struct SPARDevUnit *sdu,
             ULONG event);
VOID DoOffline(struct SPARDevUnit *sdu);
VOID ServiceTxPort(struct SPARDevUnit *sdu,
             struct IOParReq *ioPar);
VOID DoPARnet(struct SPARDevUnit *sdu,
              struct IOParReq *ioPar);
VOID GotPacket(struct SPARDevUnit *sdu,
               ULONG length);
VOID QueueParRequest(struct SPARDevUnit *sdu);
VOID __asm DevProcCEntry(VOID);
VOID NewList(struct List *list);

/*
** External variables and functions
**
*/

/* the __far keyword is only needed for data structures which are
** in a different segment. Otherwise the linker will complain.
*/
/* __far */
extern struct SPARDevice *ExtDeviceBase;

#ifdef Rhialto 
extern ULONG IPToNum(STRPTR ipstr);
extern VOID kprintf(STRPTR fmt, ...);
#endif

/* Debugging facilities.
 */
#ifdef DEBUG
#  ifdef __STDC__
    void LogMessage(char *fmt, ...);
#  else
    void LogMessage(va_alist)
    va_dcl;
#  endif
   void initsyslog(void);
   void uninitsyslog(void);
#  define debug(x) LogMessage x;
#else
  /* No debugging */
  void initintuition(void);
  void uninitintuition(void);
# define debug(x)
# define initsyslog(x) initintuition (x);
# define uninitsyslog(x) uninitintuition (x);
#endif /* DEBUG */

