*:*****************************************************************************
*:
*: Procedure file: C:\BIN\YNALERT.PRG
*:         System: SAFE packing procedures for FoxPro Apps
*:         Author: Stephen A. Sawyer - CIS 75730,455
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 06/18/93 at 12:45:12
*:
*:  Procs & Fncts: YNALERT
*:
*:      Documented 13:07:34                                FoxDoc version 3.00a
*:*****************************************************************************
* Alert message allowing a yes-or-no response from the
* user - The "yes" and "no" are the default push-button
* text values, with "yes" as the default choice, and "no"
* selected with <Esc>, but can be substituted by passing
* a second parameter in the form of "button1/button2" via
* the pr_strng parameter.  The first item is alway the
* default, the second always selected with <Esc>
* You can use this to make "no" the default:
* IF ynalert("Proceed with this operation","No/Yes")
***********************************************************************
*!*****************************************************************************
*!
*!      Procedure: YNALERT
*!
*!      Called by: CDXAUDIT.PRG                      
*!
*!          Calls: CNTR               (procedure in CNTR.PRG)
*!
*!*****************************************************************************
PROCEDURE ynalert
PARAMETERS msg,pr_strng
IF PARAMETERS() > 1
	pb_width = LEN(pr_strng) + 5
	winwidth1 = MAX((LEN(pr_strng) + 8),14)
	winwidth2 = MAX((LEN(msg) + 4),14)
	winwidth = MAX(winwidth1,winwidth2)
	pr_strng = "*TH \!\<" + LEFT(pr_strng,RAT("/",pr_strng)-1) + ";" + ;
		"\?\<" + RIGHT(pr_strng,LEN(pr_strng)-RAT("/",pr_strng))
ELSE
	winwidth=MAX((LEN(msg) + 4),14)
	pr_strng = "*TH \!\<Yes;\?\<No"
	pb_width = 11
ENDIF ( PARAMETERS() > 1 )
lcol=40-INT(winwidth/2)
rcol = lcol + winwidth
msgpos=cntr(msg,winwidth)
DEFINE WINDOW reply FROM 10,lcol TO 16,rcol DOUBLE COLOR SCHEME 7
ACTIVATE WINDOW reply IN SCREEN
@ 1,msgpos SAY msg
ynans = 1
@ 3,(winwidth-pb_width)/2 GET ynans FUNCTION EVALUATE("pr_strng")  DEFAULT ynans
READ
IF ynans = 1
	alertreply = .T.
ELSE
	alertreply = .F.
ENDIF ( ynans = 1 )
DEACTIVATE WINDOW reply
RELEASE WINDOW reply
RETURN alertreply
************************************************
*: EOF: YNALERT.PRG
