*:*****************************************************************************
*:
*: Procedure file: C:\BIN\SAFEPACK.PRG
*:         System: SAFE packing procedures for FoxPro Apps
*:         Author: Stephen A. Sawyer - CIS 75730,455
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 06/21/93 at 12:00:19
*:
*:          Calls: GENTEMP.PRG
*:               : JUSTPATH.PRG
*:               : NOPATH.PRG
*:
*:           Uses: CDXAUDIT.DBF       
*:               : DBFLIST.DBF        
*:
*:      CDX files: DBFLIST.CDX
*:
*:      Documented 13:07:32                                FoxDoc version 3.00a
*:*****************************************************************************
PARAMETERS pcDbf
*****************************************************************
* Parameter used only to "safepack" a single .DBF
*****************************************************************
lnBegProc=SECONDS()
lcOldSafe=SET("SAFETY")
SET SAFETY OFF
lcOldTalk=SET("TALK")
SET TALK OFF
IF ! FILE("CDXAUDIT.PRG")
	WAIT "No CDX Audit file found" WINDOW
	RETURN
ENDIF ( ! FILE("CDXAUDIT.PRG") )
*****************************************************************
* The DBFLIST database contains information on whether the database should
* be packed to remove deleted records, and whether a CDX file exists for the
* database - set a relation between CDXAUDIT and DBFLIST
*****************************************************************
USE cdxaudit ORDER TAG name_tag
SELECT 0
USE dbflist ORDER TAG dbfname
SELECT cdxaudit
SET RELATION TO dbfname INTO dbflist
IF PARAMETERS() > 0
	SET FILTER TO dbfname=pcDbf
ENDIF ( PARAMETERS() > 0 )
GOTO TOP
*****************************************************************
* DO IT!!
* Pack the databases that it is permissible to pack, and re-index all
* databases by re-constructing the .CDX files from scratch
*****************************************************************
DO WHILE ! EOF("cdxaudit")
	IF cdxaudit.dbfname="CDXAUDIT.DBF" OR ;
			cdxaudit.dbfname="DBFLIST.DBF"
		SKIP
		LOOP
	ENDIF ( cdxaudit.dbfname="CDXAUDIT.DBF" OR ; )
	lcDbf=dbfname
	IF dbflist.pack
		*********************************************************
		* Packing procedure - copies to a new database for ! DELETED()
		*********************************************************
		WAIT "Packing " + TRIM(dbfname) WINDOW NOWAIT
		SELECT 0
		USE (lcDbf) EXCLUSIVE ALIAS OldFile
		COUNT FOR ! DELETED() TO lnRecChk
		SET ORDER TO 1
		lcTempFile=GENTEMP(lcDBF)
		COPY TO (lcTempFile) FOR ! DELETED()
		SELECT 0
		USE (lcTempFile) ALIAS NewFile
		IF RECCOUNT("NewFile") = lnRecChk
			USE
			SELECT OldFile
			lcOldCdx=CDX(1)
			lcOldFile=DBF()
			USE
			ERASE (lcOldFile)
			RENAME (lcTempFile) TO (lcOldFile)
		ELSE
			WAIT "Unable to pack " + TRIM(cdxaudit.dbfname) WINDOW
			SELECT NewFile
			USE
			ERASE (lcTempFile)
			SELECT OldFile
			USE
			SELECT cdxaudit
		ENDIF ( RECCOUNT("NewFile") = lnRecChk )
	ENDIF ( dbflist.pack )
	*************************************************************
	* Indexing procedure - duplicates structural compound index structure saved
	* in the CDXAUDIT database
	*************************************************************
	WAIT "Re-indexing " + lcDbf WINDOW NOWAIT
	SELECT 0
	USE (lcDbf) EXCLUSIVE ALIAS OldFile
	lcOldCdx=CDX(1)
	IF EMPTY(lcOldCdx)
		lcOldCdx=JUSTPATH(lcOldFile) + "\" + NOPATH(lcOldFile) + ".CDX"
		ERASE (lcOldCdx)
	ELSE
		USE
		ERASE (lcOldCdx)
		USE (lcDbf) EXCLUSIVE ALIAS OldFile
	ENDIF ( EMPTY(lcOldCdx) )
	SELECT cdxaudit
	SCAN WHILE dbfname=lcDbf
		lcIdxComm= ;
			"INDEX ON " + TRIM(cdxaudit.expr) + " TAG " + TRIM(cdxaudit.tag) + ;
			IIF(! EMPTY(cdxaudit.for)," FOR " + TRIM(cdxaudit.for),"") + ;
			IIF(cdxaudit.unique, " UNIQUE","") + ;
			IIF(cdxaudit.descend," DESCENDING","")
		SELECT OldFile
		&lcIdxComm
		SELECT cdxaudit
	ENDSCAN
	SELECT OldFile
	USE
	SELECT cdxaudit
ENDDO ( ! EOF("cdxaudit") )
CLOSE DATA
SET TALK &lcOldTalk
lnEndProc=SECONDS()
lnElapsed=lnEndProc-lnBegProc
lcMin=LTRIM(STR(INT(lnElapsed/60)))
lcSec=LTRIM(STR(lnElapsed-VAL(lcMin)*60,2))
WAIT "Packing completed - Elapsed=" + lcMin + ":" + lcSec WINDOW
SET SAFETY &lcOldSafe
RETURN
*: EOF: SAFEPACK.PRG
