*:*****************************************************************************
*:
*:        Program: C:\BIN\CDXAUDIT.PRG
*:         System: SAFE packing procedures for FoxPro Apps
*:         Author: Stephen A. Sawyer - CIS 75730,455
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 06/21/93 at 11:45:07
*:
*:          Calls: JUSTPATH.PRG
*:               : NOEXT.PRG
*:               : GENTEMP.PRG
*:               : YNALERT            (procedure in YNALERT.PRG)
*:               : MSGBOX()           (function  in ?)
*:
*:           Uses: CDXAUDIT.DBF       
*:               : LCAUDCDX.DBF       
*:               : DBFLIST.DBF        
*:
*:        Indexes: NAME_TAG               (tag)
*:               : DBFNAME                (tag)
*:
*:      CDX files: DBFLIST.CDX
*:
*:      Documented 13:07:30                                FoxDoc version 3.00a
*:*****************************************************************************
PARAMETERS pcDbfDir
IF PARAMETERS() = 0
	?? CHR(7)
	WAIT "Must supply directory in which DBF's are stored" WINDOW
	RETURN
ENDIF ( PARAMETERS() = 0 )
*****************************************************************
* Load FOXTOOLS.FLL for msgbox procedure if running Windows
*****************************************************************
IF _WINDOWS AND ! "FOXTOOLS" $ SET("LIBRARY")
	SET LIBRARY TO SYS(2004) + "foxtools.fll" ADDITIVE
ENDIF ( _WINDOWS AND ! "FOXTOOLS" $ SET("LIBRARY") )
lcOldTalk=SET("TALK")
SET TALK OFF
IF RIGHT(pcDbfDir,1) # "\"
	lcDbfDir=pcDbfDir + "\"
ELSE
	lcDbfDir=pcDbfDir
ENDIF ( RIGHT(pcDbfDir,1) # "\" )
lcDbfMask=lcDbfDir + "*.DBF"
*****************************************************************
* Construct a list of all dbf files located in the specified directory, stored to the
* array laDbfLst
*****************************************************************
=ADIR(laDbfLst,lcDbfMask)
lnDbfs=ALEN(laDbfLst,1)
IF lnDbfs = 0
	?? CHR(7)
	WAIT "No databases found during CDX file auditing" WINDOW
	RETURN
ENDIF ( lnDbfs = 0 )
*****************************************************************
* Set up an array to hold the index tags and their specifications
*****************************************************************
DIMENSION laCdx[1,7]
lnTagCount=0
FOR i=1 TO lnDbfs
	SELECT 0
	USE (laDbfLst[i,1])
	lnTag=1
	*************************************************************
	* Examine each compound structural index tag
	*************************************************************
	DO WHILE ! EMPTY(TAG(lnTag))
		*********************************************************
		* Count records before setting the index the the current tag - this
		* is used to check to see if the current tag is indexed UNIQUE
		*********************************************************
		IF EMPTY(SYS(2021,lnTag))
			lnRecords=RECCOUNT()
		ELSE
			lcForExp=SYS(2021,lnTag)
			COUNT FOR &lcForExp TO lnRecords
		ENDIF ( EMPTY(SYS(2021,lnTag)) )
		**********************************************************
		* Set order to the current tag
		**********************************************************
		SET ORDER TO lnTag
		**********************************************************
		* Count the indexed records - if less than lnRecords determined above,
		* tag must be indexed  UNIQUE - SEE DOCUMENTATION!!
		**********************************************************
		COUNT TO lnIdxd
		GOTO TOP
		***********************************************************
		* Check to see if the records are in ascending or descending order
		***********************************************************
		luThis=EVALUATE(KEY(lnTag))
		SCAN WHILE luThis=EVALUATE(KEY(lnTag))
		ENDSCAN
		luNext=EVALUATE(KEY(lnTag))
		lnTagCount=lnTagCount+1
		IF ALEN(laCdx,1) < lnTagCount
			DIMENSION laCdx[lnTagCount,7]
		ENDIF ( ALEN(laCdx,1) < lnTagCount )
		***********************************************************
		* Store all the index tag specs to the laCdx array
		***********************************************************
		laCdx[lnTagCount,1]=laDbfLst[i,1]	&& DBF filename
		laCdx[lnTagCount,2]=KEY(lnTag)	&& Index Expression
		laCdx[lnTagCount,3]=TAG(lnTag)	&& Tag Name
		laCdx[lnTagCount,4]=IIF(!EMPTY(SYS(2021,lnTag)),SYS(2021,lntag),"")	&& For clause
		laCdx[lnTagCount,5]=IIF(lnRecords > lnIdxd,.T.,.F.)	&& UNIQUE?
		laCdx[lnTagCount,6]=IIF(luThis > luNext, .T.,.F.)		&& DESCENDing?
		laCdx[lnTagCount,7]=lnTag						&& Tag number
		lnTag=lnTag+1
	ENDDO ( ! EMPTY(TAG(lnTag)) )
	USE
ENDFOR ( i )
CLOSE DATA
*****************************************************************
* Determine the maximum length of index expressions and FOR clauses
*****************************************************************
lnMaxExpr=0
lnMaxFor=0
FOR i=1 TO ALEN(laCdx,1)
	lnMaxExpr=MAX(lnMaxExpr,LEN(laCdx[i,2]))
	lnMaxFor=MAX(lnMaxFor,LEN(laCdx[i,4]))
ENDFOR ( i )
*****************************************************************
* Save the index information to a cursor
*****************************************************************
CREATE CURSOR cdxstru ;
	(dbfname C(12), expr C(lnMaxExpr), TAG C(10), FOR C(lnMaxFor), UNIQUE L, DESCEND L, tagno N(2))
APPEND FROM ARRAY laCdx
INDEX ON dbfname+PADL(LTRIM(STR(TAGNO)),2) TAG name_tag
*****************************************************************
* If CDXAUDIT.DBF file exists, check to see if it matches the new information
* in the CDXSTRU cursor
*****************************************************************
IF FILE("CDXAUDIT.DBF")
	SELECT 0
	USE cdxaudit ORDER TAG name_tag
	lcRelExp= KEY(1)
	SET RELATION TO &lcRelExp INTO cdxstru
	llAudChgd=.F.
	SCAN
		IF EVALUATE(KEY(1,"CDXSTRU")) = EVALUATE(KEY(1,"CDXAUDIT")) ;
				AND TRIM(cdxstru.expr) == TRIM(cdxaudit.expr) ;
				AND TRIM(cdxstru.for) == TRIM(cdxaudit.for) ;
				AND cdxstru.unique=cdxaudit.unique ;
				AND cdxstru.descend=cdxaudit.descend
			llAudChgd=.T.
			EXIT
		ENDIF ( EVALUATE(KEY(1,"CDXSTRU")) = EVALUATE(KEY(1,"CDXAUDIT")) ; )
	ENDSCAN
	IF llAudChgd
		*********************************************************
		* If something has changed (new or changed tags, new databases etc.)
		* then rename the existing CDXAUDIT.DBF to CDXAUDIT.BAK
		* and save the current CDXSTRU cursor as CDXAUDIT.DBF
		*****************************************************************
		WAIT "Creating NEW CDXAUDIT File..." WINDOW NOWAIT
		lcAudFile=FULLPATH("CDXAUDIT.DBF")
		lcAudBak=JUSTPATH(lcAudFile) + "\" + noext(lcaudfile) + ".BAK"
		lcAudCdx=JUSTPATH(lcAudFile) + "\" + noext(lcaudfile) + ".CDX"
		SELECT cdxaudit
		USE
		IF FILE(lcAudBak)
			ERASE (lcAudBak)
		ENDIF ( FILE(lcAudBak) )
		RENAME &lcAudFile TO &lcAudBak
		ERASE lcAudCdx
		SELECT cdxstru
		COPY TO (lcAudFile)
		SELECT 0
		USE (lcAudFile)
		INDEX ON dbfname+PADL(LTRIM(STR(TAGNO)),2) TAG name_tag
		INDEX ON dbfname TAG dbfname UNIQUE
		WAIT CLEAR
	ENDIF ( llAudChgd )
ELSE
	WAIT "Creating CDXAUDIT File..." WINDOW NOWAIT
	lcAudFile=lcDbfDir + "CDXAUDIT"
	COPY TO (lcAudFile)
	USE (lcAudFile)
	INDEX ON dbfname+PADL(LTRIM(STR(TAGNO)),2) TAG name_tag
	INDEX ON dbfname TAG dbfname UNIQUE
	WAIT CLEAR
ENDIF ( FILE("CDXAUDIT.DBF") )
SELECT cdxstru
USE
*****************************************************************
* Check to see if there are any "new" databases in CDXAUDIT.DBF that should
* be added to DBFLIST.DBF
*****************************************************************
SELECT cdxaudit
SELECT 0
USE dbflist
SET ORDER TO TAG dbfname
SELECT cdxaudit
SET RELATION TO dbfname INTO dbflist
SCAN
	IF ! dbflist.cdx
		SELECT dbflist
		REPLACE dbflist.cdx WITH .T.
		SELECT cdxaudit
	ENDIF ( ! dbflist.cdx )
ENDSCAN
SELECT dbflist
SET FILTER TO dbflist.cdx
SELECT cdxaudit
COUNT FOR EOF("DBFLIST") TO lnAddDbfs
IF lnAddDbfs > 0
	lcAddFile=GENTEMP()
	COPY FIELDS dbfname TO (lcAddFile) FOR EOF("DBFLIST")
	SET RELATION OFF INTO dbflist
	USE (lcAddFile) ALIAS AddFiles
	SCAN
		IF IIF(_DOS,ynalert("Add " + TRIM(AddFiles.dbfname) + " to Database List?"), IIF(msgbox("Add " + TRIM(AddFiles.dbfname) + " to Database List?","New Indexed Database",36)=6,.T.,.F.))
			SCATTER MEMVAR
			SELECT dbflist
			APPEND BLANK
			GATHER MEMVAR
			REPLACE dbflist.cdx WITH .T.
			IF IIF(_DOS,ynalert("Allow packing of " + TRIM(AddFiles.dbfname)), IIF(msgbox("Allow packing of " + TRIM(AddFiles.dbfname),"New Indexed Database",36)=6,.T.,.F.))
				REPLACE dbflist.pack WITH .T.
			ENDIF ( IIF(_DOS,ynalert("Allow packing of " + TRIM(AddFiles.dbfname)), IIF(msgbox("Allow packing of " + TRIM(AddFiles.dbfname),"New Indexed Database",36)=6,.T.,.F.)) )
			SELECT AddFiles
		ENDIF ( IIF(_DOS,ynalert("Add " + TRIM(AddFiles.dbfname) + " to Database List?"), IIF(msgbox("Add " + TRIM(AddFiles.dbfname) + " to Database List?","New Indexed Database",36)=6,.T.,.F.)) )
	ENDSCAN
	CLOSE DATA
	ERASE (lcAddFile)
ENDIF ( lnAddDbfs > 0 )
USE dbflist
SELECT 0
USE cdxaudit ORDER TAG dbfname
SELECT dbflist
SET RELATION TO dbfname INTO cdxaudit
REPLACE CDX WITH .F. FOR EOF("cdxaudit")
CLOSE DATA
SET TALK &lcOldTalk
*: EOF: CDXAUDIT.PRG
