/* $Id$
 *
 * Send mail reply packet using SMTP directly
 */
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include "socket.h"
#include "souper.h"

extern char *hostName;
extern char *mailGateway;

/* Close SMTP connection and socket */

void
smtpClose (int socket)
{
    SockPuts(socket, "QUIT");
    close(socket);
}

/* Get a response from the SMTP server and test it
*/
static int
getSmtpReply (int socket, char *response)
{
    char buf[BUFSIZ];

    do {
	SockGets(socket, buf, BUFSIZ);
    } while (buf[3] == '-');		/* wait until not a continuation */

    if (strncmp(buf, response, 3) != 0) {
	fprintf(stderr, "Expecting SMTP %s reply, got %s\n", response, buf);
    }
    return (buf[0] == *response);	/* only first digit really matters */
}

/* Open socket and intialize connection to SMTP server. */

#ifdef DEBUG
int
smtpConnect (void)
{
    return 1;
}
#else
int
smtpConnect (void)
{
    struct servent *sp;
    int	socket;

    if ((sp = getservbyname("smtp", "tcp")) == NULL) {
	fprintf(stderr, "smtp/tcp: Unknown service.\n");
	return -1;
    }

    if ((socket = Socket(mailGateway, ntohs(sp->s_port))) < 0) {
	fprintf(stderr,
	    "Cannot connect to %s mail server, try again later.\n",
	    mailGateway);
	return -1;
    }

    if (!getSmtpReply(socket, "220")) {
	printf("Disconnecting from %s\n", mailGateway);
	smtpClose(socket);
	return -1;
    }

    SockPrintf(socket, "HELO %s\r\n", hostName);
    if (!getSmtpReply(socket, "250")) {
	printf("Disconnecting from %s\n", mailGateway);
	smtpClose(socket);
	return -1;
    }
    return socket;
}
#endif
    
/* Send RCPTs to SMTP for all the addresses on one line.
*/
static void
sendSmtpRcpt (int socket, char *buf)
{
    char *cp;
    
    for (cp = buf + strlen(buf) - 1; isspace(*cp); cp--)
	;
    if (*cp != ',') *(++cp) = ',';
    while ((cp = strchr(buf, ',')) != NULL) {
	*cp = '\0';
	while (isspace(*buf)) buf++;
	SockPrintf(socket, "RCPT TO:<%s>\r\n", buf);
	getSmtpReply(socket, "250");
	buf = cp + 1;
    }
}

/* Send RCPT commands to SMTP from all To:, Cc: or Bcc: lines.
*/
static void
sendSmtpAddrs (int socket, FILE *fd, const char *header)
{
    char buf[BUFSIZ];		/* buffer for reading from file */
    char *bp;
    int	len;
    long offset;

    offset = ftell(fd);
    len = strlen(header);

    /* Look through header of message for required header type. */
    for (;;) {
	if ((fgets(buf, sizeof(buf), fd) == NULL) || (buf[0] == '\n')) {
	    fseek(fd, offset, SEEK_SET);
	    return;	/* end of header, not found */
	}
	if (strnicmp(buf, header, len) == 0 && buf[len] == ':'
	 && (buf[len+1] == ' ' || buf[len+1] == '\t'))
	{
	    break;	/* found header */
	}
    }
    bp = buf + len + 1;

    /* Now process line plus continuations sending a RCPT to the SMTP
     * server for each address found.
     */
    do {
	while (isspace(*bp)) bp++;
	printf("%s: Mailing to %s", progname, bp);
	sendSmtpRcpt(socket, bp);
	bp = buf;
    } while (fgets(buf, sizeof(buf), fd) && (buf[0] != '\n')
	     && ((buf[0] == ' ') || (buf[0] == '\t')));
    fseek(fd, offset, SEEK_SET);
}

/* Send message to SMTP server. */

void
smtpMail (int socket, FILE *fd, size_t bytes)
{
    char buf[BUFSIZ];
    char *from, *s;
    long offset;
    size_t count;

    /* Look for From:  and send MAIL command to SMTP server. */
    from = getHeader(fd, "From");
    printf("%s: Mailing from %s\n", progname, from);
    SockPrintf(socket, "MAIL FROM:<%s>\r\n", from);
    free(from);
    if (!getSmtpReply(socket, "250")) {
	return;
    }

    /* Send the destination addresses to SMTP. */
    sendSmtpAddrs(socket, fd, "To");
    sendSmtpAddrs(socket, fd, "Cc");
    sendSmtpAddrs(socket, fd, "Bcc");

    /* Send the DATA command and the mail message line by line. */
    SockPuts(socket, "DATA");
    if (!getSmtpReply(socket, "354")) {
	return;
    }

    offset = ftell(fd);
    count = bytes;
    while (fgets(buf, sizeof(buf), fd) && count > 0) {
	count -= strlen(buf);
	if ((s = strchr(buf, '\n')) != NULL)
	    *s = '\0';
	if (buf[0] == '.') {
	    SockWrite(socket, buf, 1);	/* write an extra . */
	}
	SockPrintf(socket, "%s\r\n", buf);
    }
    fseek(fd, offset+bytes, SEEK_SET);

    SockPuts(socket, ".");
    getSmtpReply(socket, "250");
}
