{
  Sound System Source Release 4 (pd)1995 by the Frontman of Crew242
  Turbo Pascal Interface (pd)1995/96 by Daniel Ludwig

  MMI TSR Version

  This source code is FREEWARE!
}

Unit TPSS4MMI;

Interface

Const
  { use with UsedTimer (e.g. usedtimer:=RTC;) }
  RTC   = 0;                            { real time clock;  UsedTimer }
  TIMER = 1;                            { timer int 08h                }

  { use with LoadSample }
  AMIGA =   0;                          { AMIGA sample format (signed) }
  PC    = $80;                          { PC sample format (unsigned)  }

  { use with MMI_LoadPlayer }
  SB          = 1;                      { SB/SBPro/SB16 8Bit           }
  SB16        = 2;                      { SB16 16Bit                   }
  PAS16       = 3;                      { PAS+/16                      }
  GUS         = 4;                      { Gravis Ultrasound            }

  { used timing variant (RTC or TIMER}
  UsedTimer :Byte = RTC;                { default = RTC                }

Type
  TConfigParam = Record
    Base       : word;    { Baseport of sound card           }
    dma        : byte;    { DMA Channel (8&16 Bit suported)  }
    irq        : byte;    { IRQ Number                       }
    samplerate : word;    { Samplerate (11-22/44 kHz)        }
    internal   : byte;    { used by SBMOD: SB,Pro or SB16?   }
    inttype    : byte;    { 0=DOS(RTC) 1=Windows(Timer)      }
    startpos   : byte;    { 0-127                            }
    looppos    : byte;    { 0-127,>127=no loop               }
    songmode   : byte;    { 0=Music&SFX 1=Music 2=SFX 3=MUTE }
    mastervol  : byte;    { Master Volume                    }
    musicvol   : byte;    { Music Volume                     }
    sfxvol     : byte;    { Sound FX Volume                  }
  End;
  PConfigParam = ^TConfigParam;

  {---------------------------------------------------MMI Interface Functions}

  { Loads MMI.EXE; same like "MMI.EXE -N" }
  Function MMI_Install(path:String):Boolean;

  { Removes MMI.EXE; same like "MMI.EXE -U" }
  Procedure MMI_UnInstall;

  { Autodetects installed sound card & its parameters (IRQ,DMA,BASE PORT) }
  Procedure MMI_AutoDetect(Var card:Byte; Var params:PConfigParam);

  { Loads MOD player for installed card}
  Procedure MMI_LoadPlayer(card:Byte);

  { Removes MOD player }
  Procedure MMI_UnloadPlayer;

  {------------------------------------------------------MOD Player Functions}
  {---------------------------------------refer to TPSS4.PAS for explaination}
  Function  Config_Init(ConfigParam:PConfigParam; Var sfxroutinePtr:pointer):Boolean;
                                                     {^^^^^^^^^^^^^use it for}
                                                     {procedure FLC_Init     }
  Function  Load_MOD(MODName:String):boolean;
  Function  Play_Music:boolean;
  Procedure Stop_Music;
  Procedure End_Music;
  Function  Load_Sample(Var handle:word; SampleFile:string; Typ:byte):boolean;
  Procedure Play_Sample(handle,freq:word; panning:byte);
  Procedure End_Sample;
  Procedure Set_SampleRate(freq:word);
  Procedure Get_Volume(Var master,music,sfx:byte);
  Procedure Set_Volume(master,music,sfx:byte);
  Procedure Set_SongLoop(pattern:byte);
  Function  Get_SongPosition:byte;
  Procedure Set_SongPosition(pattern:byte);
  Function  Get_SongMode:byte;
  Procedure Set_SongMode(Mode:byte);

  {-------------------------------------------------------CD Player Functions}
  {---------------------------------------refer to TPSS4.PAS for explaination}
  Function  CD_Init:boolean;
  Procedure CD_TOC;
  Procedure CD_Play(tracknr:byte; repeating,chaining:boolean);
  Procedure CD_Stop;
  Procedure CD_Pause;
  Procedure CD_Resume;
  Procedure CD_Seek(time:shortint);
  Function  CD_Playing:boolean;

  {--------------------------------------------------FLI/FLC Player Functions}
  {---refer to TPSS4.PAS for expl.; fxroutinePtr is given back by Config_Init}
  Procedure FLC_Init(fxlistPtr,fxroutinePtr:pointer; videochange:boolean);
  Procedure FLC_End(videoback:boolean);
  Procedure FLC_Play(fname:string; speed,loops:byte; chaining,usefx:boolean);

Implementation
Uses DOS;

Var oldinttable:Array[0..1023]Of Byte;

  Procedure String2Asciiz(Var s:String); Assembler;
  Asm
    push  ds
    lds   si, s
    les   di, s
    lodsb
    mov   cl, al
    xor   ch, ch
    cld
    rep   movsb
    xor   al, al
    stosb
    pop   ds
  End; {String2Asciiz}

  Function MMI_Install(path:String):Boolean;
  Begin
    Move(mem[0:0],oldinttable,1024);
    SwapVectors;
    Exec(path+'MMI.EXE','-N');
    SwapVectors;
    MMI_Install:=(doserror=0);
  End; {MMI_Install}

  Procedure MMI_UnInstall;
  Var regs:Registers;
  Begin
    regs.bp:=$01;
    Intr($66,regs);
    Move(oldinttable,mem[0:0],1024);
  End; {MMI_UnInstall}

  Procedure MMI_AutoDetect(Var card:Byte; Var params:PConfigParam);
  Var regs:Registers;
  Begin
    regs.bp:=$02;
    regs.es:=Seg(params^);
    regs.bx:=Ofs(params^);
    Intr($66,regs);
    card:=regs.ax;
  End; {MMI_AutoDetect}

  Procedure MMI_LoadPlayer(card:Byte);
  Var regs:Registers;
  Begin
    regs.bp:=$03;
    regs.ax:=card;
    Intr($66,regs);
  End; {MMI_LoadPlayer}

  Procedure MMI_UnloadPlayer;
  Var regs:Registers;
  Begin
    regs.bp:=$04;
    Intr($66,regs);
  End; {MMI_UnloadPlayer}

  Function Config_Init(ConfigParam:PConfigParam; Var sfxroutinePtr:pointer):Boolean;
  Var regs:Registers;
  Begin
    regs.bp:=$41;
    regs.es:=Seg(configparam^);
    regs.bx:=Ofs(configparam^);
    regs.cx:=$C242;
    Intr($66,regs);
    sfxroutinePtr:=Ptr(regs.ax,$11C);
    Config_Init:=(regs.flags AND 1=0);
  End; {Config_Init}

  Function Load_MOD(MODName:String):boolean;
  Var regs:Registers;
  Begin
    regs.bp:=$42;
    String2Asciiz(modname);
    regs.es:=Seg(modname);
    regs.dx:=Ofs(modname);
    Intr($66,regs);
    Load_MOD:=(regs.flags AND 1=0);
  End; {Load_Mod}

  Function  Play_Music:boolean;
  Var regs:Registers;
  Begin
    regs.bp:=$43;
    Intr($66,regs);
    Play_Music:=(regs.flags AND 1=0);
  End; {Play_Music}

  Procedure Stop_Music;
  Var regs:Registers;
  Begin
    regs.bp:=$44;
    Intr($66,regs);
  End; {Stop_Music}

  Procedure End_Music;
  Var regs:Registers;
  Begin
    regs.bp:=$45;
    Intr($66,regs);
  End; {End_Music}

  Function Load_Sample(Var handle:word; SampleFile:string; Typ:byte):boolean;
  Var regs:Registers;
  Begin
    regs.bp:=$46;
    String2Asciiz(samplefile);
    regs.es:=Seg(samplefile);
    regs.dx:=Ofs(samplefile);
    If typ<>AMIGA Then typ:=PC;
    regs.cl:=typ;
    Intr($66,regs);
    handle:=regs.ax;
    Load_Sample:=(regs.flags AND 1=0);
  End; {Load Sample}

  Procedure Play_Sample(handle,freq:word; panning:byte);
  Var regs:Registers;
  Begin
    regs.bp:=$47;
    regs.bx:=handle;
    regs.cx:=freq;
    regs.al:=panning;
    Intr($66,regs);
  End; {Play_Sample}

  Procedure End_Sample;
  Var regs:Registers;
  Begin
    regs.bp:=$48;
    Intr($66,regs);
  End; {End_Sample}

  Procedure Set_SampleRate(freq:word);
  Var regs:Registers;
  Begin
    regs.bp:=$49;
    regs.ax:=freq;
    Intr($66,regs);
  End; {Set_Samplerate}

  Procedure Get_Volume(Var master,music,sfx:byte);
  Var regs:Registers;
  Begin
    regs.bp:=$4A;
    Intr($66,regs);
    master:=regs.al;
    music:=regs.bl;
    sfx:=regs.bh;
  End; {Get_Volume}

  Procedure Set_Volume(master,music,sfx:byte);
  Var regs:Registers;
  Begin
    regs.bp:=$4B;
    regs.al:=master;
    regs.bl:=music;
    regs.bh:=sfx;
    Intr($66,regs);
  End; {Set_Volume}

  Procedure Set_SongLoop(pattern:byte);
  Var regs:Registers;
  Begin
    regs.bp:=$4C;
    regs.al:=pattern;
    Intr($66,regs);
  End; {Set_Songloop}

  Function Get_SongPosition:byte;
  Var regs:Registers;
  Begin
    regs.bp:=$4D;
    Intr($66,regs);
    Get_SongPosition:=regs.al;
  End; {Get_SongPosition}

  Procedure Set_SongPosition(pattern:byte);
  Var regs:Registers;
  Begin
    regs.bp:=$4E;
    regs.al:=pattern;
    Intr($66,regs);
  End; {Set_SongPosition}

  Function Get_SongMode:byte;
  Var regs:Registers;
  Begin
    regs.bp:=$4F;
    Intr($66,regs);
    Get_SongMode:=regs.al;
  End; {Get_SongMode}

  Procedure Set_SongMode(Mode:byte);
  Var regs:Registers;
  Begin
    regs.bp:=$50;
    regs.al:=mode;
    Intr($66,regs);
  End; {Set_SongMode}

  Function CD_Init:boolean;
  Var regs:Registers;
  Begin
    regs.bp:=$81;
    Intr($66,regs);
    CD_Init:=(regs.flags AND 1=0);
  End; {CD_Init}

  Procedure CD_TOC;
  Var regs:Registers;
  Begin
    regs.bp:=$82;
    Intr($66,regs);
  End; {CD_TOC}

  Procedure CD_Play(tracknr:byte; repeating,chaining:boolean);
  Var regs:Registers;
  Begin
    regs.bp:=$83;
    regs.al:=tracknr;
    If repeating Then regs.ah:=1 Else regs.ah:=0;
    regs.cx:=0;
    If chaining Then Inc(regs.cx,1);
    regs.cx:=regs.cx+usedtimer*2;
    Intr($66,regs);
  End; {CD_Play}

  Procedure CD_Stop;
  Var regs:Registers;
  Begin
    regs.bp:=$84;
    Intr($66,regs);
  End; {CD_Stop}

  Procedure CD_Pause;
  Var regs:Registers;
  Begin
    regs.bp:=$85;
    Intr($66,regs);
  End; {CD_Pause}

  Procedure CD_Resume;
  Var regs:Registers;
  Begin
    regs.bp:=$86;
    Intr($66,regs);
  End; {CD_Resume}

  Procedure CD_Seek(time:shortint);
  Var regs:Registers;
  Begin
    regs.bp:=$87;
    regs.al:=time;
    Intr($66,regs);
  End; {CD_Seek}

  Function CD_Playing:boolean;
  Var regs:Registers;
  Begin
    regs.bp:=$88;
    Intr($66,regs);
    CD_Playing:=(regs.flags AND 1=0)
  End; {CD_Playing}

  Procedure FLC_Init(fxlistPtr,fxroutinePtr:pointer; videochange:boolean);
  Var regs:Registers;
  Begin
    regs.bp:=$C1;
    regs.es:=Seg(fxlistptr^);
    regs.dx:=Ofs(fxlistptr^);
    regs.ax:=Seg(fxroutineptr^);
    regs.bx:=Ofs(fxroutineptr^);
    If videochange Then regs.cx:=1 Else regs.cx:=0;
    Intr($66,regs);
  End; {FLC_Init}

  Procedure FLC_End(videoback:boolean);
  Var regs:Registers;
  Begin
    regs.bp:=$C2;
    If videoback Then regs.cx:=1 Else regs.cx:=0;
    Intr($66,regs);
  End; {FLC_End}

  Procedure FLC_Play(fname:string; speed,loops:byte; chaining,usefx:boolean);
  Var regs:Registers;
  Begin
    regs.bp:=$C3;
    String2Asciiz(fname);
    regs.es:=Seg(fname);
    regs.dx:=Ofs(fname);
    regs.cl:=speed;
    regs.ch:=loops;
    regs.al:=0;
    If chaining Then regs.al:=1;
    regs.al:=regs.al+usedtimer*2;
    If usefx Then regs.al:=regs.al+4;
    Intr($66,regs);
  End; {FLC_Play}

Begin
End.
