/*===========================================================================
SOLAR v0.94 :: Module user.c

This source code has been released into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
05-11-93 KJH  Started history.
05-25-93 KJH  Added SUBSCRIBE command.
07-15-94 KJH  Changed all printf() to fprintf()
===========================================================================*/

#include <dir.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define OPTIONS_FILE    "OPTIONS.HPG"
#define SOLAR_PROMPT    "Solar (? = menu) > "

#define YES                    0
#define NO                     1

extern char help_path[MAXPATH];
extern char user_path[MAXPATH];
extern char config_path[MAXPATH];
extern char waffle_path[MAXPATH];

extern char compress[10];         /* Compression method               */
extern char protocol[10];         /* Transfer protocol                */

extern int time_left;
extern int mail_message;          /* HD mail message type             */
extern int news_index;            /* HD news index type               */
extern int delete_mail;           /* Delete mailbox after transfer    */
extern int send_mail;             /* Batch mailbox to packet          */
extern int send_list;             /* Send LIST file                   */
extern int use_wafjoin;           /* Use Waffle's join file           */

extern enum Helldiver_Types { u, M, m, n, C, c };  /* Supported types */
extern char _slrerr[80];

extern int view_file(char filepath[MAXPATH]);
extern int join2newsrc();
extern int newsrc2join();
extern int build_newsrc();
extern int timechk(int min_left);

int select_protocol();
int select_compress();

/*
Function: user_options
Purpose : Main Solar user interface
Return  : 0 = exit Solar
          1 = batch packet
          2 = reply processing
         -1 = error
*/

int user_options()
{
	void solar_help();
  void solar_command_menu();
  void solar_settings();

  char command[80];
  int  save_flag = 0;

  strcpy(command,"XXX");
  while ((toupper(command[0]) != 'Q') && (toupper(command[0]) != 'E'))
	{
    if (strnicmp(command,"B",1) == 0) goto BatchExit;
    if (strnicmp(command,"R",1) == 0) goto ReplyExit;
    if ((strnicmp(command,"ME",2) == 0) || (command[0] == '\?'))
		{
			solar_command_menu();
			strcpy(command,"XXX");
		}

    /* HELP command */
    if (strnicmp(command,"H",1) == 0)
		{
      if (strcmp(help_path,"NONE") == 0)
      {
        strcat(help_path,waffle_path);
        strcat(help_path,"\\help\\solar");
      }
			if (view_file(help_path) != 0)
      {
        fprintf(stdout,"\nHelp not installed\n");
      }
			strcpy(command,"XXX");
		}

    /* SHOW command */
    if (strnicmp(command,"SH",2) == 0)
		{
			solar_settings();
			strcpy(command,"XXX");
		}

    /* MAIL command */
    if (strnicmp(command,"MA",2) == 0)
		{
      send_mail = YES;
      fprintf(stdout,"\nInclude Mail: YES\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* NOMAIL command */
    if (strnicmp(command,"NOM",3) == 0)
		{
      send_mail = NO;
      fprintf(stdout,"\nInclude Mail: NO\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* MMDF command */
    if (strnicmp(command,"MM",2) == 0)
		{
      mail_message = M;
      fprintf(stdout,"\nMail Format: MMDF\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* UNIX command */
    if (strnicmp(command,"U",1) == 0)
		{
      mail_message = m;
      fprintf(stdout,"\nMail Format: Unix\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* NODELETE command */
    if (strnicmp(command,"NOD",3) == 0)
		{
      delete_mail = NO;
      fprintf(stdout,"\nDelete Mail: NO\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* DELETE command */
    if (strnicmp(command,"D",1) == 0)
		{
      delete_mail = YES;
      fprintf(stdout,"\nDelete Mail: YES\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* LIST command */
    if (strnicmp(command,"L",1) == 0)
		{
      send_list = YES;
      fprintf(stdout,"\nInclude Msg Area List: YES\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* NOLIST command */
    if (strnicmp(command,"NOL",3) == 0)
		{
      send_list = NO;
      fprintf(stdout,"\nInclude Msg Area List: NO\n\n");
      save_flag = 1;
      strcpy(command,"XXX");
		}

    /* NOHEADER command */
    if (strnicmp(command,"NOH",3) == 0)
		{
      news_index = n;
      fprintf(stdout,"\nHeader Format: No headers\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* FULL HEADERS command */
    if (strnicmp(command,"F",1) == 0)
		{
      news_index = c;
      fprintf(stdout,"\nHeader Format: Full C-news\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* PARTIAL HEADERS command */
    if (strnicmp(command,"PA",2) == 0)
		{
      news_index = C;
      fprintf(stdout,"\nHeader Format: Partial C-news\n\n");
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* WAFFLE command */
    if (strnicmp(command,"W",1) == 0)
		{
			use_wafjoin = YES;
      fprintf(stdout,"\nUsing Waffle's JOIN file\n\n");
			strcpy(command,"XXX");
			save_flag = 1;
		}

    /* SOLAR command */
    if (strnicmp(command,"SO",2) == 0)
		{
			use_wafjoin = NO;
      fprintf(stdout,"\nUsing Solar's NEWSRC.HPG file\n\n");
			strcpy(command,"XXX");
			save_flag = 1;
		}

    /* 2WAFFLE command */
    if (strnicmp(command,"2W",2) == 0)
		{
      if (newsrc2join() == 0)
      {
        fprintf(stdout,"\nNEWSRC.HPG exported to JOIN\n\n");
      }
      else
      {
        fprintf(stdout,"<solar> error: %s\n", _slrerr);
      }
			strcpy(command,"XXX");
      save_flag = 1;
    }

    /* 2SOLAR command */
    if (strnicmp(command,"2S",2) == 0)
		{
      if (join2newsrc() == 0)
      {
        fprintf(stdout,"\nJOIN exported to NEWSRC.HPG\n\n");
      }
      else
      {
        fprintf(stdout,"<solar> error: %s\n", _slrerr);
      }
      strcpy(command,"XXX");
      save_flag = 1;
    }

    /* SUBSCRIBE command */
    if (strnicmp(command,"SU",2) == 0)
    {
      if (use_wafjoin == YES)
      {
        if (join2newsrc() == -1) goto ErrorExit;
      }
      switch (build_newsrc()) {
        case -1   : goto ErrorExit;
        default   : break;
      }
      if (use_wafjoin == YES)
      {
        if (newsrc2join() == -1) goto ErrorExit;
      }
      strcpy(command,"XXX");
    }

    /* PROTOCOL command */
    if (strnicmp(command,"PR",2) == 0)
		{
      if (select_protocol() != 0) goto ErrorExit;
      strcpy(command,"XXX");
      save_flag = 1;
    }

    /* COMPRESS command */
    if (strnicmp(command,"C",1) == 0)
		{
      if (select_compress() != 0) goto ErrorExit;
      strcpy(command,"XXX");
      save_flag = 1;
    }

    /* Unknown command */
    if (stricmp(command,"XXX") != 0)
		{
      fprintf(stdout,"\n%s: unknown command\n\n",command);
			strcpy(command,"XXX");
		}
		while ((stricmp(command,"XXX") == 0) || (!(strlen(command) > 0)))
    {
      if (save_flag == 1)
      {
        if ((save_flag = save_settings()) != 0) goto ErrorExit;
      }
      if (timechk(time_left) != 0) goto ErrorExit;
      fprintf(stdout,"%s",SOLAR_PROMPT);
			gets(command);
    }
  }
QuitExit:
  return 0;
BatchExit:
  if (use_wafjoin == YES)
  {
    if (join2newsrc() == -1) goto ErrorExit;
  }
  return 1;
ReplyExit:
  return 2;
ErrorExit:
  return -1;
}

void solar_command_menu()
{
  char menupath[MAXPATH];

  strcpy(menupath,waffle_path);
  strcat(menupath,"\\menus\\solar");
  if (view_file(menupath) != 0)
  {
    fprintf(stdout,"\nMenu has not been installed\n");
  }
  return;
}

/*
Function: solar_settings()
Purpose : Display the current user options for Solar.
Return  : N/A
*/

void solar_settings()
{
  fprintf(stdout,"\n");
  fprintf(stdout,"Include mail in packet    : ");
  switch (send_mail) {
    case YES : fprintf(stdout,"YES\n"); break;
    case NO  : fprintf(stdout,"NO\n"); break;
	}
  fprintf(stdout,"Mail message format       : ");
  switch (mail_message) {
    case m   : fprintf(stdout,"Unix Format\n"); break;
    case M   : fprintf(stdout,"MMDF Format\n"); break;
  }
  fprintf(stdout,"Delete mail after transfer: ");
  switch (delete_mail) {
    case YES : fprintf(stdout,"YES\n"); break;
    case NO  : fprintf(stdout,"NO\n"); break;
	}
  fprintf(stdout,"News header file format   : ");
  switch (news_index) {
    case n   : fprintf(stdout,"No Headers\n"); break;
    case C   : fprintf(stdout,"Partial C-news Format\n"); break;
    case c   : fprintf(stdout,"Full C-news Format\n"); break;
	}
  fprintf(stdout,"Include msg area list     : ");
  switch (send_list) {
    case YES : fprintf(stdout,"YES\n"); break;
    case NO  : fprintf(stdout,"NO\n"); break;
	}
  fprintf(stdout,"Subscription file         : ");
  switch (use_wafjoin) {
    case YES : fprintf(stdout,"JOIN\n"); break;
    case NO  : fprintf(stdout,"NEWSRC.HPG\n"); break;
	}
  fprintf(stdout,"Compression method        : %s\n", compress);
  fprintf(stdout,"Transfer protocol         : %s\n", protocol);

  fprintf(stdout,"\n");
  return;
}

/*
Function: save_settings()
Purpose : Save current settings to user-specific config file.
Return  : 0 on success, 1 otherwise.
*/

int save_settings()
{
  char path[MAXPATH];
  FILE *user_config = NULL;

	strcpy(path,user_path);
  strcat(path,"\\");
  strcat(path,OPTIONS_FILE);
  if ((user_config = fopen(path,"wt")) == NULL)
  {
    sprintf(_slrerr,"error opening %s for write",path);
    goto ErrorExit;
  }
  fprintf(user_config,"send-mail=");
  switch (send_mail) {
    case YES  : fprintf(user_config,"YES\n"); break;
    case NO   : fprintf(user_config,"NO\n"); break;
  }
  fprintf(user_config,"mail-type=");
  switch (mail_message) {
    case m    : fprintf(user_config,"m\n"); break;
    case M    : fprintf(user_config,"M\n"); break;
  }
  fprintf(user_config,"delete-mail=");
  switch (delete_mail) {
    case YES  : fprintf(user_config,"YES\n"); break;
    case NO   : fprintf(user_config,"NO\n"); break;
  }
  fprintf(user_config,"send-list=");
  switch (send_list) {
    case YES  : fprintf(user_config,"YES\n"); break;
    case NO   : fprintf(user_config,"NO\n"); break;
  }
  fprintf(user_config,"subscribe=");
	switch (use_wafjoin) {
    case YES  : fprintf(user_config,"YES\n"); break;
    case NO   : fprintf(user_config,"NO\n"); break;
  }
  fprintf(user_config,"news-index=");
  switch (news_index) {
    case n    : fprintf(user_config,"n\n"); break;
    case C    : fprintf(user_config,"C\n"); break;
    case c    : fprintf(user_config,"c\n"); break;
  }
  fprintf(user_config,"compress=%s\n",compress);
  fprintf(user_config,"protocol=%s\n",protocol);
  fclose(user_config);
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
Function: select_compress()
Purpose : Allow user to select from available compression methods.
Return  : Compression method string.
*/

int select_compress()
{
  FILE *config_file = fopen(config_path,"rt");
  char buf[128];
  int  idx = 0, choice = 0, temp = 0;
  char *p;

  if (!config_file)
  {
    sprintf(_slrerr,"error opening config file %s",config_path);
    goto ErrorExit;
  }
  fprintf(stdout,"\n");
  fprintf(stdout,"Current compression method: %s\n",compress);
  while (((fgets(buf,128,config_file)) != NULL) && (idx < 10))
	{
		if (strnicmp(buf,"compress",8) == 0)
    {
			idx++;
      if ((p = strtok(buf,"-")) == NULL)
      {
        strcpy(_slrerr,"invalid \"compress\" line in config file");
        goto ErrorExit;
      }
      if ((p = strtok(NULL,"=")) == NULL)
      {
        strcpy(_slrerr,"invalid \"compress\" line in config file");
        goto ErrorExit;
      }
      fprintf(stdout,"%u] %s\n",idx,p);
    }
	}
  if (idx < 1)
  {
    strcpy(_slrerr,"no installed compression options");
    goto ErrorExit;
  }

  fprintf(stdout,"\nEnter # : ");
  temp = getchar();
  fflush(stdin);
  fprintf(stdout,"\n");
  if (temp == 13) goto GoodExit;
  choice = temp - 48;
  if ((choice < 1) || (choice > idx))
	{
    fprintf(stdout,"Compression method still: %s\n\n",compress);
    goto GoodExit;
  }
  fseek(config_file,0L,SEEK_SET);
	idx = 0;
  while ((fgets(buf,128,config_file)) != NULL)
  {
    if (strnicmp(buf,"compress",8) == 0)
    {
      idx++;
			if ((p = strtok(buf,"-")) == NULL)
      {
        strcpy(_slrerr,"invalid \"compress\" line in config file");
        goto ErrorExit;
      }
      if ((p = strtok(NULL,"=")) == NULL)
      {
        strcpy(_slrerr,"invalid \"compress\" line in config file");
        goto ErrorExit;
      }
      if (idx == choice)
      {
        strcpy(compress,p);
        fprintf(stdout,"Compression Method: %s\n\n",compress);
        break;
			}
    }
  }
GoodExit:
  fclose(config_file);
  return 0;
ErrorExit:
  if (config_file) fclose(config_file);
  return 1;
}

/*
Function: select_protocol()
Purpose : Allow user to select from available compression methods.
Return  : Compression method string.
*/

int select_protocol()
{
	FILE *config_file = fopen(config_path,"rt");
	char buf[128];
  int  idx = 0, choice = 0, temp = 0;
	char *p;

  if (!config_file)
  {
    sprintf(_slrerr,"error opening config file %s",config_path);
    goto ErrorExit;
  }
  fprintf(stdout,"\n");
  fprintf(stdout,"Current protocol: %s\n",protocol);
  while (((fgets(buf,128,config_file)) != NULL) && (idx < 10))
  {
    if (strnicmp(buf,"receive",7) == 0)
    {
			idx++;
      if ((p = strtok(buf,"-")) == NULL)
      {
        strcpy(_slrerr,"invalid \"receive\" line in config file");
        goto ErrorExit;
      }
      if ((p = strtok(NULL,"=")) == NULL)
			{
        strcpy(_slrerr,"invalid \"receive\" line in config file");
        goto ErrorExit;
      }
      fprintf(stdout,"%u] %s\n",idx,p);
    }
	}
	if (idx < 1)
	{
    strcpy(_slrerr,"no installed protocol options");
    goto ErrorExit;
	}

  fprintf(stdout,"\nEnter # : ");
	temp = getchar();
  fprintf(stdout,"\n");
  fflush(stdin);
  if (temp == 13) return 0;
  choice = temp - 48;
	if ((choice < 1) || (choice > idx))
	{
    fprintf(stdout,"Protocol is still %s\n\n",protocol);
    goto GoodExit;
  }

  fseek(config_file,0L,SEEK_SET);
  idx = 0;
	while ((fgets(buf,128,config_file)) != NULL)
	{
    if (strnicmp(buf,"receive",7) == 0)
    {
      idx++;
      if ((p = strtok(buf,"-")) == NULL)
      {
        strcpy(_slrerr,"invalid \"receive\" line in config file");
        goto ErrorExit;
      }
      if ((p = strtok(NULL,"=")) == NULL)
      {
        strcpy(_slrerr,"invalid \"receive\" line in config file");
        goto ErrorExit;
			}
      if (idx == choice)
      {
        strcpy(protocol,p);
        fprintf(stdout,"Transfer Protocol: %s\n\n",protocol );
        break;
      }
    }
  }
GoodExit:
  fclose(config_file);
  return 0;
ErrorExit:
  if (config_file) fclose(config_file);
  return 1;
}
