/*===========================================================================
SOLAR v0.94:: Module config.c

This source code has been placed into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
05-11-93 KJH  Started history.
06-12-93 KJH  Added check for WAFFLEVERSION in env. and version: in static
              in support of Waffle 1.64 mailbox format.
07-15-94 KJH  Changed all printf() to fprintf()
===========================================================================*/

/* Header Files */
#include <dir.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include <dos.h>
#include <stdio.h>

#define OPTIONS_FILE    "OPTIONS.HPG"

extern char temp_path[MAXPATH];           /* From solar.c */
extern char user_path[MAXPATH];           /* From solar.c */

extern char help_path[MAXPATH];           /* From solar.c */
extern char waffle_path[MAXPATH];         /* From solar.c */
extern char log_path[MAXPATH];            /* From solar.c */
extern char config_path[MAXPATH];         /* From solar.c */
extern char solar_path[MAXPATH];          /* From solar.c */
extern char describe_path[MAXPATH];       /* From solar.c */

extern char uucp_name[10];                /* From solar.c */
extern char compress[10];                 /* From solar.c */
extern char protocol[10];                 /* From solar.c */
extern char waffle_version[5];            /* From solar.c */

extern long news_total_bytes;             /* From solar.c */
extern long news_area_bytes;              /* From solar.c */
extern long news_total_messages;          /* From solar.c */
extern long news_area_messages;           /* From solar.c */

extern int time_left;                     /* From solar.c */
extern int news_index;                    /* From solar.c */
extern int mail_message;                  /* From solar.c */
extern int delete_mail;                   /* From solar.c */
extern int send_mail;                     /* From solar.c */
extern int send_list;                     /* From solar.c */
extern int use_wafjoin;                   /* From solar.c */

extern char _slrerr[80];                  /* From solar.c */

extern int view_file(char filepath[MAXPATH]);

char system_path[MAXPATH];
char static_path[MAXPATH];

char *extract_parm(char string[128], char delimiter);
int  convert_to_number(char *argument);

/*
Function: load_static()
Purpose : Load uucpname, user, waffle, and temporary parameters from
					Waffle's static file. Load temporary only if it is not already
					set. This allows the configuration file SOLARWORK parameter
					override to work if the configuration file is processed before
					the static file.
Return  : 0 on success, non-zero and set _slrerr on error.
*/

int load_static(char username[10])
{
	char *path;

	FILE *static_file = NULL;

	char buffer[128];
	char delimiter = ':';

  /* Get path to Waffle static file and open file */
  strcpy(system_path,"NONE");
  if ((path = getenv("WAFFLE")) == NULL)
	{
    strcpy(_slrerr,"environment variable WAFFLE not set");
    goto ErrorExit;
	}
  strcpy(static_path,path);
  if ((static_file = fopen(static_path,"rt")) == NULL)
  {
    sprintf(_slrerr,"error opening static file %s",static_path);
    goto ErrorExit;
  }

  while (fgets(buffer,128,static_file) != NULL)
	{
		if (strnicmp(buffer,"UUCPNAME",8) == 0)
			strcpy(uucp_name,extract_parm(buffer,delimiter));
		if (strnicmp(buffer,"USER",4) == 0)
		{
			strcpy(user_path,extract_parm(buffer,delimiter));
			strcat(user_path, "\\");
			strcat(user_path, username);
		}
		if (strnicmp(buffer,"WAFFLE",6) == 0)
		{
			strcpy(waffle_path,extract_parm(buffer,delimiter));
      strcpy(log_path,waffle_path);
      strcat(log_path,"\\admin\\solar");
      strcpy(system_path,waffle_path);
      strcat(system_path,"\\system");
		}
		if (strnicmp(buffer,"TEMPORARY",9) == 0)
		{
			if (strcmp(temp_path,"NONE") == 0)
				strcpy(temp_path,extract_parm(buffer,delimiter));
		}
    if (strnicmp(buffer,"VERSION",7) == 0)
    {
      if (strcmp(waffle_version,"NONE") == 0)
        strcpy(waffle_version,extract_parm(buffer,delimiter));
    }
	}
	fclose(static_file);

	if (strcmp(uucp_name,"NONE") == 0)
	{
		strcpy(_slrerr,"\"uucpname:\" not found in static file");
		goto ErrorExit;
	}
	if (strcmp(temp_path,"NONE") == 0)
	{
		strcpy(_slrerr,"\"temporary:\" not found in static file");
		goto ErrorExit;
	}
	if (strcmp(waffle_path,"NONE") == 0)
	{
		strcpy(_slrerr,"\"waffle:\" not found in static file");
		goto ErrorExit;
	}
	if (strcmp(user_path,"NONE") == 0)
	{
		strcpy(_slrerr,"\"user:\" not found in static file");
		goto ErrorExit;
	}
  if (strcmp(waffle_version,"NONE") == 0)
  {
		if ((path = getenv("WAFFLEVERSION")) != NULL)
			strcpy(waffle_version,path);
		else
      strcpy(waffle_version,"1.65");
  }

GoodExit:
  return 0;
ErrorExit:
	return 1;
}

/*
Function: extract_parm()
Purpose : Extracts one word found after a delimiter in a string.
Return  : Returns the word found.
*/

char *extract_parm(char string[128], char delimiter)
{
	int  idx  = 0;
	int  idx2 = 0;
	static char path[MAXPATH];

	while (string[idx++] != delimiter);
	while (string[idx] == ' ') idx++;
	while ((string[idx] != ' ') && (string[idx] != '\0') && (string[idx] != '\n'))
	{
		if (string[idx] == '/')
		{
			path[idx2++] = '\\';
		}
		else
		{
			path[idx2++] = string[idx];
		}
		idx++;
	}
	path[idx2] = '\0';
	return path;
}

/*
Function: load_config()
Purpose : Load Solar's configuration file.
Return  : 0 on success, non-zero on error and set _slrerr.
*/

int load_config()
{
  int  get_compress_type(char buf[128]);
  int  get_protocol_type(char buf[128]);

  FILE *config_file = NULL;
	char buf[128];
	char delimiter = '=';
  char *path = NULL;

  if (strcmp(config_path,"NONE") == 0)
  {
    if ((path = getenv("SOLAR")) == NULL)
    {
      strcpy(_slrerr,"environment variable SOLAR not set");
      goto ErrorExit;
    }
    strcpy(config_path,path);
  }

  if ((config_file = fopen(config_path,"rt")) == NULL)
	{
    sprintf(_slrerr,"error opening config file %s",config_path);
    goto ErrorExit;
	}
	while (fgets(buf,128,config_file) != NULL)
	{
    if ((strnicmp(buf,"news-total-bytes",16)) == 0)
		{
			news_total_bytes = atol(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"news-area-bytes",15)) == 0)
		{
			news_area_bytes = atol(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"news-total-messages",19)) == 0)
		{
			news_total_messages = atol(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"news-area-messages",18)) == 0)
		{
			news_area_messages = atol(extract_parm(buf,delimiter));
		}
    if (strnicmp(buf,"describe",8) == 0)
    {
			strcpy(describe_path, extract_parm(buf,delimiter));
    }
    if ((strnicmp(buf,"HELPFILE",8)) == 0)
		{
			strcpy(help_path, extract_parm(buf,delimiter));
		}
		if (strnicmp(buf,"solarpath",9) == 0)
    {
      strcpy(solar_path, extract_parm(buf,delimiter));
    }

    /* Allow defaults for Helldiver formats to be set */

    if ((strnicmp(buf,"news-index",10)) == 0)
		{
      news_index = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"mail-type",8)) == 0)
		{
      mail_message = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"send-mail",7)) == 0)
		{
      send_mail = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"delete-mail",11)) == 0)
		{
      delete_mail = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"send-list",9)) == 0)
		{
      send_list = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"subscribe",9)) == 0)
		{
      use_wafjoin = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"compress",8)) == 0)
    {
      if (strcmp(compress,"NONE") == 0)
      {
        if (get_compress_type(buf) != 0) goto ErrorExit;
      }
    }
    if ((strnicmp(buf,"receive",7)) == 0)
    {
      if (strcmp(protocol,"NONE") == 0)
      {
        if (get_protocol_type(buf) != 0) goto ErrorExit;
      }
    }

    /* Override static settings from config file */

		if (strnicmp(buf,"SOLARWORK",9) == 0)
		{
			strcpy(temp_path,extract_parm(buf,delimiter));
		}
		if (strnicmp(buf,"LOGFILE",7) == 0)
		{
			strcpy(log_path,extract_parm(buf,delimiter));
		}
  }
	fclose(config_file);

GoodExit:
  return 0;
ErrorExit:
  if (config_file) fclose(config_file);
  return 1;
}

/*
Function: user_defaults()
Purpose : Check for a user config file and load values if present.
Return  : 0 on success, non-zero if not loaded or error.
*/

int user_defaults()
{
	FILE *user_config = NULL;

  char buf[128];
  char path[MAXPATH];
  char newpath[MAXPATH];
	long temp = 0L;
	char delimiter = '=';

  strcpy(path,user_path);
  strcat(path,"\\");
  strcat(path,OPTIONS_FILE);

  if ((user_config = fopen(path,"rt")) == NULL)
	{
    strcpy(newpath,waffle_path);
    strcat(newpath,"\\text\\solarnew");
    view_file(newpath);
    goto GoodExit; /* Assume there is no user config file */
  }
	while (fgets(buf,128,user_config) != NULL)
	{
    if ((strnicmp(buf,"mail-type",9)) == 0)
		{
      mail_message = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"news-index",10)) == 0)
		{
      news_index = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"delete-mail",11)) == 0)
		{
      delete_mail = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"send-mail",9)) == 0)
		{
      send_mail = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"send-list",9)) == 0)
		{
      send_list = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"subscribe",9)) == 0)
		{
      use_wafjoin = convert_to_number(extract_parm(buf,delimiter));
		}
    if ((strnicmp(buf,"news-total-bytes",16)) == 0)
		{
			temp = atol(extract_parm(buf,delimiter));
      if (temp < news_total_bytes)
        news_total_bytes = temp;
		}
    if ((strnicmp(buf,"news-area-bytes",15)) == 0)
		{
			temp = atol(extract_parm(buf,delimiter));
      if (temp < news_area_bytes)
        news_area_bytes = temp;
		}
    if ((strnicmp(buf,"news-total-messages",19)) == 0)
		{
			temp = atol(extract_parm(buf,delimiter));
      if (temp < news_total_messages)
        news_total_messages = temp;
		}
    if ((strnicmp(buf,"news-area-messages",18)) == 0)
		{
			temp = atol(extract_parm(buf,delimiter));
      if (temp < news_area_messages)
        news_area_messages = temp;
		}
    if ((strnicmp(buf,"compress",8)) == 0)
    {
      strcpy(compress,extract_parm(buf,delimiter));
    }
    if ((strnicmp(buf,"protocol",8)) == 0)
    {
      strcpy(protocol,extract_parm(buf,delimiter));
    }
  }
  fclose(user_config);
GoodExit:
  return 0;
}

/*
Function: get_compress_type()
Purpose : Extract compression type from string and store in global
          variable compress.
Return  : 0 on success, non-zero on error and set _slrerr.
*/

int get_compress_type(char buf[128])
{
  char *p = NULL;

  if ((p = strtok(buf,"-")) == NULL)
  {
    strcpy(_slrerr,"invalid \"compress\" line in config file");
    goto ErrorExit;
  }
  if ((p = strtok(NULL,"=")) == NULL)
  {
    strcpy(_slrerr,"invalid \"compress\" line in config file");
    goto ErrorExit;
  }
  strcpy(compress,p);
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
Function: get_protocol_type()
Purpose : Extract protocol type from string and store in global
          variable protocol.
Return  : 0 on success, non-zero on error and set _slrerr.
*/

int get_protocol_type(char buf[128])
{
	char search_string[20];
  char *p = NULL;

  if ((p = strtok(buf,"-")) == NULL)
  {
    strcpy(_slrerr,"invalid protocol line in configuration file");
    goto ErrorExit;
  }
  if ((p = strtok(NULL,"=")) == NULL)
  {
    strcpy(_slrerr,"invalid protocol line in configuration file");
    goto ErrorExit;
  }
  strcpy(protocol,p);
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
Function: int convert_to_number(char *argument)
Purpose : Convert alpha strings to internal numberical representations.
Return  : The number corresponding to the alpha string.
*/

int convert_to_number(char *argument)
{
  /* Helldiver Packet Format Types */
  if (strcmp(argument,"u") == 0)
    return 0;
  if (strcmp(argument,"M") == 0)
    return 1;
  if (strcmp(argument,"m") == 0)
    return 2;
  if (strcmp(argument,"n") == 0)
    return 3;
  if (strcmp(argument,"C") == 0)
    return 4;
  if (strcmp(argument,"c") == 0)
    return 5;

  /* Boolean Values */
  if (stricmp(argument,"YES") == 0)
    return 0;
  if (stricmp(argument,"NO") == 0)
    return 1;
  fprintf(stderr,"<warning> obsolete OPTIONS.HPG value accepted: %s\n",argument);
  return atoi(argument);
}
