/*===========================================================================
SOLAR v0.94 :: Module join.c

This source code has been released into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
06-20-93 KJH  Started history.
07-15-94 KJH  Changed all printf() to fprintf()
===========================================================================*/

/*
Function: int join2newsrc()
Purpose : Convert Waffle's join file to newsrc.hpg format.
Return  : 0 on success, 1 on error, -1 on fatal. set _slrerr.
*/

#include <dir.h>
#include <string.h>
#include <stdio.h>

extern char user_path[MAXPATH];
extern char _slrerr[80];

int join2newsrc()
{
  FILE *wafjoin = NULL;
  FILE *slrjoin = NULL;
  char wafjoinpath[MAXPATH];
  char slrjoinpath[MAXPATH];
  char wafjoinbuf[80];
  char slrjoinbuf[80];
  char *p;

  strcpy(wafjoinpath, user_path);
  strcat(wafjoinpath, "\\JOIN");
  strcpy(slrjoinpath, user_path);
  strcat(slrjoinpath, "\\NEWSRC.HPG");

  if ((wafjoin = fopen(wafjoinpath,"rt")) == NULL)
  {
    sprintf(_slrerr, "file %s not found",wafjoinpath);
    goto ErrorExit;
  }
  if ((slrjoin = fopen(slrjoinpath,"wt")) == NULL)
  {
    sprintf(_slrerr, "error opening %s for write", slrjoinpath);
    goto FatalExit;
  }

  while (fgets(wafjoinbuf,80,wafjoin) != NULL)
  {
    wafjoinbuf[strlen(wafjoinbuf) - 1] = '\0';
    if ((p = strtok(wafjoinbuf," ")) == NULL)
    {
      sprintf(_slrerr,"invalid %s file format",wafjoinpath);
      goto FatalExit;
    }
    strcpy(slrjoinbuf,p);
    strcat(slrjoinbuf,":");
    if ((p = strtok(NULL," ")) != NULL)
    {
      strcat(slrjoinbuf," 1-");
      strcat(slrjoinbuf,p);
    }
    fprintf(slrjoin,"%s\n",slrjoinbuf);
  }
  fclose(slrjoin);
  fclose(wafjoin);

GoodExit:
  return 0;
ErrorExit:
  if (wafjoin) fclose(wafjoin);
  if (slrjoin) fclose(slrjoin);
  return 1;
FatalExit:
  if (wafjoin) fclose(wafjoin);
  if (slrjoin) fclose(slrjoin);
  return -1;
}

/*
Function: int newsrc2join()
Purpose : Convert newsrc.hpg to Waffle's join format.
Return  : 0 on success, 1 on error, -1 on fatal. set _slrerr.
*/

int newsrc2join()
{
  FILE *wafjoin = NULL;
  FILE *slrjoin = NULL;
  char wafjoinpath[MAXPATH];
  char slrjoinpath[MAXPATH];
  char wafjoinbuf[80];
  char slrjoinbuf[80];
  int x = 0;
  char *p;

  strcpy(wafjoinpath, user_path);
  strcat(wafjoinpath, "\\JOIN");
  strcpy(slrjoinpath, user_path);
  strcat(slrjoinpath, "\\NEWSRC.HPG");

  if ((slrjoin = fopen(slrjoinpath,"rt")) == NULL)
  {
    sprintf(_slrerr, "file %s not found",wafjoinpath);
    goto ErrorExit;
  }
  if ((wafjoin = fopen(wafjoinpath,"wt")) == NULL)
  {
    sprintf(_slrerr, "error opening %s for write", slrjoinpath);
    goto FatalExit;
  }

  while (fgets(slrjoinbuf,80,slrjoin) != NULL)
  {
    slrjoinbuf[strlen(slrjoinbuf) - 1] = '\0';
    if ((p = strtok(slrjoinbuf,":")) == NULL)
    {
      sprintf(_slrerr,"invalid %s file format",slrjoinpath);
      goto FatalExit;
    }
		if (p[0] != '!')
		{
			strcpy(wafjoinbuf,p);
			if ((p = strtok(NULL,"-")) != NULL)
			{
				if ((p = strtok(NULL,"-")) != NULL)
				{
					strcat(wafjoinbuf," ");
					strcat(wafjoinbuf,p);
				}
			}
      fprintf(wafjoin,"%s\n",wafjoinbuf);
		}
	}
  fclose(slrjoin);
  fclose(wafjoin);

GoodExit:
  return 0;
ErrorExit:
  if (wafjoin) fclose(wafjoin);
  if (slrjoin) fclose(slrjoin);
  return 1;
FatalExit:
	if (wafjoin) fclose(wafjoin);
  if (slrjoin) fclose(slrjoin);
  return -1;
}

