{Program written by Brian Inderwies, 6/17/93}
{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This program will read a user-specified number of records (maximum 50)
of software titles and store them in a data file called SD.PAS.  As well,
the program will be able to print records and lables}
PROGRAM SOFTWARE_DATABASE;

{Initalizes the screen and printer}
USES CRT, PRINTER;

{Sets constants for the file paths}
CONST CONFIG_FILE = 'C:\SD\CONFIG.CFG';
      MAIN_MENU_HELP = 'C:\SD\MMHELP.HLP';
      CONFIG_HELP = 'C:\SD\CNHELP.HLP';
      ADD_MENU_HELP = 'C:\SD\ADHELP.HLP';
      PRINT_MENU_HELP = 'C:\SD\PRHELP.HLP';
      DATABASE_FILE_NAME = 'C:\SD\DB.FIL';

{Sets necessary variables}

    {A character value of the user's choice at a menu}
VAR CHOICE                                         : CHAR;
    {A real value of a user's choice}
    REAL_CHOICE                                    : REAL;
    {The version number of the program, stored in CONFIG}
    VERSION                                        : REAL;
    {The name of the user, stored as a string in CONFIG}
    REG_NAME                                       : STRING;
    {A temporary storage unit used for a myriad of things}
    TEMP                                           : INTEGER;
    {Stores the user's preferences, read from CONFIG}
    ASCII_PREF, LABEL_PREF                         : INTEGER;
    {Prints out "Yes" or "No" for these options in the configuration menu}
    LABELS, ASCII                                  : STRING;
    {A screenful of help information}
    SCREEN                                 : ARRAY [1..25] OF STRING;
    {Counts lines (for help system)}
    LINE                                           : INTEGER;
    {Exit control variable}
    EXIT                                           : INTEGER;
    {The array of the database itself}
    DATABASE                               : ARRAY [1..26, 1..6] OF STRING;
    {The three types of files used by the program}
    DB, CONFIG, HELP                               : TEXT;
    {The name of the report}
    DB_NAME                                        : STRING;
    {Integers to control the database array}
    RECORDS, FIELDS                                : INTEGER;
    {The total number of records}
    NUMBER_OF_RECORDS                              : INTEGER;
    {Keeps track of the record number}
    RECORD_NUMBER                                  : INTEGER;
    {The first and last record (for printing purposes}
    FIRST, LAST                                    : INTEGER;
    {The number of times each label will be printed}
    TIMES                                          : INTEGER;
    {Keeps track (1 or 0) if the printing range has been changed}
    CHANGED                                        : INTEGER;
    {Control variable for input}
    CONTROL                                        : INTEGER;
    {"Substitiution" values for building boxes - they are replaced
    with upper-ASCII or lower-ASCII codes, depending on which type
    of printing has been established}
    U_L_CORNER, U_R_CORNER, L_L_CORNER, L_R_CORNER : INTEGER;
    D_H_LINE, D_V_LINE, SINGLE_LINE                : INTEGER;
    LEFT_BREAK, RIGHT_BREAK                        : INTEGER;
    UPPER_STEM, LOWER_STEM, D_U_STEM, D_L_STEM     : INTEGER;

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{Sets FORWARD values to menu procedures so that they can be called
before the actual procedure exists}
PROCEDURE MAIN_MENU; FORWARD;
PROCEDURE CONFIGURATION;  FORWARD;
PROCEDURE ADD_RECORDS;  FORWARD;
PROCEDURE MODIFY_FIELD_NAMES;  FORWARD;
PROCEDURE PRINT_REPORT;  FORWARD;
PROCEDURE PRINT_LABELS;  FORWARD;

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure, while relatively inefficient, will draw lines consisting of
higher ASCII characters.  Parameters follow the form LEFT CORNER CHARACTER,
LINE CHARACTER, LENGTH OF LINE, and RIGHT CORNER character.  The left and
right corner characters are skipped should their parameter values be 0}
PROCEDURE ASCII_LINE(CONSOLE, L_CORNER, LINE, LINE_LENGTH, R_CORNER:INTEGER);

BEGIN;  {ASCII_LINE}

    {Draws the left corner character, if a value is specified}
    IF L_CORNER > 0 THEN
       {Prints to printer or screen, depending on CONSOLE}
       CASE CONSOLE OF
          0  : WRITE(LST, CHR(L_CORNER));
          1  : WRITE(CHR(L_CORNER));
         ELSE WRITE(CHR(L_CORNER));
       END;  {CASE}

    {This loop will draw the specified character the number of
    times as specified in LINE_LENGTH}
    FOR TEMP := 1 TO LINE_LENGTH DO
       {Prints to printer or screen, depending on CONSOLE}
       CASE CONSOLE OF
          0  : WRITE(LST, CHR(LINE));
          1  : WRITE(CHR(LINE));
         ELSE WRITE(CHR(LINE));
       END;  {CASE}

    {Draws the right corner (or cross), if a value is specified}
    IF R_CORNER > 0 THEN
       {Prints to printer or screen, depending on CONSOLE}
       CASE CONSOLE OF
          0  : WRITE(LST, CHR(R_CORNER));
          1  : WRITE(CHR(R_CORNER));
         ELSE WRITE(CHR(R_CORNER));
       END;  {CASE}

END;  {ASCII_LINE}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will print the program name and version number,
as well as the defined registration name}
PROCEDURE REGISTRATION_SCREEN;

BEGIN;  {REGISTRATION_SCREEN}

   {Opens CONFIG for reading, so that the version number and
   registration name (among other information) can be read}
   ASSIGN(CONFIG, CONFIG_FILE);
   RESET(CONFIG);
   READLN(CONFIG, VERSION);
   READLN(CONFIG, REG_NAME);
   READLN(CONFIG, DB_NAME);
   READLN(CONFIG, ASCII_PREF);
   READLN(CONFIG, LABEL_PREF);
   {Closes CONFIG}
   CLOSE(CONFIG);
   WRITELN;  WRITELN;  WRITELN;
   {Creates spaces}
   ASCII_LINE(1, 0, 255, 21, 0);
   WRITELN(CHR(254),' SOFTWARE DATABASE version ',VERSION:1:2,' ',CHR(254));
   {Creates spaces}
   ASCII_LINE(1, 0, 255, 23, 0);
   WRITE('Registered to: ');
   WRITELN(REG_NAME);
   WRITELN;

END;  {REGISTRATION_SCREEN}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

PROCEDURE WELCOME;

BEGIN;  {WELCOME}

   {Clears the screen}
   CLRSCR;
   {Runs REGISTRATION SCREEN}
   REGISTRATION_SCREEN;
   {These lines write welcoming information on the screen}
   WRITELN;  WRITELN;
   ASCII_LINE(1, 0, 255, 24, 0);
   WRITELN('Written by Brian Inderwies');
   {Blank space}
   ASCII_LINE(1, 0, 255, 19, 0);
   WRITELN('Version 1.00 - compiled June 19, 1993');
   WRITELN;
   WRITELN('WELCOME!  SOFTWARE DATABASE is the  easy way  to keep  track',
          ' of  all  of  your ');
   WRITELN('software programs.  Fully customizable, this program allows',
          ' the user to define ');
   WRITELN('such parameters as memory, number of disks, platform, etc.  ',
          ' Output   may   be ');
   WRITELN('printed in either label or report format, and  will  consist',
          ' of   higher-ASCII ');
   WRITELN('characters, if the user desires. Please do not modify this ',
          'program without the');
   WRITELN('consent of the author. ');
   {Will skip 9 lines}
   FOR TEMP := 1 TO 9 DO
      WRITELN;
   {Blank space}
   ASCII_LINE(1, 0, 255, 28, 0);
   WRITELN(CHR(254),' Press RETURN ',CHR(254));
   {Prompts the user to press a key}
   READLN;

END;  {WELCOME}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This is a generic procedure which will output a given help file
at a given location}
PROCEDURE HELP_SCREEN(SPECIFIC_FILE:STRING; ORIGINAL_MENU:CHAR);

BEGIN;  {HELP}

   {Opens the general file HELP, whose specific file
   is defined by the calling procedure}
   ASSIGN(HELP, SPECIFIC_FILE);
   RESET(HELP);
   {Clears the screen}
   CLRSCR;
   {Shows the registration screen}
   REGISTRATION_SCREEN;
   {Reads up to 17 lines from a supplementary help file}
   FOR LINE := 1 TO 17 DO

   BEGIN;   {FOR loop}

      READLN(HELP, SCREEN[LINE]);
      WRITELN(SCREEN[LINE]);

   END;   {FOR loop}

WRITELN;
{Creates spaces}
ASCII_LINE(1, 0, 255, 28, 0);
WRITELN(CHR(254),' Press RETURN ',CHR(254));
READLN;
{Closes file}
CLOSE(HELP);
{Will return to a procedure, depending on the value of ORIGINAL_MENU}
CASE ORIGINAL_MENU OF
   'M' : MAIN_MENU;
   'C' : CONFIGURATION;
   'A' : ADD_RECORDS;
   'R' : PRINT_REPORT;
   'L' : PRINT_LABELS;
{Elsewise, the main menu will be called upon}
ELSE MAIN_MENU;

END;  {CASE}

END;  {HELP_SCREEN}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

PROCEDURE PRINT_TEST;

BEGIN;   {PRINT_TEST}

   {Clears the screen}
   CLRSCR;
   WRITELN('Press RETURN to start the printer test...');
   {Waits until RETURN is pressed}
   READLN;
   WRITELN;
   {Prints a ASCII line to the printer}
   ASCII_LINE(0, 0, 205, 40, 0);
   WRITELN(LST);
   WRITELN;
   WRITELN('If your printer produced a straight line (see below),');
   WRITELN('then you can support ASCII printing:');
   WRITELN;
   {Prints a line to the screen}
   ASCII_LINE(1, 0, 205, 40, 0);
   WRITELN;
   WRITELN;
   WRITELN('Did you get a line (Y/N)?');
   {Prompts the user for a choice}
   CHOICE := READKEY;
   {Converts CHOICE to uppercase}
   CHOICE := UPCASE(CHOICE);
   WRITELN(CHOICE);
   CASE CHOICE OF
       'Y' : ASCII_PREF := 1;
       'N' : ASCII_PREF := 0;
   END;  {CASE}
   WRITELN;

END;  {PRINT_TEST}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure allows the user to change the configuration}
PROCEDURE CHANGE_CONFIGURATION;

BEGIN;  {CHANGE_CONFIGURATION}

    WRITELN;
    WRITELN('Do you want to change the registration name (Y/N)?');
    {Prompts the user}
    CHOICE := READKEY;
    {Sets CHOICE to uppercase}
    CHOICE := UPCASE(CHOICE);
    WRITELN(CHOICE);
    {Will allow the user to choose a different name if desired}
    IF CHOICE = 'Y'
    THEN BEGIN;
          WRITELN('Enter your name (15 characters maximum):');
          ASCII_LINE(1, 0, 205, 15, 0);
          WRITELN;
          READLN(REG_NAME);
         END;
    WRITELN;
    WRITELN('Do you want to change the database name (Y/N)?');
    {Prompts the user}
    CHOICE := READKEY;
    {Sets CHOICE to uppercase}
    CHOICE := UPCASE(CHOICE);
    {Will allow the user to change his database name if desired}
    WRITELN(CHOICE);
    IF CHOICE = 'Y'
    THEN BEGIN;
            WRITELN('Enter a new database name (15 characters maximum):');
            ASCII_LINE(1, 0, 205, 15, 0);
            WRITELN;
            {Prompts the user}
            READLN(DB_NAME);
         END;
    WRITELN;
    WRITELN('Do you want to print labels (Y/N)?');
    {Prompts the user}
    CHOICE := READKEY;
    {Sets CHOICE to uppercase}
    CHOICE := UPCASE(CHOICE);
    WRITELN(CHOICE);
    {Allows the user to select whether output is in reports or labels}
    IF CHOICE = 'Y'
       THEN LABEL_PREF := 1
       ELSE LABEL_PREF := 0;
    WRITELN;
    WRITELN('Would you like higher-ASCII printing (see help - not all');
    WRITELN('printers can support this function) (Y/N/(T)est)?');
    {Prompts the user}
    CHOICE := READKEY;
    CHOICE := UPCASE(CHOICE);
    WRITELN(CHOICE);
    {Gives the user the choice of no ASCII printing, ASCII printing,
    or a printer test}
    CASE CHOICE OF
       'Y' : ASCII_PREF := 1;
       'T' : PRINT_TEST;   {calls on PRINT_TEST}
       'N' : ASCII_PREF := 0;
    END;
    WRITELN;
    WRITELN('Please wait, saving settings...');
    {Writes newly created settings to file CONFIG}
    REWRITE(CONFIG);
    WRITELN(CONFIG, VERSION);
    WRITELN(CONFIG, REG_NAME);
    WRITELN(CONFIG, DB_NAME);
    WRITELN(CONFIG, ASCII_PREF);
    WRITELN(CONFIG, LABEL_PREF);
    {Prepares the file for re-reading}
    CLOSE(CONFIG);
    RESET(CONFIG);
    {Returns to configuration menu}


END;  {CHANGE_CONFIGURATION}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will append one record to the database}
PROCEDURE ADD_ONE_RECORD;

BEGIN;   {ADD_ONE_RECORD}

{Opens database for reading}
RESET(DB);
{Reads the number of records}
READLN(DB, NUMBER_OF_RECORDS);
{Reads all other database records into array DATABASE}
FOR RECORDS := 1 TO NUMBER_OF_RECORDS + 1 DO
    FOR FIELDS := 1 TO 6 DO
        READLN(DB, DATABASE[RECORDS, FIELDS]);
{Will only let the user add a record if 25 don't
already exist}
IF NUMBER_OF_RECORDS < 25 THEN

   BEGIN;  {IF_THEN_LOOP}

      {Clears the screen}
      CLRSCR;
      WRITELN('Current number of records:  ',NUMBER_OF_RECORDS);
      WRITELN('Adding record number ',NUMBER_OF_RECORDS + 1);
      {Prompts the user 6 times, for the fields for which
      data will be entered}
      FOR FIELDS := 1 TO 6 DO

      BEGIN;   {FOR loop}

         WRITELN;
         WRITELN('Please enter a value for field ',DATABASE[1, FIELDS],
         ' (19 characters maximum):');
         ASCII_LINE(1, 0, 205, 20, 0);
         WRITELN;
         {Prompts the user}
         READLN(DATABASE[NUMBER_OF_RECORDS + 2, FIELDS]);

      END;   {FOR loop}
      WRITELN;
      WRITELN(CHR(254),' Press RETURN ',CHR(254));
      {Requires a carriage return}
      READLN;
      WRITELN;
      WRITELN('Please wait, saving settings...');
      {Opens the database for writing}
      REWRITE(DB);
      {Writes all of the records (including the new one)
      to the database}
      WRITELN(DB, NUMBER_OF_RECORDS + 1);
      FOR RECORDS := 1 TO NUMBER_OF_RECORDS + 2 DO
          FOR FIELDS := 1 TO 6 DO
              WRITELN(DB, DATABASE[RECORDS, FIELDS]);
   END   {IF-THEN loop}

   {If there are 25 or more records, the user will receive a message}
   ELSE BEGIN;   {IF-THEN loop}

        WRITELN;
        WRITELN('You have exceeded the maximum number of records.');
        WRITELN('To add a new one, you must modify an existing record.');
        WRITELN;
        WRITELN(CHR(254),' Press RETURN ',CHR(254));
        {Requires a carriage return}
        READLN;

   END;  {IF-THEN loop}

{Closes the file DATABASE}
CLOSE(DB);
{Returns to ADD_RECORDS menu}
ADD_RECORDS;

END;   {ADD_ONE_RECORD}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will allow the user to view one record}
PROCEDURE VIEW_RECORDS;

BEGIN;   {VIEW_RECORDS}

   {Opens DATABASE for reading}
   RESET(DB);
   {Reads the number of records}
   READLN(DB, NUMBER_OF_RECORDS);
   {Will not allow you to view a record if none exist}
   IF NUMBER_OF_RECORDS > 0 THEN

   BEGIN;   {IF-THEN loop}

      WRITELN;
      WRITELN('There are currently ',NUMBER_OF_RECORDS,' records.');
      WRITELN('Which record would you like to view (1 - ',NUMBER_OF_RECORDS,'):');
      {Prompts the user for a number}
      READLN(REAL_CHOICE);
      {Makes the value an automatic integer}
      RECORD_NUMBER := TRUNC(REAL_CHOICE);
      {If the number denotes a valid record, then the record is displayed}
      IF (RECORD_NUMBER <= NUMBER_OF_RECORDS) AND (RECORD_NUMBER >= 1) THEN

      BEGIN;   {nested IF-THEN loop}

         {Clears the screen}
         CLRSCR;
         {Reads all values up to the one requested}
         FOR RECORDS := 1 TO RECORD_NUMBER + 1 DO
             FOR FIELDS := 1 TO 6 DO
                 READLN(DB, DATABASE[RECORDS, FIELDS]);
         WRITELN('Current values for entry ',RECORD_NUMBER,':');
         {Sets the number to one greater so that the correct
         information is displayed}
         RECORD_NUMBER := RECORD_NUMBER + 1;
         WRITELN;
         {Draws the information box}
         ASCII_LINE(1, 218, 196, 46, 191);
         WRITELN;
         WRITELN(CHR(179),'  ',DATABASE[1, 1]:20,': ',DATABASE[RECORD_NUMBER, 1]:20,
             '  ',CHR(179));
         WRITELN(CHR(179),'  ',DATABASE[1, 2]:20,': ',DATABASE[RECORD_NUMBER, 2]:20,
             '  ',CHR(179));
         WRITELN(CHR(179),'  ',DATABASE[1, 3]:20,': ',DATABASE[RECORD_NUMBER, 3]:20,
             '  ',CHR(179));
         WRITELN(CHR(179),'  ',DATABASE[1, 4]:20,': ',DATABASE[RECORD_NUMBER, 4]:20,
                '  ',CHR(179));
         WRITELN(CHR(179),'  ',DATABASE[1, 5]:20,': ',DATABASE[RECORD_NUMBER, 5]:20,
                 '  ',CHR(179));
         WRITELN(CHR(179),'  ',DATABASE[1, 6]:20,': ',DATABASE[RECORD_NUMBER, 6]:20,
                '  ',CHR(179));
         ASCII_LINE(1, 192, 196, 46, 217);
         WRITELN;   WRITELN;
         WRITELN(CHR(254),' Press RETURN ',CHR(254));
         {Prompts a carriage return}
         READLN;

      END   {nested IF-THEN}

      {If the number is invalid, a message is printed}
      ELSE BEGIN;  {nested IF-THEN}

          {Writes the message}
          WRITELN('Sorry, this number is invalid because: ');
          WRITELN(' ',CHR(249),' It exceeds the maximum number of entries (25), or');
          WRITELN(' ',CHR(249),' There is currently no created record at that number');
          WRITELN;
          WRITELN(CHR(254),' Press RETURN ',CHR(254));
          {Prompts a carriage return}
          READLN;

      END;  {nested IF-THEN}

   END  {IF-THEN loop}

   {If no records exist, a message will be printed}
   ELSE BEGIN;   {IF-THEN loop}

         WRITELN;
         WRITELN('Sorry, there are currently no records to view.');
         WRITELN;  WRITELN(CHR(254),' Press RETURN ',CHR(254));
         {Prompts a carriage return}
         READLN;

      END;  {IF-THEN loop}

{Closes the DATABASE file}
CLOSE(DB);
{Returns to ADD_RECORDS menu}
ADD_RECORDS;

END;   {VIEW_RECORDS}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will modify the record of the user's choice}
PROCEDURE MODIFY_RECORDS;

BEGIN;  {MODIFY_RECORDS}

   {Opens the database for reading}
   RESET(DB);
   {Reads the number of records existing}
   READLN(DB, NUMBER_OF_RECORDS);
   {Will only allow the modification of a record if one exists}
   IF NUMBER_OF_RECORDS >= 1 THEN

   BEGIN;  {IF-THEN loop}

      {Reads all records into array DATABASE}
      FOR RECORDS := 1 TO NUMBER_OF_RECORDS + 1 DO
          FOR FIELDS := 1 TO 6 DO
              READLN(DB, DATABASE[RECORDS, FIELDS]);
      WRITELN;
      WRITELN('There are currently ',NUMBER_OF_RECORDS,' record(s).');
      WRITELN('Which would you like to modify (1 - ',NUMBER_OF_RECORDS,')?');
      {Reads the record number}
      READLN(REAL_CHOICE);
      {Forces the number as an integer}
      RECORD_NUMBER := TRUNC(REAL_CHOICE);
      {Will modify the record if the inputted choice is valid}
      IF (RECORD_NUMBER > 0) AND (RECORD_NUMBER <= NUMBER_OF_RECORDS) THEN

      BEGIN;   {nested IF-THEN}

         {Clears the screen}
         CLRSCR;
         WRITELN('Modifying entry ',RECORD_NUMBER,'...');
         {Modifies each record for all fields (6)}
         FOR CONTROL := 1 TO 6 DO

         BEGIN;  {FOR loop}

            WRITELN;
            WRITELN('Current value of this entry: ',DATABASE[RECORD_NUMBER + 1, CONTROL]);
            WRITELN('Please enter a value for field ',DATABASE[1, CONTROL],
            ' (19 characters maximum):');
            ASCII_LINE(1, 0, 205, 20, 0);
            WRITELN;
            {Reads the value as part of the array}
            READLN(DATABASE[RECORD_NUMBER + 1, CONTROL]);

         END;    {FOR loop}

         WRITELN;
         WRITELN('Are you sure that you want to modify this entry (Y/N)?');
         {Reads the character as a key}
         CHOICE := READKEY;
         {Converts the value to uppercase}
         CHOICE := UPCASE(CHOICE);
         {Writes the inputted value to the screen}
         WRITELN(CHOICE);
         {Will write the change if Y is selected}
         IF CHOICE = 'Y' THEN

         BEGIN;  {double-nested IF-THEN}

           WRITELN;  WRITELN('Please wait, saving settings...');
           {Opens the database for writing}
           REWRITE(DB);
           {Writes the array and number of records to the file}
           WRITELN(DB, NUMBER_OF_RECORDS);
           FOR RECORDS := 1 TO RECORD_NUMBER DO
             FOR FIELDS := 1 TO 6 DO
                 WRITELN(DB, DATABASE[RECORDS, FIELDS]);
           FOR CONTROL := 1 TO 6 DO
             WRITELN(DB, DATABASE[RECORD_NUMBER + 1, CONTROL]);
           FOR RECORDS := RECORD_NUMBER + 2 TO NUMBER_OF_RECORDS + 1 DO
             FOR FIELDS := 1 TO 6 DO
                 WRITELN(DB, DATABASE[RECORDS, FIELDS]);
           {Closes DATABASE}
           CLOSE(DB);

         END;  {double-nested IF-THEN}

      END   {nested IF-THEN}

   END  {IF-THEN loop}

   {If there are no records, a message is printed}
   ELSE BEGIN;   {IF-THEN loop}

      WRITELN;
      WRITELN('Sorry, there are currently no records to modify.');
      WRITELN;
      WRITELN(CHR(254),' Press RETURN ',CHR(254));
      {Prompts a carriage return}
      READLN;

   END;   {IF-THEN loop}

{Calls on ADD_RECORDS menu}
ADD_RECORDS;

END;   {MODIFY_RECORDS}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will quit the program by changing the value of the exit
"flag" (stored in variable EXIT)}
PROCEDURE QUIT;

BEGIN;  {QUIT}

   {Initally sets the quit variable, CHOICE, to NO}
   CHOICE := 'N';
   WRITELN;
   WRITELN('Are you sure (Y/N)?');
   {Reads the user's input, YES or NO}
   CHOICE := READKEY;
   {Converts the CHOICE var. so that it is always uppercase}
   CHOICE := UPCASE(CHOICE);
   WRITELN(CHOICE);
   {If the user doesn't want to quit, the main menu is returned to.
   If he does, then EXIT is 1 and the program will stop}
   IF CHOICE <> 'Y' THEN EXIT := 1
                    ELSE EXIT := 0;

END;  {QUIT}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will truncate the last record in the database}
PROCEDURE TRUNCATE_LAST;

BEGIN;  {TRUNCATE_LAST}

   {Opens the database for reading}
   RESET(DB);
   READLN(DB, NUMBER_OF_RECORDS);
   {If records exist, the option will be given}
   IF NUMBER_OF_RECORDS >= 1 THEN

   BEGIN;  {IF-THEN loop}

     FOR RECORDS := 1 TO NUMBER_OF_RECORDS + 1 DO
       FOR FIELDS := 1 TO 6 DO
         READLN(DB, DATABASE[RECORDS, FIELDS]);
     WRITELN;  WRITELN('There are currently ',NUMBER_OF_RECORDS,' records.');
     WRITELN('Do you REALLY want to delete record ',NUMBER_OF_RECORDS,' (Y/N)?');
     {Prompts the user for a character response}
     CHOICE := READKEY;
     {Converts that choice to uppercase}
     CHOICE := UPCASE(CHOICE);
     {Writes it back to the screen}
     WRITELN(CHOICE);
     {Will delete record if choice was Y}
     IF CHOICE = 'Y' THEN

     BEGIN;    {nested IF-THEN}

      WRITELN;  WRITELN('Truncating entry ',NUMBER_OF_RECORDS,'...');
      {Truncates the last by shortening the number of records}
      NUMBER_OF_RECORDS := NUMBER_OF_RECORDS - 1;
      {Opens file for writing}
      REWRITE(DB);
      {Re-writes entire database information back to the file}
      WRITELN(DB, NUMBER_OF_RECORDS);
      FOR RECORDS := 1 TO NUMBER_OF_RECORDS + 1 DO
          FOR FIELDS := 1 TO 6 DO
              WRITELN(DB, DATABASE[RECORDS, FIELDS]);
      {Closes the file DATABASE}
      CLOSE(DB);

     END;  {nested IF-THEN}

END   {IF-THEN loop}

{If no files exist, a message will be printed}
ELSE BEGIN;  {IF-THEN loop}

   WRITELN;
   WRITELN('There are no records to delete.');
   WRITELN;  WRITELN(CHR(254),' Press RETURN ',CHR(254));
   {Prompts a carriage return}
   READLN;

END;  {IF-THEN loop}

{Returns to ADD_RECORDS menu}
ADD_RECORDS;

END;   {TRUNCATE_LAST}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will access the ADD RECORDS menu}
PROCEDURE ADD_RECORDS;

BEGIN;  {ADD_RECORDS}

   {Assigns DATABASE to a DOS file name}
   ASSIGN(DB, DATABASE_FILE_NAME);
   {Clears the screen}
   CLRSCR;
   {Runs REGISTRATION SCREEN}
   REGISTRATION_SCREEN;
   {These next few lines draw the menu itself}
   WRITELN;
   ASCII_LINE(1, 0, 255, 16, 0);
   WRITELN(CHR(240),' ADD RECORDS ',CHR(240));
   WRITELN;
   ASCII_LINE(1, 218, 196, 43, 191);
   WRITELN;
   WRITELN(CHR(179),' [A]dd a record                            ',CHR(179));
   WRITELN(CHR(179),' [V]iew a record                           ',CHR(179));
   WRITELN(CHR(179),' [M]odify a record                         ',CHR(179));
   WRITELN(CHR(179),' [T]runcate last record                    ',CHR(179));
   WRITELN(CHR(179),' [E]xit program                            ',CHR(179));
   WRITELN(CHR(179),' [Q]uit to main                            ',CHR(179));
   WRITELN(CHR(179),' [?] Help                                  ',CHR(179));
   ASCII_LINE(1, 192, 196, 43, 217);
   WRITELN;
   WRITELN;
   {Asks the user to press a desired key, to be stored in CHOICE}
   CHOICE := READKEY;
   {Keeps CHOICE an uppercase character}
   CHOICE := UPCASE(CHOICE);
   {Writes CHOICE back to the screen}
   WRITELN(CHOICE);
   {Runs the respective procedure, depending on the value of CHOICE}
   CASE CHOICE OF
     'A'           : ADD_ONE_RECORD;
     'V'           : VIEW_RECORDS;
     'M'           : MODIFY_RECORDS;
     'E'           : QUIT;
     'T'           : TRUNCATE_LAST;
     'Q'           : MAIN_MENU;
     '?'           : HELP_SCREEN(ADD_MENU_HELP,'A');
   {Else, the menu will be redrawn}
   ELSE ADD_RECORDS;
   END;  {CASE}

END;  {ADD_RECORDS}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will physically change the name of a field}
PROCEDURE CHANGE_NAME(FIELD_NUMBER:INTEGER);

BEGIN;  {CHANGE_NAME}

   WRITELN;
   WRITELN('Current name is: ',DATABASE[1, FIELD_NUMBER]:20);
   WRITELN('Enter new name (18 characters maximum): ');
   ASCII_LINE(1, 0, 205, 15, 0);
   WRITELN;
   {Reads a string, which will be a field name}
   READLN(DATABASE[1, FIELD_NUMBER]);
   {Opens the database for reading}
   REWRITE(DB);
   WRITELN(DB, NUMBER_OF_RECORDS);
   {Rewrites all of the names}
   FOR TEMP := 1 TO 6 DO
       WRITELN(DB, DATABASE[1, TEMP]);

{Writes the rest of the records}
FOR RECORDS := 2 TO (NUMBER_OF_RECORDS + 1) DO
       FOR FIELDS := 1 TO 6 DO
           WRITELN(DB, DATABASE[RECORDS, FIELDS]);

{Closes database file}
CLOSE(DB);

END;  {CHANGE_NAME}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will allow the user to modify the field names
(6 in all)}
PROCEDURE MODIFY_FIELD_NAMES;

BEGIN;  {MODIFY_FIELD_NAMES}

   {Assigns the database to its respective path}
   ASSIGN(DB, DATABASE_FILE_NAME);
   RESET(DB);
   READLN(DB, NUMBER_OF_RECORDS);
   FOR TEMP := 1 TO 6 DO
   READLN(DB, DATABASE[1, TEMP]);
   FOR RECORDS := 2 TO (NUMBER_OF_RECORDS + 1) DO
       FOR FIELDS := 1 TO 6 DO
           READLN(DB, DATABASE[RECORDS, FIELDS]);
   CLRSCR;
   {These next (many) lines do nothing more than print a
   chart of the current field names}
   ASCII_LINE(1, 0, 178, 78, 0);
   WRITELN;
   ASCII_LINE(1, 0, 178, 28, 0);
   WRITE(' CURRENT FIELD NAMES ');
   ASCII_LINE(1, 0, 178, 29, 0);
   WRITELN;
   ASCII_LINE(1, 0, 177, 78, 0);
   WRITELN;
   ASCII_LINE(1, 0, 177, 8, 0);
   WRITE(' ',DATABASE[1, 1]:20,' ');
   ASCII_LINE(1, 0, 177, 17, 0);
   WRITE(' ',DATABASE[1, 2]:20,' ');
   ASCII_LINE(1, 0, 177, 9, 0);
   WRITELN;
   ASCII_LINE(1, 0, 177, 8, 0);
   WRITE(' ',DATABASE[1, 3]:20,' ');
   ASCII_LINE(1, 0, 177, 17, 0);
   WRITE(' ',DATABASE[1, 4]:20,' ');
   ASCII_LINE(1, 0, 177, 9, 0);
   WRITELN;
   ASCII_LINE(1, 0, 176, 8, 0);
   WRITE(' ',DATABASE[1, 5]:20,' ');
   ASCII_LINE(1, 0, 176, 17, 0);
   WRITE(' ',DATABASE[1, 6]:20,' ');
   ASCII_LINE(1, 0, 176, 9, 0);
   WRITELN;
   ASCII_LINE(1, 0, 176, 78, 0);
   WRITELN;   WRITELN;
   {Prompts the user}
   WRITELN('Select the field number which you would like to change ',
          '(1 - 6, [Q]uit)');
   {Reads CHOICE as a key}
   CHOICE := READKEY;
   {Will run CHANGE_NAME for the entry number provided}
   CASE CHOICE OF
      '1' : CHANGE_NAME(1);
      '2' : CHANGE_NAME(2);
      '3' : CHANGE_NAME(3);
      '4' : CHANGE_NAME(4);
      '5' : CHANGE_NAME(5);
      '6' : CHANGE_NAME(6);
      'Q' : CONFIGURATION;
   {If nothing is chosen, it will return to CONFIGURATION}
   ELSE CONFIGURATION;
   END;  {CASE}

END;  {MODIFY_FIELD_NAMES}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure physically prints out the report}
PROCEDURE PRINT_THE_REPORT;

BEGIN;  {PRINT_THE_REPORT}

{This will modify the ASCII characters to be sent to the printer.  If
upper-ASCII printing is selected, the numbers will be normal, while they
will be set to standard characters if not}
IF ASCII_PREF = 1 THEN

   BEGIN;  {IF-THEN loop}

         {Sets respective graphic variables}
         U_L_CORNER := 201;
         U_R_CORNER := 187;
         L_L_CORNER := 200;
         L_R_CORNER := 188;
         D_H_LINE   := 205;
         D_V_LINE   := 186;
         SINGLE_LINE := 179;
         LEFT_BREAK :=  181;
         RIGHT_BREAK := 198;
         UPPER_STEM :=  209;
         LOWER_STEM := 207;
         D_U_STEM := 203;
         D_L_STEM := 202;

   END  {IF-THEN loop}

   {Sets lower-ASCII values}
   ELSE BEGIN;   {IF-THEN loop}

         U_L_CORNER := 43;
         U_R_CORNER := 43;
         L_L_CORNER := 43;
         L_R_CORNER := 43;
         D_H_LINE   := 45;
         D_V_LINE   := 124;
         SINGLE_LINE := 124;
         LEFT_BREAK := 124;
         RIGHT_BREAK := 124;
         UPPER_STEM := 43;
         LOWER_STEM := 43;
         D_U_STEM := 43;
         D_L_STEM := 43;

    END;  {IF-THEN loop}

    WRITELN;
    WRITELN('Make SURE that your printer is on...');
    WRITELN;  WRITELN(CHR(254),' Press RETURN ',CHR(254));
    {Prompts a carriage return}
    READLN;
    WRITELN('Printing, please wait.....');
    {Opens the database for reading}
    ASSIGN(DB, DATABASE_FILE_NAME);
    RESET(DB);
    {Reads only records that were specified by the user}
    READLN(DB, NUMBER_OF_RECORDS);
    FOR RECORDS := 1 TO (LAST + 1) DO
          FOR FIELDS := 1 TO 6 DO
              READLN(DB, DATABASE[RECORDS, FIELDS]);
    {Closes the database}
    CLOSE(DB);
    {Writes out heading information for the report}
    WRITELN(LST,'SOFTWARE DATABASE by Brian Inderwies (Period 6), version ',
           VERSION:1:2);
    WRITELN(LST,'Registration Name: ',REG_NAME:15,'   Report Name: ',
           DB_NAME:15);
    WRITELN(LST,'Total Records: ',NUMBER_OF_RECORDS:2,'                    ',
           'Printing records ',FIRST,' through ',LAST);
    WRITELN(LST);
    {Will print a chart of records, depending on the number existing}
    FOR RECORDS := (FIRST + 1) TO (LAST + 1) DO

    BEGIN;  {FOR loop}

        {Writes top line}
        ASCII_LINE(0, U_L_CORNER, D_H_LINE, 3, LEFT_BREAK);
        WRITE(LST, ' ',RECORDS - 1:2,' ');
        ASCII_LINE(0, RIGHT_BREAK, D_H_LINE, 9, UPPER_STEM);
        ASCII_LINE(0, 0, D_H_LINE, 19, D_U_STEM);
        ASCII_LINE(0, 0, D_H_LINE, 18, UPPER_STEM);
        ASCII_LINE(0, 0, D_H_LINE, 19, U_R_CORNER);
        WRITELN(LST);
        FOR FIELDS := 1 TO 3 DO

        BEGIN;   {nested FOR loop}

              {repetitively writes entries}
              WRITE(LST, CHR(D_V_LINE),DATABASE[1, FIELDS]:18);
              WRITE(LST, CHR(SINGLE_LINE),DATABASE[RECORDS, FIELDS]:19);
              WRITE(LST, CHR(D_V_LINE),DATABASE[1, FIELDS + 2]:18);
              WRITELN(LST, CHR(SINGLE_LINE),DATABASE[RECORDS, FIELDS + 2]:19,
                     CHR(D_V_LINE));

        END;   {nested FOR loop}

        {Writes bottom line}
        ASCII_LINE(0, L_L_CORNER, D_H_LINE, 18, LOWER_STEM);
        ASCII_LINE(0, 0, D_H_LINE, 19, D_L_STEM);
        ASCII_LINE(0, 0, D_H_LINE, 18, LOWER_STEM);
        ASCII_LINE(0, 0, D_H_LINE, 19, L_R_CORNER);
        {Returns the cursor}
        WRITELN(LST);

    END;   {FOR loop}

END;   {PRINT_THE_REPORT}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will physically print out labels}
PROCEDURE PRINT_THE_LABELS;

BEGIN;   {PRINT_THE_LABELS}

   {Opens the database for reading}
   RESET(DB);
   {Reads the database in its entirety}
   READLN(DB, NUMBER_OF_RECORDS);
   FOR RECORDS := 1 TO NUMBER_OF_RECORDS + 1 DO
          FOR FIELDS := 1 TO 6 DO
              READLN(DB, DATABASE[RECORDS, FIELDS]);
   {Closes the database}
   CLOSE(DB);
   WRITELN;
   WRITELN('Make SURE that your printer is on...');
   WRITELN;  WRITELN(CHR(254),' Press RETURN ',CHR(254));
   {Prompts a carriage return}
   READLN;
   WRITELN;  WRITELN('Printing, please wait.....');
   {Prints out a label for the number of iterations specified as
   well as the range of records specified}
   FOR RECORDS := (FIRST + 1) TO (LAST + 1) DO
       FOR LINE := 1 TO TIMES DO

           BEGIN;    {nested FOR loop}

              WRITE(LST, DATABASE[RECORDS, 1]:19);
              WRITELN(LST, '     Disk ',LINE:2,' of ',TIMES:2);
              WRITELN(LST,DATABASE[1, 2]:18,' ',DATABASE[RECORDS, 2]:19);
              WRITELN(LST,DATABASE[1, 3]:18,' ',DATABASE[RECORDS, 3]:19);
              WRITELN(LST,DATABASE[1, 4]:18,' ',DATABASE[RECORDS, 4]:19);
              WRITELN(LST);
              WRITELN(LST);
              WRITELN(LST);
              WRITELN(LST);

           END;   {nested FOR loop}

END;   {PRINT_THE_LABELS}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will change the range of printing}
PROCEDURE CHANGE_RANGE;

BEGIN;   {CHANGE_RANGE}

      WRITELN;
      WRITELN('Current number of records: ',NUMBER_OF_RECORDS);
      WRITELN('Enter starting number: ');
      {Reads a user-selected number}
      READLN(REAL_CHOICE);
      {Makes value an automatic integer}
      FIRST := TRUNC(REAL_CHOICE);
      {If the number is out of range, a message will be printed}
      IF (FIRST < 1) OR (FIRST > NUMBER_OF_RECORDS) THEN

      BEGIN;   {IF-THEN loop}

         WRITELN;   WRITELN('Starting number cannot be less than 1 ',
                            'or exceed the number of existing entries.');
         WRITELN;   WRITELN(CHR(254),' Press RETURN ',CHR(254));
         {Prompts a carriage return}
         READLN;
         {Not changed if error occurs}
         CHANGED := 0;

      END   {IF-THEN loop}

      {Elsewise, the value is shown changed}
      ELSE CHANGED := 1;
      WRITELN;  WRITELN('Enter ending number: ');
      {Reads ending number}
      READLN(REAL_CHOICE);
      {Forces integer value}
      LAST := TRUNC(REAL_CHOICE);
      {If the ending number is invalid, a message is printed}
      IF (LAST > NUMBER_OF_RECORDS) OR (LAST < 1) OR (LAST < FIRST) THEN

      BEGIN;   {IF-THEN loop}

         WRITELN;   WRITELN('Ending number cannot exceed total or ',
                           'starting number, or be less than 1.');
         WRITELN;   WRITELN(CHR(254),' Press RETURN ',CHR(254));
         {Prompts a carriage return}
         READLN;
         {Unchanged value when error occurs}
         CHANGED := 0;

      END  {IF-THEN loop}

      {Elsewise, the value is known as being changed}
      ELSE CHANGED := 1;
      {If labels are being printed, then the procedure will ask
      how many times the user wants to print each label}
      IF LABEL_PREF = 1 THEN

      BEGIN;  {IF-THEN loop}

         WRITELN;
         WRITELN('How many times would you like to print each label?');
         {Reads number}
         READLN(REAL_CHOICE);
         {Only reads the value if it is valid}
         IF (REAL_CHOICE >= 1) AND (REAL_CHOICE <= 10) THEN
         BEGIN;  {nested IF-THEN}

            TIMES := TRUNC(REAL_CHOICE);
            CHANGED := 1;

         END {nested IF-THEN}
         ELSE CHANGED := 0;

      END;  {IF-THEN loop}

      {Will return to the appropriate menu, depending on what will
      be printed}
      CASE LABEL_PREF OF
        1 : PRINT_LABELS;
        0 : PRINT_REPORT;
      END;   {CASE}

END;   {CHANGE_RANGE}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{Produces the label-printing menu}
PROCEDURE PRINT_LABELS;

BEGIN;   {PRINT_LABELS}

   {Clears the screen}
   CLRSCR;
   {Produces registration information}
   REGISTRATION_SCREEN;
   {Opens the database for reading}
   RESET(DB);
   {Reads the number of records}
   READLN(DB, NUMBER_OF_RECORDS);
   {If the numbers were not changed, then printing defaults are instituted}
   IF CHANGED <> 1 THEN

   BEGIN;  {IF-THEN loop}

      FIRST := 1;
      LAST := NUMBER_OF_RECORDS;
      TIMES := 1;

   END;  {IF-THEN loop}

   {These next few lines draw the menu itself}
   WRITELN;
   ASCII_LINE(1, 0, 255, 14, 0);
   WRITELN(CHR(240),' PRINT: LABELS ',CHR(240));
   WRITELN;
   ASCII_LINE(1, 218, 196, 43, 191);
   WRITELN;
   WRITELN(CHR(179),' Print from records ',FIRST:2,' to ',LAST:2,'       ',
          '        ',CHR(179));
   WRITELN(CHR(179),' Print each label ',TIMES:2,' times             ',
          '    ',CHR(179));
   WRITELN(CHR(179),' [P]rint labels                            ',CHR(179));
   WRITELN(CHR(179),' [C]hange range and times                  ',CHR(179));
   WRITELN(CHR(179),' [Q]uit to main                            ',CHR(179));
   WRITELN(CHR(179),' [E]xit                                    ',CHR(179));
   WRITELN(CHR(179),' [?] Help                                  ',CHR(179));
   ASCII_LINE(1, 192, 196, 43, 217);
   WRITELN;
   WRITELN;
   {Asks the user to press a desired key, to be stored in CHOICE}
   CHOICE := READKEY;
   {Keeps CHOICE an uppercase character}
   CHOICE := UPCASE(CHOICE);
   {Runs the respective procedure, depending on the value of CHOICE}
   CASE CHOICE OF
      'P'  : PRINT_THE_LABELS;
      'C'  : CHANGE_RANGE;
      'Q'  : MAIN_MENU;
      'E'  : QUIT;
      '?'  : HELP_SCREEN(PRINT_MENU_HELP, 'L');
   {Otherwise the menu is redrawn}
   ELSE PRINT_LABELS;
   END;   {CASE}

END;   {PRINT_LABELS}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure will print a report}
PROCEDURE PRINT_REPORT;

BEGIN;  {PRINT_REPORT}

   {Clears the screen}
   CLRSCR;
   {Produces registration information}
   REGISTRATION_SCREEN;
   {Opens the database for reading}
   RESET(DB);
   {Reads the number of records}
   READLN(DB, NUMBER_OF_RECORDS);
   {If the numbers were not changed, then printing defaults are instituted}
   IF CHANGED <> 1 THEN

   BEGIN;  {IF-THEN loop}

      FIRST := 1;
      LAST := NUMBER_OF_RECORDS;


   END;  {IF-THEN loop}

   {These next few lines draw the menu itself}
   WRITELN;
   ASCII_LINE(1, 0, 255, 14, 0);
   WRITELN(CHR(240),' PRINT: REPORT ',CHR(240));
   WRITELN;
   ASCII_LINE(1, 218, 196, 43, 191);
   WRITELN;
   WRITELN(CHR(179),' Print from records ',FIRST:2,' to ',LAST:2,'       ',
          '        ',CHR(179));
   WRITELN(CHR(179),' [P]rint report                            ',CHR(179));
   WRITELN(CHR(179),' [C]hange range                            ',CHR(179));
   WRITELN(CHR(179),' [Q]uit to main                            ',CHR(179));
   WRITELN(CHR(179),' [E]xit                                    ',CHR(179));
   WRITELN(CHR(179),' [?] Help                                  ',CHR(179));
   ASCII_LINE(1, 192, 196, 43, 217);
   WRITELN;
   WRITELN;
   {Asks the user to press a desired key, to be stored in CHOICE}
   CHOICE := READKEY;
   {Keeps CHOICE an uppercase character}
   CHOICE := UPCASE(CHOICE);
   {Runs the respective procedure, depending on the value of CHOICE}
   CASE CHOICE OF
      'P'  : PRINT_THE_REPORT;
      'C'  : CHANGE_RANGE;
      'Q'  : MAIN_MENU;
      'E'  : QUIT;
      '?'  : HELP_SCREEN(PRINT_MENU_HELP, 'R');
   ELSE PRINT_REPORT;
   END;  {CASE}

END;   {PRINT_REPORT}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure produces the configuration menu}
PROCEDURE CONFIGURATION;

BEGIN;  {CONFIGURATION}

   {Clears the screen}
   CLRSCR;
   {Prints registration information}
   REGISTRATION_SCREEN;
   {Opens CONFIG for reading}
   RESET(CONFIG);
   {Simply prints the menu itself}
   WRITELN;
   ASCII_LINE(1, 0, 255, 14, 0);
   WRITELN(CHR(240),' CONFIGURATION ',CHR(240));
   WRITELN;
   ASCII_LINE(1, 218, 196, 43, 191);
   {Chooses value of Yes/No string depending on integer values}
   CASE LABEL_PREF OF
       1 : LABELS := 'Yes';
       0 : LABELS := 'No';
   END;  {CASE}

   CASE ASCII_PREF OF
       1 : ASCII := 'Yes';
       0 : ASCII := 'No';
   END;  {CASE}

   {Draws the menu}
   WRITELN;
   WRITELN(CHR(179),' Current settings:                         ',CHR(179));
   WRITELN(CHR(179),'   Registration name: ',REG_NAME:15 ,'      ',CHR(179));
   WRITELN(CHR(179),'   Database name: ',DB_NAME:20,'     ',CHR(179));
   WRITELN(CHR(179),'   ASCII printing: ',ASCII:3,'                     ',CHR(179));
   WRITELN(CHR(179),'   Print labels: ',LABELS:4,'                      ',CHR(179));
   WRITELN(CHR(179),' [C]hange this configuration               ',CHR(179));
   WRITELN(CHR(179),' [M]odify field names                      ',CHR(179));
   WRITELN(CHR(179),' [E]xit program                            ',CHR(179));
   WRITELN(CHR(179),' [Q]uit to main menu                       ',CHR(179));
   WRITELN(CHR(179),' [?] Help                                  ',CHR(179));
   ASCII_LINE(1, 192, 196, 43, 217);
   {Closes CONFIG}
   CLOSE(CONFIG);
   WRITELN;
   WRITELN;
   {Reads CHOICE as a key}
   CHOICE := READKEY;
   {Sets CHOICE to uppercase}
   CHOICE := UPCASE(CHOICE);
   {Acts upon the value of CHOICE}
   CASE CHOICE OF
      'C' : CHANGE_CONFIGURATION;
      'M' : MODIFY_FIELD_NAMES;
      'Q' : MAIN_MENU;
      'E' : QUIT;
      '?' : HELP_SCREEN(CONFIG_HELP, 'C');
   {If the value of CHOICE is not one of the above,
   the config menu is redrawn}
   ELSE CONFIGURATION;
   END;  {CASE statement}

END;  {CONFIGURATION}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{This procedure produces the main program menu}
PROCEDURE MAIN_MENU;

BEGIN;  {MAIN_MENU}

{Clears the screen}
   CLRSCR;
   {Runs REGISTRATION SCREEN}
   REGISTRATION_SCREEN;
   {These next few lines draw the menu itself}
   ASSIGN(DB, DATABASE_FILE_NAME);
   WRITELN;
   ASCII_LINE(1, 0, 255, 16, 0);
   WRITELN(CHR(240),' MAIN MENU ',CHR(240));
   WRITELN;
   ASCII_LINE(1, 218, 196, 43, 191);
   WRITELN;
   WRITELN(CHR(179),' [A]dd records                             ',CHR(179));
   WRITELN(CHR(179),' [P]rint report                            ',CHR(179));
   WRITELN(CHR(179),' [C]onfiguration                           ',CHR(179));
   WRITELN(CHR(179),' [E]xit                                    ',CHR(179));
   WRITELN(CHR(179),' [?] Help                                  ',CHR(179));
   ASCII_LINE(1, 192, 196, 43, 217);
   WRITELN;
   WRITELN;
   {Asks the user to press a desired key, to be stored in CHOICE}
   CHOICE := READKEY;
   {Keeps CHOICE an uppercase character}
   CHOICE := UPCASE(CHOICE);
   {Runs the respective procedure, depending on the value of CHOICE}
   CASE CHOICE OF
      'A'           : ADD_RECORDS;
      'P'           : CASE LABEL_PREF OF
                      1 : PRINT_LABELS;
                      0 : PRINT_REPORT;
                      END;
      'C'           : CONFIGURATION;
      'E', 'Q', 'X'     : QUIT;
      '?'           : HELP_SCREEN(MAIN_MENU_HELP, 'M');
   ELSE MAIN_MENU;
   END;  {CASE statement}

END; {MAIN_MENU}

{**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**}

{The main calling program begins here}
BEGIN;  {SOFTWARE_DATABASE}

{Prints welcoming information}
WELCOME;
{Sets variable EXIT to an inital value of 1 so that the program will run}
EXIT := 1;

{If EXIT ever does NOT equal 1, the program will stop}
WHILE EXIT = 1 DO

BEGIN;  {WHILE-DO loop}

   {Loads the main menu}
   MAIN_MENU;

END;  {WHILE_DO loop}

{Clears the screen}
CLRSCR;
{Prints ending remark}
WRITELN('SOFTWARE DATABASE by Brian Inderwies');

END.  {SOFTWARE_DATABASE}

{ Nonstandard Pascal devices used in this program:         }
{ (that is, they are not included in standard Pascal)      }
{    CLRSCR - clears the screen                            }
{    UPCASE - converts CHAR variables to uppercase         }
{    READKEY - reads an immediate character from the       }
{              keyboard                                    }
{    FORWARD - declares a procedure before it              }
{              actually appears                            }