/*
	SNEWS 1.91

	Private decls for the SNEWS news reader


    Copyright (C) 1991  John McCombs, Christchurch, NEW ZEALAND
                        john@ahuriri.gen.nz
                        PO Box 2708, Christchurch, NEW ZEALAND

	Modifications copyright (C) 1993  Daniel Fandrich
						<dan@fch.wimsey.bc.ca> or CompuServe 72365,306

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 1, as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    See the file COPYING, which contains a copy of the GNU General
    Public License.


	Source is formatted with a tab size of 4.

 */

#include <alloc.h>
#include <process.h>
#include <io.h>


/* #define INCLUDE_SIG */   /* enable this to have the reply function put */
                            /* your sig on the reply - mail ususally does */
                            /* this                                       */



#define ENTER               0x0D
#define ESCAPE              0x1B
#define TAB                 0x09
#define BACKSP				0x08

#define LEFT                (0x4b << 8)
#define RIGHT               (0x4d << 8)
#define cLEFT               (0x73 << 8)
#define cRIGHT              (0x74 << 8)
#define Fn1                 (0x3b << 8)
#define Fn2                 (0x3c << 8)
#define Fn3                 (0x3d << 8)
#define Fn4                 (0x3e << 8)

#define  UP_ARR             ('H' << 8)
#define  DN_ARR             ('P' << 8)
#define  PGUP               ('I' << 8)
#define  PGDN               ('Q' << 8)
#define  HOME               ('G' << 8)
#define  END                ('O' << 8)

enum exit_codes {
	EX_CONT,
	EX_DUMMY,

	EX_PREVIOUS,
	EX_PREVIOUS10,
	EX_NEXT,
	EX_NEXT10,
	EX_NEXT_UNREAD,

	EX_DONE,
	EX_QUIT
};

#define TEXT_LINE           5
#define PAGE_HEADER         5
#define PAGE_LENGTH         19

/* if you change these see show_help */
#define HELP_GROUP          0
#define HELP_THREAD         1
#define HELP_ARTICLES       2

/*
 *  This structure allows the creation of linked list of article numbers
 */
typedef struct art_id {
    long   id;                  /* article number                 */
    long   art_off;             /* offset of the article          */
    struct art_id *next_art;    /* pointer to next article number */
    struct art_id *prev_art;    /* pointer to prev article number */
} ART_ID;

/*
 *  This structure is a doubly linked list of the unique article headers.  The
 *  linked list of article numbers is built on 'art_num'.  This system
 *  is allows flexible use of memory, but will get slower by n'ish
 *  and there is a fair degree of allocation overhead in the ART_ID structure
 *  But hey, it's simple
 */
typedef struct article {
	char   header[63];          /* article header (subject)    */
    int    num_articles;        /* number with this header     */
    ART_ID *art_num;            /* pointer to list of articles */
    struct article *next;       /* next topic                  */
    struct article *last;       /* last topic                  */
    int    index;               /* topic number from start     */
} ARTICLE;





/*
 *  This structure is a linked list of lines that make up an article. The
 *  file is read in and the linked list is built
 */
typedef struct line {
    char   *data;               /* pointer to line of text     */
    struct line *next;          /* next line                   */
    struct line *last;          /* last line                   */
    int    index;               /* line number from start      */
} LINE;


/*
 *  This structure is the handle for an article in RAM.  The file
 *  is read in and the linked list built.
 */
/* These lengths don't propagate everywhere -- careful when changing them */
#define WHO_LENGTH 70
#define ORG_LENGTH 20
#define MSG_ID_LENGTH 50
typedef struct {
    char  author[WHO_LENGTH];           /* truncated author              */
    char  organisation[ORG_LENGTH];     /* truncated organisation        */
    char  follow_up[80];      /* group for follow-up article             */
    int   lines;              /* total lines in file                     */
    LINE  *top;               /* points to start of article, incl header */
    LINE  *start;             /* ponts to start of text                  */
} TEXT;


void select_code_page(void);

ACTIVE *select_group(ACTIVE *head, ACTIVE *current);
void show_help(int h);
void show_values(void);
int read_group(ACTIVE *gp);
void show_groups(ACTIVE **top, ACTIVE *this, int force);
ARTICLE *get_headers(ACTIVE *gp);
void eat_gunk(char *buf);
void free_header(ARTICLE *start);
ACTIVE *search_groups(ACTIVE *this);


void show_threads(ACTIVE *gp, ARTICLE **top, ARTICLE *this, int force);
void select_thread(ACTIVE *gp, ARTICLE *head);
enum exit_codes read_thread(ACTIVE *gp, ARTICLE *this, ART_ID *first, int a_ct);
ARTICLE *search_subjects(ARTICLE *this);

int count_unread_in_thread(ACTIVE *gp, ARTICLE *a);
int count_unread_in_group(ACTIVE *gp);
int mark_group_as_read(ACTIVE *gp);

void command(char *msg);
void message(char *msg);
void lmessage(char *msg);

TEXT *load_article(char *fnx, long offset);
void free_article(TEXT *t);


enum exit_codes read_article(ACTIVE *gp, TEXT *tx, char *subject, int a_ct, int of_ct);
void show_article(ACTIVE *gp, TEXT *tx, char *subject, LINE *this, int a_ct,
                  int of_ct);
void show_percent(int percent);
LINE *search_text(LINE *this);


int save_to_disk(TEXT *tx, char *save_name, int mailbox);
void reply_to_article(TEXT *tx, char *subject);
void get_his_stuff(TEXT *tx, char *author, char *msg_id);


void post(TEXT *tx, char *newsgroups, char *subject);
void post_it(FILE *article, char *newsgroups, char *subject, char *dist,
                  char *msg_id);

void rot13(TEXT *tx);

void expand_tabs(char *buf, int max_len);

int newsgroups_valid(char *ng);

void mail_to_someone(TEXT *tx);

void save_thread_to_disk(ACTIVE *gp, ARTICLE *this, char *save_name);
void pipe_article(TEXT *tx, char *prog_name);

int get_any_key(void);
char *stristr(char *str, char *sstr);
