/*
	SNEWS 1.91

    rmgroup - remove newsgroups from the active file, and delete the files


    Copyright (C) 1991  John McCombs, Christchurch, NEW ZEALAND
                        john@ahuriri.gen.nz
                        PO Box 2708, Christchurch, NEW ZEALAND

	Modifications copyright (C) 1993  Daniel Fandrich
						<dan@fch.wimsey.bc.ca> or CompuServe 72365,306

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 1, as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    See the file COPYING, which contains a copy of the GNU General
    Public License.


	Source is formatted with a tab size of 4.

 */

#include "defs.h"

INFO my_stuff;


/*---------------------------- main ---------------------------------------*/
void main(int argc, char *argv[])
{
    /*
     *  Delete a newsgroup.
     *
     *      - delete the data and index files
     *      - re-write the active file, without that newsgroup, saving
     *        the old one as .bak
     *
     *  This program could be structured to run faster, but I have tried
     *  to do things so that if rmgroup croaks part way through, as little
     *  damage will be done as possible.
     *
     */

    int    i;
    char   buf[256], buf2[256], *dir, *p;
    ACTIVE *gp;
    FILE   *active_file, *new_active_file;

	signal(SIGINT, sig_break);		/* turn control-break off */

	fprintf(stderr, "RMGROUP: (%s)\n\n", VERSION);

	if ((argc > 1) &&
		(argv[1][0] != '-') && (argv[1][0] != '/') && (argv[1][0] != '?')) {

        if (!load_stuff()) {
            fprintf(stderr, "Couldn't read rc info\n");
        }

        load_active_file();
        close_active();


        for (i = 1; i < argc; i++) {

            /* check that the group exists - also prevent del of 'junk' */
            gp = find_news_group(argv[i]);

            if (stricmp(gp->group, "junk") != 0) {

                /* form the directory name */
                dir = make_news_group_name(argv[i]);
                unlink(dir);
                sprintf(buf, "%s.IDX", dir);
                unlink(buf);

                printf("rmgroup: %s: files gone... ", argv[i]);

                /* finally remove it from the active file */
                sprintf(buf, "%sactive", my_stuff.news_dir);
                if ((active_file = fopen(buf, "rb")) == NULL) {
                    fprintf(stderr, "\nrmgroup: cannot open %s\n", buf);
                    exit(1);
                }

                sprintf(buf, "%sactive.new", my_stuff.news_dir);
                if ((new_active_file = fopen(buf, "wb")) == NULL) {
                    fprintf(stderr, "\nrmgroup: cannot create %s\n", buf);
                    exit(1);
                }

                while (fgets(buf, 255, active_file) != NULL) {
                    strcpy(buf2, buf);
                    p = strtok(buf2, " \t");
                    if (stricmp(argv[i], p) != 0) {
                        if (fputs(buf, new_active_file) == EOF) {
                            fprintf(stderr, "\nrmgroup: couldn't write new active file\n");
                        }
                    } else {
                        printf("removed from active file\n",
                               argv[i]);
                    }
                }

                fclose(active_file);
                fclose(new_active_file);

                /* rename the active to a .bak and the .new to the active */
                sprintf(buf, "%sactive.bak", my_stuff.news_dir);
                unlink(buf);
                sprintf(buf2, "%sactive", my_stuff.news_dir);
                rename(buf2, buf);
                sprintf(buf, "%sactive.new", my_stuff.news_dir);
                rename(buf, buf2);


            } else {
				fprintf(stderr, "rmgroup: newsgroup %s not found\n", argv[i]);
            }

        }

        close_active_file();

    } else {
		printf("usage: rmgroup group.name ...\n");
    }

}
