\  TABULAR.S
\  demotest sample table

\  This table processes a tabular file and breaks the columns into separate
\  coded segments. This is accomplished by a sequence of wild card
\  searches, one for each tab column (except the last column, where we
\  let the carriage return take care of the last tab stop).

\  This table is a neat way to break tabular files into something that
\  a typesetting or desktop publishing system can work with, instead of
\  having to manually insert bloody codes between columns.

\  The column widths are set up for DEMOTEST. on the distribution disk

\  These equations assume that there are at least two spaces between each
\  column. You can, of course, change this requirement to suit your needs.

\  There will still be spaces between the columns after this conversion, so
\  run the table TABULAR2.S next. That table will remove the extra spaces
\  between columns for cleaner formatting.

\  The difference between this method of column processing and the
\  one used in SPC2TAB.S is that this method has better control over the
\  columns, and you can change the codes emitted between columns. Also,
\  this method correctly handles the case where a blank column occurs once
\  in a while in the tabular copy. The other table won't let you do that; it
\  simply squishes multiple adjacent spaces into a single tab code.

\  To modify this table for other column widths, just change the
\  repeater values.


\ ----------------------------------------------------------------------------

\  The column widths are set up for DEMOTEST.DOC on the distribution disk

*(19)\v  *(16)\v  *(13)\v  *(13)\v  =      \+  continued on next line
[bt*(19)\p0[ql[nt  *(16)\p21[qr[nt  *(13)\p39[qr[nt  *(13)\p54[cm\20\20*01

\  A carriage return will always set the flag for the first column of data.
\  But if the flag for the last column is ON (*01), then an appropriate line
\  terminator is output also.

\  The double spaces which are output in each replacement will be removed
\  in a subsequent pass (TABULAR2.S). They are there simply because there are
\  two spaces on the search side which separate columns.

\0d\0a*01=[et\0d\0a*00     \ ...4 columns have been processed, in which
                           \    case output end of tab and set flag for
                           \    column 1
