/*
**  STRDEL.C - Removes specified characters from a string
**
**  public domain demo by Bob Stout
*/

#include <stdio.h>
#include <string.h>

char *strdel(char *string, size_t first, size_t len)
{
      char *pos0, *pos1;

      if (string)
      {
            if (first < strlen(string))
            {
                  for (pos0 = pos1 = string + first;
                        *pos1 && len;
                        ++pos1, --len)
                  {
                        ;
                  }
                  strcpy(pos0, pos1);
            }
      }
      return string;
}

#ifdef TEST

main(int argc, char *argv[])
{
      int pos, len;

      if (4 > argc)
      {
            puts("Usage: STRDEL string pos len");
            puts("Deletes 'len' characters starting at position 'pos'");
            return -1;
      }
      pos = atoi(argv[2]);
      len = atoi(argv[3]);
      printf("strdel(\"%s\", %d, %d) => ", argv[1], pos, len);
      printf("\"%s\"\n", strdel(argv[1], pos, len));
      return 0;
}

#endif /* TEST */

