/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

/**
 * SNMP KTIMETICK Type
 * @see Type
 * @version     $Id: TypeTimeTick.java,v 1.3 1997/05/18 08:11:54 alex Exp $
 * @author      Alex Kowalenko
 */

public class TypeTimeTick extends TypeInt {

    static byte asnValue = ASN.TIMETICKS;
    static String name = "TimeTicks";

/**
 * Constructor
 */    

    TypeTimeTick() {
	super();
    }

/**
 * Constructor from integer
 */

    TypeTimeTick(int value) {
	super(value);
    }

/**
 * Constructor from ByteBuffer
 */

    TypeTimeTick(ByteBuffer buffer) {
	super(buffer);
    };

/**
 * returns name of Type
 */

    String typeName() {
	return name;
    };
  
/**
 * SNMP protocol conversion.  Convert the variable to a sequence of 
 * bytes, according to SNMP Protocol rules.
 */

  public ByteBuffer BERSerialize() {
      ByteBuffer buffer = super.BERSerialize();
      if(buffer.size() > 0)
	  buffer.setByteAt(0, asnValue);
      return buffer;
  };

/**
 * Return a String representation of the type
 */

  public String toString() {
      int d, h, m, s, ds;
    
      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (");
     
      ds = value();
      s = ds / 100; ds = ds % 100;
      m = s / 60;    s = s  % 60;
      h = m / 60;    m = m  % 60;
      d = h / 24;    h = h  % 24;
    
      if( d > 0)
	  result.append( d + " days, ");
      if( d > 0 || h > 0)
	  result.append( h + " hours, ");
      if(d > 0 || h > 0 || m > 0)
	  result.append( m + " minutes ");
      result.append(s);
      if(ds > 0)
	  result.append("." + ds);
      result.append(" seconds)");
      return result.toString();
  }

};
