/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

public class TypeString extends Type {

/**
 * SNMP STRING type
 * @see Type
 * @version     $Id: TypeString.java,v 1.4 1997/05/18 08:11:54 alex Exp $
 * @author      Alex Kowalenko
 */

    static byte asnValue = ASN.OCTET_STR;
    static String name = "STRING";
  
  private String _value;

/**
 * Constructor
 */    

    TypeString() {
	_value = new String();
    }

/**
 * Constructor from string
 */

    TypeString(String value) {
	_value = value;
    }

/**
 * Constructor from ByteBuffer
 */

    TypeString(ByteBuffer buf) {
	int length = ASN.getLength(buf);
	if(length == 0)
	    _value = new String();
	else
	    _value = buf.toString(length);
	buf.removeBeginning(length);
	return;
    }

/**
 * returns name of Type
 */

    String typeName() {
	return name;
    };
  
/**
 * Will read a value for the variable from String
 */ 
  
    boolean read(String str) {
	_value = str;
	return true;
    };

/**
 * Returns the String value
 */

    String value() {
	return _value;
    }

/**
 * SNMP protocol conversion.  Convert the variable to a sequence of 
 * bytes, according to SNMP Protocol rules.
 */

    public ByteBuffer BERSerialize() {
	ByteBuffer buffer = new ByteBuffer();
	buffer.append(asnValue);
	buffer.append(ASN.buildLength(_value.length()));
	buffer.append(_value);
	return buffer;
    };

/**
 * Return a String representation of the type
 */

  public String toString() {
      return _value;
  };

};
