/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

/**
 * SNMP NULL type
 * @see Type
 * @version     $Id: TypeNull.java,v 1.3 1997/05/18 08:11:54 alex Exp $
 * @author      Alex Kowalenko
 */

public class TypeNull extends Type {

    static byte asnValue = ASN.NULL;
    static String name = "NULL";

/**
 * Constructor
 */    

    TypeNull(){        
    };

/**
 * Constructor from ByteBuffer
 */

    TypeNull(ByteBuffer buffer) throws SnmpPDUException {  
	if(buffer.byteAt(0) != 0x00)
	    throw new SnmpPDUException("TypeNull: error in null type");
	buffer.removeBeginning(1);
    };

/**
 * returns name of Type
 */

    String typeName() {
	return name;
    };
  
/**
 * Will read a value for the variable from String
 */ 
 
    boolean read(String str) {
	return true; // Nothing to read
    };

/**
 * SNMP protocol conversion.  Convert the variable to a sequence of 
 * bytes, according to SNMP Protocol rules.
 */

    public ByteBuffer BERSerialize() {
	ByteBuffer buffer = new ByteBuffer();
	buffer.append(asnValue);
	buffer.append((byte) 0x00); // Length
	return buffer;
    };

/**
 * Return a String representation of the type
 */

  public String toString() {
      return typeName();
  };

};
