/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

/**
 * Representation of SNMP INTEGER type.
 * @see Type
 * @version     $Id: TypeInt.java,v 1.5 1997/05/18 08:11:54 alex Exp $
 * @author      Alex Kowalenko
 */

public class TypeInt extends Type {
  
    static byte asnValue = ASN.INTEGER;
    static String name = "INTEGER";

  private int _value;

/**
 * Constructor
 */    

    TypeInt() {
	_value = 0;
    }

/**
 * Constructor from integer
 */

    TypeInt(int value) {
	_value = value;
    }

/**
 * Constructor from ByteBuffer
 */

    TypeInt(ByteBuffer buf) {
	int length = ASN.getLength(buf);
	_value = 0;    
	int i = -1;
	int len = length;
	while(len> 0) {
	    i++; len--;
	    _value <<=  8;
	    short temp = (byte) buf.byteAt(i);
	    if(temp < 0)
		temp += 256;
	    _value += temp;
	};
	buf.removeBeginning(length);
	return;
    };

/**
 * returns name of Type
 */

    String typeName() {
	return name;
    };
  
/**
 * Will read a value for the variable from str
 */

    boolean read(String str) {
	_value = Integer.valueOf(str).intValue();
	return true;
    };

/** 
 * Get the integer value
 */

    int value() {
	return _value;
    }

/**
 * SNMP protocol conversion.  Convert the variable to a sequence of 
 * bytes, according to SNMP Protocol rules.
 */

    public ByteBuffer BERSerialize() {
	ByteBuffer buffer = new ByteBuffer();
	byte lenght = 4;
	int integer = _value; 
	long mask = 0x1FF << 24;
	while((((integer & mask) == 0) || ((integer & mask ) == mask)) 
	      && lenght > 1 ) {
	    integer  <<= 8;
	    lenght --;
	}
	buffer.append(asnValue);
	buffer.append(lenght);
	mask = 0xFF << 24;
	while((lenght--) > 0) {
	    buffer.append( (byte) ((integer & mask ) >> 24));
	    integer <<= 8;
	};
	return buffer;
    };

/**
 * Return a String representation of the type
 */

  public String toString() {
      return Integer.toString(_value);
  };

/**
 * Test Harness 
 */
    
    static void testInt(TypeInt t) {
	System.out.println("value is " + t );
	StringUtil.Hexdump(t.BERSerialize());
	ByteBuffer b = t.BERSerialize();
	b.removeBeginning(1);
	TypeInt newT = new TypeInt(b);
	System.out.println("reserialise type is " + newT);
    };

/**
 * Test Harness 
 */
    
  public static void main(String args[]) {
      TypeInt t = new TypeInt(6);
      testInt(t);
      t = new TypeInt(314);
      testInt(t);
      t = new TypeInt(3141);  
      testInt(t);
      t = new TypeInt(314159);  
      testInt(t);
  };

};
