/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

/**
 * SNMP IP Address type
 * @see Type
 * @version     $Id: TypeIPAddress.java,v 1.3 1997/05/18 08:11:54 alex Exp $
 * @author      Alex Kowalenko
 */

public class TypeIPAddress extends Type {

    static byte asnValue = ASN.IPADDRESS;
    static String name = "IpAddress";

  private byte _value[];

/**
 * Constructor
 */    

    TypeIPAddress() {
	_value = new byte[4];
	_value[0] = 0;
	_value[1] = 0;
	_value[2] = 0;
	_value[3] = 0;
    }

/**
 * Constructor from string
 */

    TypeIPAddress(String value) {
	_value = new byte[4];
	read(value);
    }

/**
 * Constructor from ByteBuffer
 */
  
    TypeIPAddress(ByteBuffer buf) throws SnmpPDUException {
	_value = new byte[4];
	byte length = buf.byteAt(0);
	if(length > 4)
	    throw new SnmpPDUException("SnmpTypeIPAddress : Invalid lenght for IP address");
   
	if(buf.size() < length + 1)
	    throw new SnmpPDUException("SnmpTypeIPAddress : Invalid lenght for IP address");
    
	// Code for parsing IpAddress
	int i = -1;
	int len = length;
	while(len-- > 0) {
	    i++;
	    _value[i] =  buf.byteAt(i+1);
	}
	buf.removeBeginning(1+length);
	return;
    };

/**
 * returns name of Type
 */

    String typeName() {
	return name;
    };

/**
 * Will read a value for the variable from String
 */ 

    boolean read(String value) {
	int index = 0;
	StringBuffer substr = new StringBuffer();
	for(int i = 0; i < value.length(); i++) {
	    if(value.charAt(i) == '.') {
		if(substr.length() == 0)
		    return  false;
		_value[index] = (byte) Integer.valueOf(substr.toString()).intValue();
		index ++;
		substr = new StringBuffer();
	    }
	    else if (Character.isDigit(value.charAt(i)))
		substr.append(value.charAt(i));
	    else
		return false;
	}
	_value[index] = (byte) Integer.valueOf(substr.toString()).intValue();
	return true;
    };

/**
 * SNMP protocol conversion.  Convert the variable to a sequence of 
 * bytes, according to SNMP Protocol rules.
 */

    public ByteBuffer BERSerialize() {
	ByteBuffer buffer = new ByteBuffer();
	buffer.append(asnValue);
	buffer.append((byte) 0x04);
	buffer.append(_value[0]);
	buffer.append(_value[1]);
	buffer.append(_value[2]);
	buffer.append(_value[3]);
	return buffer;
    
    };

/**
 * Return a String representation of the type
 */

  public String toString() {
      String str = new String();
      for(int i = 0; i < 4; i++)
	  if(_value[i] < 0)
	      str += (256 + _value[i]) + ".";
	  else
	      str += _value[i] + ".";
      return str;
  };

};
