/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

/**
 * SNMP GAUGE type
 * @see TypeInt
 * @see Type
 * @version     $Id: TypeGauge.java,v 1.3 1997/05/18 08:11:54 alex Exp $
 * @author      Alex Kowalenko
 */

public class TypeGauge extends TypeInt {

    static byte asnValue = ASN.GAUGE;
    static String name = "Gauge";
 
/**
 * Constructor
 */
    
    TypeGauge() {
	super();
    }

/**
 * Constructor from integer
 */

    TypeGauge(int value) {
	super(value);
    }

/**
 * Constructor from ByteBuffer
 */

    TypeGauge(ByteBuffer buffer) {
	super(buffer);
    };

/**
 * returns name of Type
 */

    String typeName() {
	return name;
    };
  
/**
 * SNMP protocol conversion.  Convert the variable to a sequence of 
 * btyes, according to SNMP Protocol rules.
 */

    public ByteBuffer BERSerialize() {
	ByteBuffer buffer = super.BERSerialize();
	if(buffer.size() > 0)
	    buffer.setByteAt(0, asnValue);
	return buffer;
    };

};
