/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

/**
 * This class has some useful static member functions.
 * @version     $Id: StringUtil.java,v 1.2 1997/05/12 12:17:48 alex Exp $
 * @author      Alex Kowalenko
 */

package aka.snmp;

import java.util.*;

public class StringUtil {
  
/**
 * Is a String a numeric constant?
 */

  public static boolean isNumeric(String str) {
      for(int i = 0; i < str.length(); i++)
	  if(!Character.isDigit(str.charAt(i)))
	      return false;
      return true;
  };

/**
 * Provide a Hexdump of a ByteBuffer
 */

  public static void Hexdump(ByteBuffer buffer) {
      int size = buffer.size();
      System.err.println("Buffer size : " + size);
      System.err.println("--------------------------------------------------");
      for(int i = 0; i < (size < 200 ? size : 200); i ++) {
	  System.err.print(Integer.toHexString((int) buffer.byteAt(i)));
	  if(buffer.byteAt(i) > 0x20 && buffer.byteAt(i) < 0x80)
	      System.err.print("[" + (char) buffer.byteAt(i) + "] ");
	  else
	      System.err.print("[ ] ");
	  if((i % 16 ) == 15)
	      System.err.println("");
      };
      System.err.println("");
      return;
  };

/**
 * Test harness
 */

  public static void main(String args[]) {
      System.out.println("Is numeric dog? : " + isNumeric("dog"));
      System.out.println("Is numeric 1? : " + isNumeric("1"));
      // Hexdump(new StringBuffer("Holden Caulfield, Catcher in the Rye"));
  };

};
