/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

$Id: Status.java,v 1.4 1997/05/21 10:09:56 alex Exp $

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

/**
 * The STATUS attribute of a SNMP object
 * @version     $Id: Status.java,v 1.4 1997/05/21 10:09:56 alex Exp $
 * @author      Alex Kowalenko
 */

import java.io.*;

public class Status implements Serializable {

    final static int VOID = -1;
    final static int MANDATORY = 1;
    final static int OPTIONAL = 2;
    final static int OBSOLETE = 3;

  private int _value;
  
/**
 * Constructor, sets the Status object to VOID
 */

  public Status() {
      _value = VOID;
  };

/**
 * Constructor using the status
 */
  
  public Status(int theStatus) {
      _value = theStatus;
  };

/**
 * Constructor from the string representation
 */

  public Status(String string) {
      if(string.equals("mandatory"))
	  _value = MANDATORY;
      else if(string.equals("optional"))
	  _value = OPTIONAL;
      else if(string.equals("obsolete"))
	  _value = OBSOLETE;
      else _value = VOID;
  };

/**
 * Returns the status value 
 */

  public int value() {
      return _value;
  };

/**
 * Returns a string representation
 */

  public String toString() {
      switch( _value) {
	case MANDATORY: 
	  return "Mandatory";
	case OPTIONAL:
	  return "Optional";
	case OBSOLETE:
	  return "Obsolete";
      }
      //  case VOID:
      // default:     
      return "Unknown";
  }

/**
 * Test harness
 */
  
  public static void main(String args[]) {
      Status s = new Status();
      System.out.println(s);
      s = new Status(Status.MANDATORY);
      System.out.println(s);
  }

}
