/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

$Id: SnmpError.java,v 1.2 1997/05/08 13:04:47 alex Exp $

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

/**
 * This is the SNMP error attribute found in SNMP response packets
 * @version     $Id: SnmpError.java,v 1.2 1997/05/08 13:04:47 alex Exp $
 * @author      Alex Kowalenko
 */

public class SnmpError {

    final static int NO_ERROR = 0;
    final static int TOO_BIG = 1;
    final static int NO_SUCH_NAME = 2;
    final static int BAD_VALUE = 3;
    final static int READ_ONLY = 4;
    final static int GEN_ERROR = 5;
  
  private int _value;
  
/**
 * Constructor, initalizes it to NO_ERROR
 */

  public SnmpError() {
      _value = NO_ERROR;
  };

/**
 * Constructor
 */
  
  public SnmpError(int theError) {
      _value = theError;
  };

/**
 * Returns the value of the error
 */

  public int value() {
      return _value;
  };

/** 
 * Sets the error from the byte value
 */

    void parse(int val) throws SnmpPDUException {
	switch(val) {
	  case 0 : _value = NO_ERROR;
	    break;
	  case 1 : _value = TOO_BIG;
	    break;
	  case 2 : _value = NO_SUCH_NAME;
	    break;
	  case 3 : _value = BAD_VALUE;
	    break;
	  case 4 : _value = READ_ONLY;
	    break;
	  case 5 : _value = GEN_ERROR;
	    break;
	  default :
	    _value = NO_ERROR;
	    throw new SnmpPDUException("SnmpError : Unknown Error Value ");
	};
	return;
    }

/**
 * Returns the string representation of the SNMP error
 */

  public String toString() {
      switch( _value) {
	case TOO_BIG: 
	  return "to big";
	case NO_SUCH_NAME:
	  return "no such name";
	case BAD_VALUE:
	  return "bad value";
	case READ_ONLY:
	  return "read only";
	case GEN_ERROR:
	  return "general error";
      }
      return "No error";
  }

/**
 * Test Harness
 */
  
    static public void main(String args[]) {
	SnmpError s = new SnmpError();
	System.out.println(s);
	s = new SnmpError(SnmpError.NO_SUCH_NAME);
	System.out.println(s);
    }

}
