/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

/**
 * This class implements a pair of SNMP Object ID and Type.  It
 * is used in PDU which stores a list these pairs
 * @see PDU
 * @version     $Id: PDUVariable.java,v 1.4 1997/05/18 08:11:54 alex Exp $
 * @author      Alex Kowalenko
 */

public class PDUVariable implements BERSerializable {
  
  private ObjectId  _id;
  private Type _value;
  
/**
 * Constructor
 */

    PDUVariable(ObjectId id, Type value) {
	_id = id;
	_value = value;
    };
  
/**
 * Create a pair from the chacter sequence in buf.  When
 * finished the character that consituted the the pair will
 * be removed from buf.
 */

    PDUVariable(ByteBuffer buf) throws SnmpPDUException {
	// Get CONSTRUCTOR | SEQUENCE
	if(buf.byteAt(0) != (ASN.SEQUENCE | ASN.CONSTRUCTOR)) {
	    throw new SnmpPDUException("PDUVariable: Not a sequence of Variable-Value");
	};
	buf.removeBeginning(1);
	
	int length = ASN.getLength(buf);
	
	// Parse Object ID
	if(buf.byteAt(0) != ASN.OBJECT_ID) { 
	    throw new SnmpPDUException("PDUVariable: Expecting an Object ID");
	}
	buf.removeBeginning(1);
	_id = new ObjectId(buf);
	
	// Parse Value
	_value = Type.parse(buf);
	return;
    };
    
/**
 * Return the SNMP Object ID from the pair.
 */

    ObjectId oid() {
	return _id;
    };

/**
 * Return the Type object from the pair.
 */

    Type value() {
	return _value;
    };

/**
 * Create a sequence of characters that represent the pair.
 * according to the rules of SNMP Protocol.
 */

    public ByteBuffer BERSerialize() {
	ByteBuffer buffer = new ByteBuffer();
	buffer.append(_id.BERSerialize());
	buffer.append(_value.BERSerialize());
	ByteBuffer newbuffer = new ByteBuffer();
	newbuffer.append((byte) (ASN.SEQUENCE | ASN.CONSTRUCTOR ));
	newbuffer.append(ASN.buildLength(buffer.size())); 
	newbuffer.append(buffer);
	return newbuffer;
    };

/**
 * Creates a String representation 
 */

  public String toString() {
      return "{" + _id + ", " + _value + "}";
  }
  
};
