/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

$Id: Operation.java,v 1.2 1997/05/08 13:04:47 alex Exp $

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

/**
 * Snmp Operations
 * @see Pdu
 * @version     $Id: Operation.java,v 1.2 1997/05/08 13:04:47 alex Exp $
 * @author      Alex Kowalenko
 */

public class Operation {

    final static byte VOID = 99;
    final static byte GET =  0;
    final static byte GET_NEXT = 1;
    final static byte RESPONSE = 2;
    final static byte SET = 3;
    final static byte TRAP = 4;
  
  private byte _value;
  
/**
 * Default constructor
 */

  public Operation() {
      _value = VOID;
  };

/** 
 * Constucts from a byte representation
 */
  
  public Operation(byte theOperation) {
      _value = theOperation;
  };

/**
 * Constructs from a string representation
 */

  public Operation(String name) {
      if(name.equals("get"))
	  _value = GET;
      else if(name.equals("getnext")) 
	  _value = GET_NEXT;
      else if(name.equals("response"))
	  _value = RESPONSE;
      else if(name.equals("set"))
	  _value = SET;
      else if(name.equals("trap"))
	  _value = GET;
      else 
	  _value = VOID;
  };

/**
 * Returns the byte representation
 */

  public byte value() {
      return _value;
  };

/**
 * Returns the string representation
 */

  public String toString() {
      switch( _value) {
	case GET: 
	  return "SNMP Get";
	case GET_NEXT:
	  return "SNMP Get Next";
	case RESPONSE:
	  return "Snmp Response";
	case SET: 
	  return "SNMP Set";
	case TRAP:
	  return "SNMP Trap";
      }
      //  case VOID:
      // default:     
      return "Unknown";
  }

/**
 * Test Harness
 */
  
    static public void main(String args[]) {
	Operation s = new Operation();
	System.out.println(s);
	s = new Operation(Operation.GET_NEXT);
	System.out.println(s);
    }

}
