/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

$Id: MibManagerSerializer.java,v 1.2 1997/05/29 12:54:32 alex Exp $

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

import java.util.*;
import java.io.*;

/**
 * Extends MibManagerPaser with methods to store and retrieve the
 * managed object definitions as a Java serialized file.
 * @see SnmpObject
 * @version     $Id: MibManagerSerializer.java,v 1.2 1997/05/29 12:54:32 alex Exp $
 * @author      Alex Kowalenko
 */

public class MibManagerSerializer extends MibManagerParser {

/**
 * Constructor
 */

  public MibManagerSerializer() {
      super();
  };
  
/**
 * Store the Managed Object definitions to a file.
 * @see MibManager#SerializeFromFile
 */

  public void SerializeToFile(String filename) 
      throws FileNotFoundException, IOException {
	  FileOutputStream f = new FileOutputStream(filename);
	  ObjectOutput s = new ObjectOutputStream(f);
	  for(Enumeration e = _tableName.elements(); e.hasMoreElements(); ) {
	      s.writeObject((SnmpObject)e.nextElement());
	  };
	  s.flush();
	  s.close();
  };

/**
 * Read the Managed object defintion from a BER encoded file
 * @see MibManagerSerializer#SerializeToFile
 */

  public void SerializeFromFile(String filename)  
      throws FileNotFoundException, IOException, SnmpMibException {
	  FileInputStream f = new FileInputStream(filename);
	  ObjectInput s = new ObjectInputStream(f);
	  try {
	      while(true) {
		  SnmpObject obj = (SnmpObject) s.readObject();
		  _tableName.put(obj.name(), obj);
		  _tableID.put(obj.id(), obj);
	      };
	  } catch(IOException e) {
	      // System.out.println(e.getMessage());
	      // finish
	  } catch(ClassNotFoundException e) {
	      throw new SnmpMibException("Serialization problem: " + 
					 e.getMessage());
	  }
	  finally {
	      s.close();
	  };
  };

/**
 * Test harness
 */
    
  public static void main(String args[]) {
      PrintStream out = System.out;

      out.println("Creating SNMP MIB MANAGER");
      MibManagerSerializer mibs = new MibManagerSerializer();

      out.println("Reading SNMP mib");
      try {
	  mibs.addFromMibDefFile("mib1.txt");
      } catch(FileNotFoundException e) {
	  out.println("File not found");
	  return;
      } catch(Exception e) {
	  out.println("Exception");
	  e.printStackTrace();
	  mibs.dump();
      };

      mibs.dump();

      try {
	  out.println("Write to serialization file");
	  mibs.SerializeToFile("mibs.ser");
      } catch(Exception e) {
	  out.println("Excepton with SerializeFromFile : " + e.getMessage());
	  e.printStackTrace();
      };

      MibManagerSerializer mib3 = new MibManagerSerializer();
      try {
	  out.println("Read from serialization file");
	  mib3.SerializeFromFile("mibs.ser");
      } catch(Exception e) {
	  out.println("Excepton with SerializeToFile : " + e.getMessage());
	  e.printStackTrace();
      };
      mib3.dump();

  };

};
