/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

$Id: MibManagerParser.java,v 1.2 1997/06/05 11:59:22 alex Exp $

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

import aka.mc.*;
import java.util.*;
import java.io.*;

/**
 * Extends MibManager with the managed object compiler.
 * @see MibManager
 * @version     $Id: MibManagerParser.java,v 1.2 1997/06/05 11:59:22 alex Exp $
 * @author      Alex Kowalenko
 */

public class MibManagerParser extends MibManager {

/**
 * Constructor
 */

  public MibManagerParser() {
      super();
  };
  

/** 
 * Read MIB defintions from MIB file.  This file is parse and SNMP Object
 * definitions extracted
 */

  public void addFromMibDefFile(String fileName) 
      throws FileNotFoundException, SnmpMibException {
	  BufferedInputStream input 
	      = new BufferedInputStream(new FileInputStream(fileName));
	  Parser parser = new Parser();
	  parser.setMibManager(this);
	  parser.setInputStream(input);
	  try {
	      parser.parse();
	  } catch (Exception e) {
	      e.printStackTrace();
	      throw new SnmpMibException(e.getMessage());
	  }
	  return;
  }

/**
 * Test harness
 */
    
  public static void main(String args[]) {
      PrintStream out = System.out;

      out.println("Creating SNMP MIB MANAGER");
      MibManagerParser mibs = new MibManagerParser();

      out.println("Reading SNMP mib");
      try {
	  mibs.addFromMibDefFile("mib1.txt");
      } catch(FileNotFoundException e) {
	  out.println("File not found");
	  return;
      } catch(Exception e) {
	  out.println("Exception");
	  e.printStackTrace();
	  mibs.dump();
      };

      mibs.dump();
  }
}
