/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

$Id: MibManagerMosy.java,v 1.1 1997/05/21 13:25:18 alex Exp $

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

import java.util.*;
import java.io.*;

/**
 * This class extends MibManager with a routine to read MOSY compiled files.
 * The mosy compiler is part of the ISODE package 6.0, and is obsolete.
 * @see MibManager
 * @version     $Id: MibManagerMosy.java,v 1.1 1997/05/21 13:25:18 alex Exp $
 * @author      Alex Kowalenko
 */

public class MibManagerMosy extends MibManager {

/**
 * Constructor
 */

  public MibManagerMosy() {
      super();
  };
  
/**
 * Reads from SNMP Objects from MOSY processed file and stores them.
 * @deprecated - MOSY compiler for SNMP V1 not avaliable
 * 
 */

  public void addFromMosyFile(String fileName) 
      throws FileNotFoundException, SnmpMibException {
	  
	  BufferedReader input = new BufferedReader(new FileReader(fileName));
	  
	  try {
	      // input.skipBytes(0); // needed  to init DataInputStream 
	      while(true) { 
                  // Exception on readline() exits loop
		  String line = input.readLine();
		  if(line == null)
		      return;

		  line = line.trim();
   
		  StringTokenizer tokens = new StringTokenizer(line, " \t");
		  String firstToken;

		  if(tokens.countTokens() == 0)
		      continue;
		  firstToken = tokens.nextToken();

		  if(firstToken.equals("--"))  // comment
		      continue;
	
		  if(tokens.countTokens() == 1 ) {
		      
		      String name = firstToken;
		      String id = tokens.nextToken();
		      // top tree definitions
		      ObjectId baseID = baseForm(id);
		      if(!baseID.isValid())
			  throw new SnmpMibException("Can't find SNMP object : " + id);
	  
		      SnmpObject obj = new SnmpObject(name, baseID.toString());
		      if(_tableName.contains(name)) 
			  throw new SnmpMibException("Duplicate object : " + 
						     id);
		      _tableName.put(name, obj);
		      _tableID.put(baseID, obj);  
		  }
		  else if(tokens.countTokens() == 4) {
		      String name = firstToken;
		      String id = tokens.nextToken();
		      String typeStr = tokens.nextToken();
		      String accessStr = tokens.nextToken();
		      String statusStr = tokens.nextToken();

		      ObjectId baseID = baseForm(id);
		      Access acc;
		      Status stat;
		      String type;
	  
		      if(!baseID.isValid())
			  throw new SnmpMibException("Can't find SNMP object : " + id);
            
		      if(typeStr.equals("Aggregate")) {
			  // Aggregates are node objects in the tree
			  SnmpObject obj = new SnmpObject(name, 
							  baseID.toString());
			  if(_tableName.contains(name)) 
			      throw new SnmpMibException("Duplicate object : " + id);
			  _tableName.put(name, obj);
			  _tableID.put(baseID, obj); 
		      }
		      else {
			  acc = new Access(accessStr);
			  stat = new Status(statusStr);
	    
			  if(typeStr.equals("DisplayString") 
			     || typeStr.equals("OctetString")
			     || typeStr.equals("Opaque"))
			      type = "STRING";
			  else if(typeStr.equals("NetworkAddress"))
			      type = "IpAddress";
			  else
			      type = typeStr;
	    
			  SnmpObject obj = new SnmpObject(name, 
							  baseID, 
							  type, 
							  acc, 
							  stat);
			  if(_tableName.contains(name))
			      throw new SnmpMibException("Duplicate object : " + id);
			  _tableName.put(name, obj);
			  _tableID.put(baseID, obj);
		      }
		  }
	      }
	  } catch(IOException e) {
	      return;
	  };
  };

/**
 * Test Harness
 */

  public static void main(String args[]) {
      PrintStream out = System.out;

      out.println("Creating SNMP MIB MANAGER");
      MibManagerMosy mibs = new MibManagerMosy();

      out.println("Reading SNMP mib");
      try {
	  mibs.addFromMosyFile("x.mibs");
      } catch(FileNotFoundException e) {
	  out.println("File not found");
	  return;
      } catch(Exception e) {
	  out.println("Exception");
	  e.printStackTrace();
	  mibs.dump();
      };

      mibs.dump();
  }

}
