/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

$Id: MibManagerBER.java,v 1.1 1997/05/21 13:25:18 alex Exp $

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

import java.util.*;
import java.io.*;

/**
 * Extends MibManagerPaser with methods to store and retrieve the
 * managed object definitions as an ASN BER encoded file.
 * @see SnmpObject
 * @version     $Id: MibManagerBER.java,v 1.1 1997/05/21 13:25:18 alex Exp $
 * @author      Alex Kowalenko
 */

public class MibManagerBER extends MibManagerParser {

/**
 * Constructor
 */

  public MibManagerBER() {
      super();
  };
  

/**
 * Store the Managed Object definitions to a file, using BER encoding
 * (This implements serializing of the MIB in Java 1.0).
 * Use MibManagerSerialize which uses
 * Java 1.1 serialization.  Though these routines are faster and more 
 * compact than Java 1.1 serialization
 * @see MibManagerSerialize
 */

  public void BERSerializeToFile(String filename) 
      throws FileNotFoundException, IOException {
	  
	  BufferedOutputStream output 
	      = new BufferedOutputStream(new FileOutputStream(filename));
	  for(Enumeration e = _tableName.elements(); e.hasMoreElements(); ) {
	      ByteBuffer buf = ((SnmpObject)e.nextElement()).BERSerialize();
	      output.write(buf.array(), 0, buf.size()); 
	  };
	  output.close();
	  return;
  };

/**
 * Read the Managed object defintion from a BER encoded file
 * Use MibManagerSerialize which uses
 * Java 1.1 serialization. Though is faster and more compact than Java
 * 1.1 serialization.
 * @see MibManagerSerialize
 */

  public void BERSerializeFromFile(String filename) 
      throws FileNotFoundException, IOException, SnmpPDUException{
	    
	  FileInputStream input = new FileInputStream(filename);
	  ByteBuffer buffer = new ByteBuffer();
	  byte b[] = new byte[2048];
	  int count = input.read(b);
	  while(count > 0) {
	      buffer.append(b, count);
	      count = input.read(b);
	  };
	  while(buffer.size() > 0) {
	      SnmpObject obj = new SnmpObject(buffer);
	      _tableName.put(obj.name(), obj);
	      _tableID.put(obj.id(), obj);
	  };
  };

  public static void main(String args[]) {
      PrintStream out = System.out;

      out.println("Creating SNMP MIB MANAGER");
      MibManagerBER mibs = new MibManagerBER();

      out.println("Reading SNMP mib");
      try {
	  mibs.addFromMibDefFile("mib1.txt");
      } catch(FileNotFoundException e) {
	  out.println("File not found");
	  return;
      } catch(Exception e) {
	  out.println("Exception");
	  e.printStackTrace();
	  mibs.dump();
      };

      //  mibs.dump();
      //  mibs.dump2();
  
      try {
	  out.println("Write to BER file");
	  mibs.BERSerializeToFile("mibs.ber");
      } catch(Exception e) {
	  out.println("Excepton with BERSerializeToFile : " + e.getMessage());
	  e.printStackTrace();
      };
  
      MibManagerBER mib2 = new MibManagerBER();
      try {
	  out.println("Read from BER file");
	  mib2.BERSerializeFromFile("mibs.ber");
      } catch(Exception e) {
	  out.println("Excepton with BERSerializeToFile : " + e.getMessage());
	  e.printStackTrace();
      };
      mib2.dump();
  }

};
